/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.ToolboxHandler;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.items.InternalStorageItem;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ToolboxItem
extends InternalStorageItem {
    public static final int SLOT_COUNT = 23;

    public ToolboxItem() {
        super("toolbox", new Item.Properties().func_200917_a(1));
        ToolboxHandler.addToolType(stack -> ((List)IEServerConfig.TOOLS.toolbox_tools.get()).contains(stack.func_77973_b().getRegistryName().toString()));
        ToolboxHandler.addFoodType(stack -> ((List)IEServerConfig.TOOLS.toolbox_foods.get()).contains(stack.func_77973_b().getRegistryName().toString()));
        ToolboxHandler.addWiringType((stack, world) -> ((List)IEServerConfig.TOOLS.toolbox_wiring.get()).contains(stack.func_77973_b().getRegistryName().toString()));
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            this.openGui(player, hand == Hand.MAIN_HAND ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        ItemStack stack = ctx.func_195996_i();
        PlayerEntity player = ctx.func_195999_j();
        if (player != null && player.func_225608_bj_()) {
            World world = ctx.func_195991_k();
            BlockPos pos = ctx.func_195995_a();
            Direction side = ctx.func_196000_l();
            BlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (!block.func_196253_a(state, new BlockItemUseContext(ctx))) {
                pos = pos.func_177972_a(side);
            }
            if (stack.func_190916_E() != 0 && player.func_175151_a(pos, side, stack)) {
                BlockState toolbox = IEBlocks.MetalDevices.toolbox.func_176223_P();
                if (world.func_180501_a(pos, toolbox, 3)) {
                    ((IEBaseBlock)IEBlocks.MetalDevices.toolbox).onIEBlockPlacedBy(new BlockItemUseContext(ctx), toolbox);
                    SoundType soundtype = world.func_180495_p(pos).func_177230_c().getSoundType(world.func_180495_p(pos), (IWorldReader)world, pos, (Entity)player);
                    world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    stack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.FAIL;
        }
        return super.func_195939_a(ctx);
    }

    @Override
    public int getSlotCount(ItemStack stack) {
        return 23;
    }
}

