/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.wires.IWireCoil;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.utils.WirecoilUtils;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class WireCoilItem
extends IEBaseItem
implements IWireCoil {
    @Nonnull
    private final WireType type;

    public WireCoilItem(WireType type) {
        super("wirecoil_" + type.getUniqueName().toLowerCase(), new Item.Properties());
        this.type = type;
    }

    @Override
    public WireType getWireType(ItemStack stack) {
        return this.type;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if ("REDSTONE".equals(this.type.getCategory())) {
            list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.flavour.coil.redstone"));
            list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.flavour.coil.construction1"));
        } else if ("STRUCTURE".equals(this.type.getCategory())) {
            list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.flavour.coil.construction0"));
            list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.flavour.coil.construction1"));
        }
        if (WirecoilUtils.hasWireLink(stack)) {
            WirecoilUtils.WireLink link = WirecoilUtils.WireLink.readFromItem(stack);
            list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.attachedToDim", new Object[]{link.cp.getX(), link.cp.getY(), link.cp.getZ(), link.dimension}));
        }
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        return WirecoilUtils.doCoilUse(this, ctx.func_195999_j(), ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_221531_n(), ctx.func_196000_l(), (float)ctx.func_221532_j().field_72450_a, (float)ctx.func_221532_j().field_72448_b, (float)ctx.func_221532_j().field_72449_c);
    }
}

