/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.client.render.entity.ShaderMinecartRenderer;
import blusunrize.immersiveengineering.common.network.IMessage;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class MessageMinecartShaderSync
implements IMessage {
    private int entityID;
    private boolean request = false;
    private ItemStack shader;

    public MessageMinecartShaderSync(Entity entity, Object o) {
        this.entityID = entity.func_145782_y();
        if (o instanceof CapabilityShader.ShaderWrapper) {
            this.shader = ((CapabilityShader.ShaderWrapper)o).getShaderItem();
        } else {
            this.request = true;
        }
    }

    public MessageMinecartShaderSync(PacketBuffer buf) {
        this.entityID = buf.readInt();
        this.request = buf.readBoolean();
        if (!this.request) {
            this.shader = buf.func_150791_c();
        }
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.entityID);
        buf.writeBoolean(this.request);
        if (!this.request) {
            buf.func_150788_a(this.shader);
        }
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        if (ctx.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            ServerWorld world = Objects.requireNonNull(ctx.getSender()).func_71121_q();
            ctx.enqueueWork(() -> {
                Entity entity = world.func_73045_a(this.entityID);
                if (entity == null) {
                    return;
                }
                LazyOptional cap = entity.getCapability(CapabilityShader.SHADER_CAPABILITY);
                cap.ifPresent(handler -> ImmersiveEngineering.packetHandler.send(PacketDistributor.DIMENSION.with(() -> ((ServerWorld)world).func_234923_W_()), (Object)new MessageMinecartShaderSync(entity, handler)));
            });
        } else {
            ctx.enqueueWork(() -> {
                Entity entity;
                World world = ImmersiveEngineering.proxy.getClientWorld();
                if (world != null && (entity = world.func_73045_a(this.entityID)) instanceof AbstractMinecartEntity) {
                    ShaderMinecartRenderer.shadedCarts.put(this.entityID, (Object)this.shader);
                }
            });
        }
    }
}

