/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;

public class ItemNBTHelper {
    public static boolean hasTag(ItemStack stack) {
        return stack.func_77942_o();
    }

    public static boolean hasKey(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) && stack.func_196082_o().func_74764_b(key);
    }

    public static boolean hasKey(ItemStack stack, String key, int type) {
        return ItemNBTHelper.hasTag(stack) && stack.func_196082_o().func_150297_b(key, type);
    }

    public static void remove(ItemStack stack, String key) {
        if (ItemNBTHelper.hasKey(stack, key)) {
            CompoundNBT tag = stack.func_196082_o();
            tag.func_82580_o(key);
            if (tag.isEmpty()) {
                stack.func_77982_d(null);
            }
        }
    }

    public static void putInt(ItemStack stack, String key, int val) {
        stack.func_196082_o().func_74768_a(key, val);
    }

    public static void modifyInt(ItemStack stack, String key, int mod) {
        ItemNBTHelper.modifyInt(stack.func_196082_o(), key, mod);
    }

    public static void modifyInt(CompoundNBT tagCompound, String key, int mod) {
        tagCompound.func_74768_a(key, tagCompound.func_74762_e(key) + mod);
    }

    public static int getInt(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? stack.func_196082_o().func_74762_e(key) : 0;
    }

    public static void putString(ItemStack stack, String key, String val) {
        stack.func_196082_o().func_74778_a(key, val);
    }

    public static String getString(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? stack.func_196082_o().func_74779_i(key) : "";
    }

    public static void putLong(ItemStack stack, String key, long val) {
        stack.func_196082_o().func_74772_a(key, val);
    }

    public static long getLong(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? stack.func_196082_o().func_74763_f(key) : 0L;
    }

    public static void putIntArray(ItemStack stack, String key, int[] val) {
        stack.func_196082_o().func_74783_a(key, val);
    }

    public static int[] getIntArray(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? stack.func_196082_o().func_74759_k(key) : new int[]{};
    }

    public static void putFloat(ItemStack stack, String key, float val) {
        stack.func_196082_o().func_74776_a(key, val);
    }

    public static void modifyFloat(CompoundNBT tagCompound, String key, float mod) {
        tagCompound.func_74776_a(key, tagCompound.func_74760_g(key) + mod);
    }

    public static float getFloat(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? stack.func_196082_o().func_74760_g(key) : 0.0f;
    }

    public static void putBoolean(ItemStack stack, String key, boolean val) {
        stack.func_196082_o().func_74757_a(key, val);
    }

    public static boolean getBoolean(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) && stack.func_196082_o().func_74767_n(key);
    }

    public static void setTagCompound(ItemStack stack, String key, CompoundNBT val) {
        stack.func_196082_o().func_218657_a(key, (INBT)val);
    }

    public static CompoundNBT getTagCompound(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? stack.func_196082_o().func_74775_l(key) : new CompoundNBT();
    }

    public static void setFluidStack(ItemStack stack, String key, FluidStack val) {
        if (val != null && val.getFluid() != null) {
            ItemNBTHelper.setTagCompound(stack, key, val.writeToNBT(new CompoundNBT()));
        } else {
            ItemNBTHelper.remove(stack, key);
        }
    }

    public static FluidStack getFluidStack(ItemStack stack, String key) {
        if (ItemNBTHelper.hasTag(stack)) {
            return FluidStack.loadFluidStackFromNBT((CompoundNBT)ItemNBTHelper.getTagCompound(stack, key));
        }
        return null;
    }

    public static void setItemStack(ItemStack stack, String key, ItemStack val) {
        stack.func_196082_o().func_218657_a(key, (INBT)val.func_77955_b(new CompoundNBT()));
    }

    public static ItemStack getItemStack(ItemStack stack, String key) {
        if (ItemNBTHelper.hasTag(stack) && stack.func_196082_o().func_74764_b(key)) {
            return ItemStack.func_199557_a((CompoundNBT)ItemNBTHelper.getTagCompound(stack, key));
        }
        return ItemStack.field_190927_a;
    }

    public static void setLore(ItemStack stack, ITextComponent ... lore) {
        CompoundNBT displayTag = ItemNBTHelper.getTagCompound(stack, "display");
        ListNBT list = new ListNBT();
        for (ITextComponent s : lore) {
            list.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)s)));
        }
        displayTag.func_218657_a("Lore", (INBT)list);
        ItemNBTHelper.setTagCompound(stack, "display", displayTag);
    }

    public static int insertFluxItem(ItemStack container, int energy, int maxEnergy, boolean simulate) {
        int stored = ItemNBTHelper.getFluxStoredInItem(container);
        int accepted = Math.min(energy, maxEnergy - stored);
        if (!simulate) {
            ItemNBTHelper.putInt(container, "energy", stored += accepted);
        }
        return accepted;
    }

    public static int extractFluxFromItem(ItemStack container, int energy, boolean simulate) {
        int stored = ItemNBTHelper.getFluxStoredInItem(container);
        int extracted = Math.min(energy, stored);
        if (!simulate) {
            ItemNBTHelper.putInt(container, "energy", stored -= extracted);
        }
        return extracted;
    }

    public static int getFluxStoredInItem(ItemStack container) {
        return ItemNBTHelper.getInt(container, "energy");
    }

    public static ItemStack stackWithData(ItemStack stack, Object ... data) {
        assert (data.length % 2 == 0);
        for (int i = 0; i < data.length / 2; ++i) {
            Object key = data[i];
            Object value = data[i + 1];
            if (!(key instanceof String)) continue;
            if (value instanceof Boolean) {
                ItemNBTHelper.putBoolean(stack, (String)key, (Boolean)value);
                continue;
            }
            if (value instanceof Integer) {
                ItemNBTHelper.putInt(stack, (String)key, (Integer)value);
                continue;
            }
            if (value instanceof Float) {
                ItemNBTHelper.putFloat(stack, (String)key, ((Float)value).floatValue());
                continue;
            }
            if (value instanceof Long) {
                ItemNBTHelper.putLong(stack, (String)key, (Long)value);
                continue;
            }
            if (value instanceof String) {
                ItemNBTHelper.putString(stack, (String)key, (String)value);
                continue;
            }
            if (value instanceof CompoundNBT) {
                ItemNBTHelper.setTagCompound(stack, (String)key, (CompoundNBT)value);
                continue;
            }
            if (value instanceof int[]) {
                ItemNBTHelper.putIntArray(stack, (String)key, (int[])value);
                continue;
            }
            if (value instanceof ItemStack) {
                ItemNBTHelper.setItemStack(stack, (String)key, (ItemStack)value);
                continue;
            }
            if (!(value instanceof FluidStack)) continue;
            ItemNBTHelper.setFluidStack(stack, (String)key, (FluidStack)value);
        }
        return stack;
    }

    public static CompoundNBT combineTags(CompoundNBT target, CompoundNBT add, Pattern pattern) {
        if (target == null || target.isEmpty()) {
            return add.func_74737_b();
        }
        for (String key : add.func_150296_c()) {
            if (pattern != null && !pattern.matcher(key).matches()) continue;
            if (!target.func_74764_b(key)) {
                target.func_218657_a(key, add.func_74781_a(key));
                continue;
            }
            switch (add.func_150299_b(key)) {
                case 1: {
                    target.func_74774_a(key, (byte)(target.func_74771_c(key) + add.func_74771_c(key)));
                    break;
                }
                case 2: {
                    target.func_74777_a(key, (short)(target.func_74765_d(key) + add.func_74765_d(key)));
                    break;
                }
                case 3: {
                    target.func_74768_a(key, target.func_74762_e(key) + add.func_74762_e(key));
                    break;
                }
                case 4: {
                    target.func_74772_a(key, target.func_74763_f(key) + add.func_74763_f(key));
                    break;
                }
                case 5: {
                    target.func_74776_a(key, target.func_74760_g(key) + add.func_74760_g(key));
                    break;
                }
                case 6: {
                    target.func_74780_a(key, target.func_74769_h(key) + add.func_74769_h(key));
                    break;
                }
                case 7: {
                    byte[] bytesTarget = target.func_74770_j(key);
                    byte[] bytesAdd = add.func_74770_j(key);
                    byte[] bytes = new byte[bytesTarget.length + bytesAdd.length];
                    System.arraycopy(bytesTarget, 0, bytes, 0, bytesTarget.length);
                    System.arraycopy(bytesAdd, 0, bytes, bytesTarget.length, bytesAdd.length);
                    target.func_74773_a(key, bytes);
                    break;
                }
                case 8: {
                    target.func_74778_a(key, target.func_74779_i(key) + add.func_74779_i(key));
                    break;
                }
                case 9: {
                    ListNBT listTarget = (ListNBT)target.func_74781_a(key);
                    ListNBT listAdd = (ListNBT)add.func_74781_a(key);
                    for (int i = 0; i < listAdd.size(); ++i) {
                        listTarget.add((Object)listAdd.get(i));
                    }
                    target.func_218657_a(key, (INBT)listTarget);
                    break;
                }
                case 10: {
                    ItemNBTHelper.combineTags(target.func_74775_l(key), add.func_74775_l(key), null);
                    break;
                }
                case 11: {
                    int[] intsTarget = target.func_74759_k(key);
                    int[] intsAdd = add.func_74759_k(key);
                    int[] ints = new int[intsTarget.length + intsAdd.length];
                    System.arraycopy(intsTarget, 0, ints, 0, intsTarget.length);
                    System.arraycopy(intsAdd, 0, ints, intsTarget.length, intsAdd.length);
                    target.func_74783_a(key, ints);
                }
            }
        }
        return target;
    }
}

