/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class RotationUtil {
    public static final List<RotationBlacklistEntry> blacklist = new ArrayList<RotationBlacklistEntry>();

    public static boolean rotateBlock(World world, BlockPos pos, boolean inverse) {
        return RotationUtil.rotateBlock(world, pos, inverse ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90);
    }

    public static boolean rotateBlock(World world, BlockPos pos, Rotation rotation) {
        for (RotationBlacklistEntry e : blacklist) {
            if (e.blockRotation(world, pos)) continue;
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        BlockState newState = state.rotate((IWorld)world, pos, rotation);
        if (newState != state) {
            BlockState otherState;
            BlockPos otherPos;
            world.func_175656_a(pos, newState);
            for (Direction d : Direction.field_199792_n) {
                otherPos = pos.func_177972_a(d);
                otherState = world.func_180495_p(otherPos);
                BlockState nextState = newState.func_196956_a(d, otherState, (IWorld)world, pos, otherPos);
                if (nextState == newState) continue;
                if (!nextState.func_196958_f()) {
                    world.func_175656_a(pos, nextState);
                    newState = nextState;
                    continue;
                }
                world.func_175656_a(pos, state);
                return false;
            }
            for (Direction d : Direction.field_199792_n) {
                otherPos = pos.func_177972_a(d);
                otherState = world.func_180495_p(otherPos);
                BlockState nextOther = otherState.func_196956_a(d.func_176734_d(), newState, (IWorld)world, otherPos, pos);
                if (nextOther == otherState) continue;
                world.func_175656_a(otherPos, nextOther);
            }
            return true;
        }
        return false;
    }

    public static boolean rotateEntity(Entity entity, PlayerEntity player) {
        if (entity instanceof ArmorStandEntity) {
            ((ArmorStandEntity)entity).field_70177_z = (float)((double)((ArmorStandEntity)entity).field_70177_z + 22.5);
            ((ArmorStandEntity)entity).field_70177_z %= 360.0f;
        }
        return false;
    }

    static {
        blacklist.add((w, pos) -> {
            BlockState state = w.func_180495_p(pos);
            return state.func_177230_c() != Blocks.field_150486_ae || state.func_177229_b((Property)ChestBlock.field_196314_b) == ChestType.SINGLE;
        });
    }

    public static interface RotationBlacklistEntry {
        public boolean blockRotation(World var1, BlockPos var2);
    }
}

