/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.commands;

import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.excavator.MineralVein;
import blusunrize.immersiveengineering.api.excavator.MineralWorldInfo;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.ColumnPosArgument;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.ColumnPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class CommandMineral {
    public static void registerArguments() {
        ArgumentTypes.func_218136_a((String)"immersiveengineering:mineral", MineralArgument.class, (IArgumentSerializer)new ArgumentSerializer(() -> new MineralArgument()));
    }

    public static LiteralArgumentBuilder<CommandSource> create() {
        LiteralArgumentBuilder main = Commands.func_197057_a((String)"mineral");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)main.then(CommandMineral.listMineral())).then(CommandMineral.getMineral())).then(CommandMineral.putMineral())).then(CommandMineral.setMineralDepletion());
        return main;
    }

    private static LiteralArgumentBuilder<CommandSource> listMineral() {
        LiteralArgumentBuilder list = Commands.func_197057_a((String)"list");
        list.executes(command -> {
            StringBuilder s = new StringBuilder();
            int i = 0;
            for (MineralMix mm : MineralMix.mineralList.values()) {
                s.append(i++ > 0 ? ", " : "").append(mm.func_199560_c());
            }
            ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new StringTextComponent(s.toString()), true);
            return 1;
        });
        return list;
    }

    private static LiteralArgumentBuilder<CommandSource> getMineral() {
        LiteralArgumentBuilder get = Commands.func_197057_a((String)"get");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)get.requires(source -> source.func_197034_c(2))).executes(command -> {
            ServerPlayerEntity player = ((CommandSource)command.getSource()).func_197035_h();
            CommandMineral.getMineral((CommandContext<CommandSource>)command, new ColumnPos(player.func_233580_cy_()));
            return 1;
        })).then(Commands.func_197056_a((String)"location", (ArgumentType)ColumnPosArgument.func_212603_a()).executes(command -> {
            ColumnPos pos = ColumnPosArgument.func_218101_a((CommandContext)command, (String)"location");
            CommandMineral.getMineral((CommandContext<CommandSource>)command, pos);
            return 1;
        }));
        return get;
    }

    private static void getMineral(CommandContext<CommandSource> context, ColumnPos pos) {
        CommandSource sender = (CommandSource)context.getSource();
        MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo((World)sender.func_197023_e(), pos);
        StringTextComponent ret = new StringTextComponent("");
        if (info == null || info.getTotalWeight() == 0) {
            ret.func_230529_a_((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.command.mineral.get.none", new Object[]{pos.field_219439_a, pos.field_219440_b}));
        } else {
            ret.func_230529_a_((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.command.mineral.get", new Object[]{pos.field_219439_a, pos.field_219440_b}));
            for (Pair<MineralVein, Integer> pair : info.getAllVeins()) {
                MineralVein vein = (MineralVein)pair.getLeft();
                double percentage = (double)((Integer)pair.getRight()).intValue() / (double)info.getTotalWeight();
                StringTextComponent component = new StringTextComponent("\n " + Utils.formatDouble(percentage * 100.0, "0.00") + "% ");
                component.func_230529_a_((ITextComponent)new TranslationTextComponent(vein.getMineral().getTranslationKey()));
                ret.func_230529_a_((ITextComponent)component.func_240699_a_(TextFormatting.GRAY));
                component = new StringTextComponent("\n  ");
                component.func_230529_a_((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.command.mineral.get.pos", new Object[]{vein.getPos().field_219439_a, vein.getPos().field_219440_b, vein.getRadius()}));
                component.func_240702_b_("\n  ");
                if (ExcavatorHandler.mineralVeinYield == 0) {
                    component.func_230529_a_((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.coresample.infinite"));
                } else {
                    component.func_230529_a_((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.coresample.yield", new Object[]{ExcavatorHandler.mineralVeinYield - vein.getDepletion()}));
                }
                ret.func_230529_a_((ITextComponent)component.func_240699_a_(TextFormatting.GRAY));
            }
        }
        sender.func_197030_a((ITextComponent)ret, true);
    }

    private static LiteralArgumentBuilder<CommandSource> putMineral() {
        LiteralArgumentBuilder set = Commands.func_197057_a((String)"put");
        ((LiteralArgumentBuilder)set.requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"mineral", (ArgumentType)new MineralArgument()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)8, (int)64)).then(Commands.func_197056_a((String)"pos", (ArgumentType)ColumnPosArgument.func_212603_a()).executes(ctx -> {
            CommandMineral.putMineral((CommandContext<CommandSource>)ctx, ColumnPosArgument.func_218101_a((CommandContext)ctx, (String)"pos"));
            return 1;
        }))).executes(ctx -> {
            CommandMineral.putMineral((CommandContext<CommandSource>)ctx, CommandMineral.columnPos(((CommandSource)ctx.getSource()).func_197036_d()));
            return 1;
        })));
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putMineral(CommandContext<CommandSource> context, ColumnPos pos) {
        CommandSource sender = (CommandSource)context.getSource();
        MineralMix mineral = (MineralMix)context.getArgument("mineral", MineralMix.class);
        int radius = IntegerArgumentType.getInteger(context, (String)"radius");
        if (mineral != null) {
            MineralVein vein = new MineralVein(pos, mineral.func_199560_c(), radius);
            Multimap<RegistryKey<World>, MineralVein> multimap = ExcavatorHandler.getMineralVeinList();
            synchronized (multimap) {
                ExcavatorHandler.getMineralVeinList().put((Object)sender.func_197023_e().func_234923_W_(), (Object)vein);
            }
            IESaveData.setDirty();
            sender.func_197030_a((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.command.mineral.put.success", new Object[]{mineral.func_199560_c(), radius, pos.field_219439_a, pos.field_219440_b}), true);
        } else {
            sender.func_197030_a((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.command.mineral.put.invalid_mineral", new Object[]{mineral.func_199560_c()}), true);
        }
    }

    private static LiteralArgumentBuilder<CommandSource> setMineralDepletion() {
        LiteralArgumentBuilder setDepletion = Commands.func_197057_a((String)"setDepletion");
        ((LiteralArgumentBuilder)setDepletion.requires(source -> source.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"depletion", (ArgumentType)IntegerArgumentType.integer((int)0, (int)ExcavatorHandler.mineralVeinYield)).then(Commands.func_197056_a((String)"pos", (ArgumentType)ColumnPosArgument.func_212603_a()).executes(ctx -> {
            CommandMineral.setMineralDepletion((CommandContext<CommandSource>)ctx, ColumnPosArgument.func_218101_a((CommandContext)ctx, (String)"pos"));
            return 1;
        }))).executes(ctx -> {
            CommandMineral.setMineralDepletion((CommandContext<CommandSource>)ctx, CommandMineral.columnPos(((CommandSource)ctx.getSource()).func_197036_d()));
            return 1;
        }));
        return setDepletion;
    }

    private static void setMineralDepletion(CommandContext<CommandSource> context, ColumnPos pos) {
        CommandSource sender = (CommandSource)context.getSource();
        MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo((World)sender.func_197023_e(), pos);
        if (info != null && info.getTotalWeight() > 0) {
            int depletion = IntegerArgumentType.getInteger(context, (String)"depletion");
            for (Pair<MineralVein, Integer> pair : info.getAllVeins()) {
                ((MineralVein)pair.getLeft()).setDepletion(depletion);
            }
            IESaveData.setDirty();
            sender.func_197030_a((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.command.mineral.set_depletion.success", new Object[]{depletion}), true);
        } else {
            sender.func_197030_a((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.command.mineral.set_depletion.no_mineral", new Object[]{pos.field_219439_a, pos.field_219440_b}), true);
        }
    }

    private static ColumnPos columnPos(Vector3d vec) {
        return new ColumnPos((int)vec.field_72450_a, (int)vec.field_72449_c);
    }

    private static class MineralArgument
    implements ArgumentType<MineralMix> {
        public static final DynamicCommandExceptionType invalidVein = new DynamicCommandExceptionType(input -> new TranslationTextComponent("chat.immersiveengineering.command.mineral.invalid", new Object[]{input}));

        private MineralArgument() {
        }

        public MineralMix parse(StringReader reader) throws CommandSyntaxException {
            String name = reader.readQuotedString();
            for (MineralMix mm : MineralMix.mineralList.values()) {
                if (!mm.func_199560_c().toString().equalsIgnoreCase(name)) continue;
                return mm;
            }
            throw invalidVein.create((Object)name);
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return ISuggestionProvider.func_197013_a(MineralMix.mineralList.values().stream().map(mix -> "\"" + mix.func_199560_c() + "\""), (SuggestionsBuilder)builder);
        }

        public Collection<String> getExamples() {
            ArrayList<String> ret = new ArrayList<String>();
            for (MineralMix mix : MineralMix.mineralList.values()) {
                ret.add("\"" + mix.func_199560_c() + "\"");
                if (ret.size() <= 5) continue;
                break;
            }
            return ret;
        }
    }
}

