/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.fluids;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.fluids.IEFluidBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;

public class IEFluid
extends FlowingFluid {
    public static final Collection<IEFluid> IE_FLUIDS = new ArrayList<IEFluid>();
    protected final String fluidName;
    protected final ResourceLocation stillTex;
    protected final ResourceLocation flowingTex;
    protected IEFluid flowing;
    protected IEFluid source;
    @Nullable
    protected final Consumer<FluidAttributes.Builder> buildAttributes;
    public IEFluidBlock block;
    protected Item bucket;
    public static final IDataSerializer<Optional<FluidStack>> OPTIONAL_FLUID_STACK = new IDataSerializer<Optional<FluidStack>>(){

        public void write(PacketBuffer buf, Optional<FluidStack> value) {
            buf.writeBoolean(value.isPresent());
            value.ifPresent(fs -> buf.func_150786_a(fs.writeToNBT(new CompoundNBT())));
        }

        @Nonnull
        public Optional<FluidStack> read(PacketBuffer buf) {
            FluidStack fs = !buf.readBoolean() ? null : FluidStack.loadFluidStackFromNBT((CompoundNBT)buf.func_150793_b());
            return Optional.ofNullable(fs);
        }

        public DataParameter<Optional<FluidStack>> func_187161_a(int id) {
            return new DataParameter(id, (IDataSerializer)this);
        }

        public Optional<FluidStack> copyValue(Optional<FluidStack> value) {
            return value.map(FluidStack::copy);
        }
    };

    public IEFluid(String fluidName, ResourceLocation stillTex, ResourceLocation flowingTex) {
        this(fluidName, stillTex, flowingTex, null);
    }

    public IEFluid(String fluidName, ResourceLocation stillTex, ResourceLocation flowingTex, @Nullable Consumer<FluidAttributes.Builder> buildAttributes) {
        this(fluidName, stillTex, flowingTex, buildAttributes, true);
    }

    public IEFluid(String fluidName, ResourceLocation stillTex, ResourceLocation flowingTex, @Nullable Consumer<FluidAttributes.Builder> buildAttributes, boolean isSource) {
        this.fluidName = fluidName;
        this.stillTex = stillTex;
        this.flowingTex = flowingTex;
        this.buildAttributes = buildAttributes;
        IEContent.registeredIEFluids.add((Fluid)this);
        if (!isSource) {
            this.flowing = this;
            this.setRegistryName("immersiveengineering", fluidName + "_flowing");
        } else {
            this.source = this;
            this.block = new IEFluidBlock(this);
            this.block.setRegistryName("immersiveengineering", fluidName + "_fluid_block");
            IEContent.registeredIEBlocks.add((Block)this.block);
            this.bucket = new BucketItem(() -> this.source, new Item.Properties().func_200917_a(1).func_200916_a(ImmersiveEngineering.itemGroup)){

                public ItemStack getContainerItem(ItemStack itemStack) {
                    return new ItemStack((IItemProvider)Items.field_151133_ar);
                }

                public boolean hasContainerItem(ItemStack stack) {
                    return true;
                }

                public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
                    return new FluidBucketWrapper(stack);
                }
            };
            this.bucket.setRegistryName("immersiveengineering", fluidName + "_bucket");
            IEContent.registeredIEItems.add(this.bucket);
            this.flowing = this.createFlowingVariant();
            this.setRegistryName("immersiveengineering", fluidName);
            IE_FLUIDS.add(this);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addTooltipInfo(FluidStack fluidStack, @Nullable PlayerEntity player, List<ITextComponent> tooltip) {
    }

    @Nonnull
    public Item func_204524_b() {
        return this.bucket;
    }

    protected boolean func_215665_a(FluidState p_215665_1_, IBlockReader p_215665_2_, BlockPos p_215665_3_, Fluid fluidIn, Direction direction) {
        return direction == Direction.DOWN && !this.func_207187_a(fluidIn);
    }

    public boolean func_207187_a(Fluid fluidIn) {
        return fluidIn == this.source || fluidIn == this.flowing;
    }

    public int func_205569_a(IWorldReader p_205569_1_) {
        return 5;
    }

    protected float func_210195_d() {
        return 100.0f;
    }

    protected BlockState func_204527_a(FluidState state) {
        return (BlockState)this.block.func_176223_P().func_206870_a((Property)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(IEFluid.func_207205_e((FluidState)state)));
    }

    public boolean func_207193_c(FluidState state) {
        return state.func_206886_c() == this.source;
    }

    public int func_207192_d(FluidState p_207192_1_) {
        if (this.func_207193_c(p_207192_1_)) {
            return 8;
        }
        return (Integer)p_207192_1_.func_177229_b((Property)field_207210_b);
    }

    @Nonnull
    protected FluidAttributes createAttributes() {
        FluidAttributes.Builder builder = FluidAttributes.builder((ResourceLocation)this.stillTex, (ResourceLocation)this.flowingTex);
        if (this.buildAttributes != null) {
            this.buildAttributes.accept(builder);
        }
        return builder.build((Fluid)this);
    }

    @Nonnull
    public Fluid func_210197_e() {
        return this.flowing;
    }

    @Nonnull
    public Fluid func_210198_f() {
        return this.source;
    }

    protected boolean func_205579_d() {
        return false;
    }

    protected void func_205580_a(IWorld iWorld, BlockPos blockPos, BlockState blockState) {
    }

    protected int func_185698_b(IWorldReader iWorldReader) {
        return 4;
    }

    protected int func_204528_b(IWorldReader iWorldReader) {
        return 1;
    }

    protected IEFluid createFlowingVariant() {
        IEFluid ret = new IEFluid(this.fluidName, this.stillTex, this.flowingTex, this.buildAttributes, false){

            protected void func_207184_a(StateContainer.Builder<Fluid, FluidState> builder) {
                super.func_207184_a(builder);
                builder.func_206894_a(new Property[]{field_207210_b});
            }
        };
        ret.source = this;
        ret.bucket = this.bucket;
        ret.block = this.block;
        ret.func_207183_f((FluidState)((FluidState)ret.func_207182_e().func_177621_b()).func_206870_a((Property)field_207210_b, (Comparable)Integer.valueOf(7)));
        return ret;
    }

    public static Consumer<FluidAttributes.Builder> createBuilder(int density, int viscosity) {
        return builder -> builder.viscosity(viscosity).density(density);
    }
}

