/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.wires;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IWireSyncManager;
import blusunrize.immersiveengineering.api.wires.WireLogger;
import blusunrize.immersiveengineering.common.network.MessageWireSync;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="immersiveengineering")
public class WireSyncManager
implements IWireSyncManager {
    private static final SetMultimap<UUID, ChunkPos> wireWatchedChunksByPlayer = HashMultimap.create();
    private final World world;

    private static void sendMessagesForChunk(World w, ChunkPos pos, ServerPlayerEntity player, boolean add) {
        GlobalWireNetwork net = GlobalWireNetwork.getNetwork(w);
        Collection<ConnectionPoint> connsInChunk = net.getAllConnectorsIn(pos);
        for (ConnectionPoint cp : connsInChunk) {
            for (Connection conn : net.getLocalNet(cp).getConnections(cp)) {
                if (!WireSyncManager.shouldSendConnection(conn, pos, player, add, cp)) continue;
                WireLogger.logger.info("Sending connection {} ({}) for chunk change at {}", (Object)conn, (Object)add, (Object)pos);
                ImmersiveEngineering.packetHandler.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageWireSync(conn, add));
            }
        }
    }

    private static boolean shouldSendConnection(Connection conn, ChunkPos pos, ServerPlayerEntity player, boolean add, ConnectionPoint currEnd) {
        if (conn.isInternal()) {
            return false;
        }
        ConnectionPoint other = conn.getOtherEnd(currEnd);
        ChunkPos otherChunk = new ChunkPos(other.getPosition());
        if (otherChunk.equals((Object)pos)) {
            return conn.isPositiveEnd(currEnd);
        }
        return wireWatchedChunksByPlayer.containsEntry((Object)player.func_110124_au(), (Object)otherChunk);
    }

    private static void addPlayersTrackingPoint(Set<ServerPlayerEntity> receivers, int x, int z, ServerWorld world) {
        ServerChunkProvider chunkProvider = world.func_72863_F();
        Stream watching = chunkProvider.field_217237_a.func_219097_a(new ChunkPos(x >> 4, z >> 4), false);
        watching.forEach(e -> {
            WireLogger.logger.debug("Watching player for {}, {}: {}", (Object)x, (Object)z, e);
            receivers.add((ServerPlayerEntity)e);
        });
    }

    private static <T> void sendToPlayersForConnection(T msg, ServerWorld world, Connection c) {
        ApiUtils.addFutureServerTask((World)world, () -> {
            HashSet<ServerPlayerEntity> targets = new HashSet<ServerPlayerEntity>();
            WireSyncManager.addPlayersTrackingPoint(targets, c.getEndA().getX(), c.getEndA().getZ(), world);
            WireSyncManager.addPlayersTrackingPoint(targets, c.getEndB().getX(), c.getEndB().getZ(), world);
            for (ServerPlayerEntity p : targets) {
                ImmersiveEngineering.packetHandler.send(PacketDistributor.PLAYER.with(() -> p), msg);
            }
        }, true);
    }

    @SubscribeEvent
    public static void onChunkWatch(ChunkWatchEvent.Watch ev) {
        ApiUtils.addFutureServerTask((World)ev.getWorld(), () -> {
            wireWatchedChunksByPlayer.put((Object)ev.getPlayer().func_110124_au(), (Object)ev.getPos());
            WireSyncManager.sendMessagesForChunk((World)ev.getWorld(), ev.getPos(), ev.getPlayer(), true);
        }, true);
    }

    @SubscribeEvent
    public static void onChunkUnWatch(ChunkWatchEvent.UnWatch ev) {
        ApiUtils.addFutureServerTask((World)ev.getWorld(), () -> {
            wireWatchedChunksByPlayer.remove((Object)ev.getPlayer().func_110124_au(), (Object)ev.getPos());
            WireSyncManager.sendMessagesForChunk((World)ev.getWorld(), ev.getPos(), ev.getPlayer(), false);
        }, true);
    }

    public WireSyncManager(World world) {
        this.world = world;
    }

    @Override
    public void onConnectionAdded(Connection c) {
        if (!c.isInternal() && !this.world.field_72995_K && this.world instanceof ServerWorld) {
            WireSyncManager.sendToPlayersForConnection(new MessageWireSync(c, true), (ServerWorld)this.world, c);
        }
    }

    @Override
    public void onConnectionRemoved(Connection c) {
        if (!c.isInternal() && !this.world.field_72995_K && this.world instanceof ServerWorld) {
            WireSyncManager.sendToPlayersForConnection(new MessageWireSync(c, false), (ServerWorld)this.world, c);
        }
    }
}

