/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.world;

import blusunrize.immersiveengineering.common.config.IEServerConfig;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.SimplePlacement;

public class IERangePlacement
extends SimplePlacement<IETopSolidRangeConfig> {
    public static final Codec<List<String>> STRING_LIST = Codec.list((Codec)Codec.STRING);

    public IERangePlacement() {
        super(IETopSolidRangeConfig.CODEC);
    }

    public Stream<BlockPos> getPositions(Random random, IETopSolidRangeConfig config, BlockPos pos) {
        int i = pos.func_177958_n();
        int j = pos.func_177952_p();
        int k = random.nextInt(config.getMax() - config.getMin()) + config.getMin();
        return Stream.of(new BlockPos(i, k, j));
    }

    public static class IETopSolidRangeConfig
    implements IPlacementConfig {
        public static Codec<IETopSolidRangeConfig> CODEC = RecordCodecBuilder.create(app -> app.group((App)STRING_LIST.fieldOf("min").forGetter(config -> config.min), (App)STRING_LIST.fieldOf("max").forGetter(config -> config.max)).apply((Applicative)app, IETopSolidRangeConfig::new));
        final List<String> min;
        final List<String> max;

        public IETopSolidRangeConfig(IEServerConfig.Ores.OreConfig config) {
            this(config.minY.getPath(), config.maxY.getPath());
        }

        public IETopSolidRangeConfig(List<String> minPath, List<String> maxPath) {
            this.min = minPath;
            this.max = maxPath;
        }

        public int getMin() {
            return IEServerConfig.getRawConfig().getInt(this.min);
        }

        public int getMax() {
            return IEServerConfig.getRawConfig().getInt(this.max);
        }
    }
}

