/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.world;

import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.world.FeatureMineralVein;
import blusunrize.immersiveengineering.common.world.IECountPlacement;
import blusunrize.immersiveengineering.common.world.IEOreFeature;
import blusunrize.immersiveengineering.common.world.IERangePlacement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class IEWorldGen {
    public static Map<String, ConfiguredFeature<?, ?>> features = new HashMap();
    public static Map<String, Pair<IEServerConfig.Ores.OreConfig, BlockState>> retroFeatures = new HashMap<String, Pair<IEServerConfig.Ores.OreConfig, BlockState>>();
    public static Set<String> retrogenOres = new HashSet<String>();
    public static final Map<RegistryKey<World>, List<ChunkPos>> retrogenChunks = new HashMap<RegistryKey<World>, List<ChunkPos>>();
    int indexToRemove = 0;
    private static DeferredRegister<Feature<?>> FEATURE_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"immersiveengineering");
    private static DeferredRegister<Placement<?>> PLACEMENT_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.DECORATORS, (String)"immersiveengineering");
    private static RegistryObject<FeatureMineralVein> MINERAL_VEIN_FEATURE = FEATURE_REGISTER.register("mineral_vein", FeatureMineralVein::new);
    private static RegistryObject<IEOreFeature> IE_CONFIG_ORE = FEATURE_REGISTER.register("ie_ore", IEOreFeature::new);
    private static RegistryObject<IERangePlacement> IE_RANGE_PLACEMENT = PLACEMENT_REGISTER.register("ie_range", IERangePlacement::new);
    private static RegistryObject<IECountPlacement> IE_COUNT_PLACEMENT = PLACEMENT_REGISTER.register("ie_ount", IECountPlacement::new);

    public static void addOreGen(Block block, String name, IEServerConfig.Ores.OreConfig config) {
        IEOreFeature.IEOreFeatureConfig cfg = new IEOreFeature.IEOreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, block.func_176223_P(), config);
        ConfiguredFeature feature = Features.func_243968_a((String)("immersiveengineering:" + name), (ConfiguredFeature)((ConfiguredFeature)((IEOreFeature)IE_CONFIG_ORE.get()).func_225566_b_(cfg).func_227228_a_(((IERangePlacement)IE_RANGE_PLACEMENT.get()).func_227446_a_(new IERangePlacement.IETopSolidRangeConfig(config))).func_242728_a()).func_227228_a_(((IECountPlacement)IE_COUNT_PLACEMENT.get()).func_227446_a_(new IECountPlacement.IEFeatureSpreadConfig(config))));
        features.put(name, feature);
        retroFeatures.put(name, (Pair<IEServerConfig.Ores.OreConfig, BlockState>)Pair.of((Object)config, (Object)block.func_176223_P()));
    }

    public static void registerMineralVeinGen() {
        ConfiguredFeature veinFeature = Features.func_243968_a((String)"immersiveengineering:mineral_veins", (ConfiguredFeature)((FeatureMineralVein)MINERAL_VEIN_FEATURE.get()).func_225566_b_((IFeatureConfig)new NoFeatureConfig()).func_227228_a_(new ConfiguredPlacement(Placement.field_215022_h, (IPlacementConfig)IPlacementConfig.field_202468_e)));
        features.put("veins", veinFeature);
    }

    @SubscribeEvent
    public void onBiomeLoad(BiomeLoadingEvent ev) {
        BiomeGenerationSettingsBuilder generation = ev.getGeneration();
        for (Map.Entry<String, ConfiguredFeature<?, ?>> e : features.entrySet()) {
            generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, e.getValue());
        }
    }

    private void generateOres(Random random, int chunkX, int chunkZ, ServerWorld world) {
        for (Map.Entry<String, Pair<IEServerConfig.Ores.OreConfig, BlockState>> gen : retroFeatures.entrySet()) {
            IEServerConfig.Ores.OreConfig config = (IEServerConfig.Ores.OreConfig)gen.getValue().getKey();
            BlockState state = (BlockState)gen.getValue().getRight();
            if (!retrogenOres.contains("retrogen_" + gen.getKey())) continue;
            ConfiguredFeature retroFeature = ((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, state, ((Integer)config.veinSize.get()).intValue())).func_227228_a_(new IERangePlacement().func_227446_a_(new IERangePlacement.IETopSolidRangeConfig(config))).func_242728_a()).func_227228_a_(new IECountPlacement().func_227446_a_(new IECountPlacement.IEFeatureSpreadConfig(config)));
            retroFeature.func_242765_a((ISeedReader)world, world.func_72863_F().func_201711_g(), random, new BlockPos(16 * chunkX, 0, 16 * chunkZ));
        }
    }

    @SubscribeEvent
    public void chunkDataSave(ChunkDataEvent.Save event) {
        CompoundNBT levelTag = event.getData().func_74775_l("Level");
        CompoundNBT nbt = new CompoundNBT();
        levelTag.func_218657_a("ImmersiveEngineering", (INBT)nbt);
        nbt.func_74757_a((String)IEServerConfig.ORES.retrogen_key.get(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void chunkDataLoad(ChunkDataEvent.Load event) {
        IWorld world = event.getWorld();
        if (event.getChunk().func_201589_g() == ChunkStatus.field_222617_m && world instanceof World && !event.getData().func_74775_l("ImmersiveEngineering").func_74764_b((String)IEServerConfig.ORES.retrogen_key.get()) && !retrogenOres.isEmpty()) {
            if (((Boolean)IEServerConfig.ORES.retrogen_log_flagChunk.get()).booleanValue()) {
                IELogger.info("Chunk " + event.getChunk().func_76632_l() + " has been flagged for Ore RetroGeneration by IE.");
            }
            RegistryKey dimension = ((World)world).func_234923_W_();
            Map<RegistryKey<World>, List<ChunkPos>> map = retrogenChunks;
            synchronized (map) {
                retrogenChunks.computeIfAbsent((RegistryKey<World>)dimension, d -> new ArrayList()).add(event.getChunk().func_76632_l());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void serverWorldTick(TickEvent.WorldTickEvent event) {
        int remaining;
        if (event.side == LogicalSide.CLIENT || event.phase == TickEvent.Phase.START || !(event.world instanceof ServerWorld)) {
            return;
        }
        RegistryKey dimension = event.world.func_234923_W_();
        int counter = 0;
        Map<RegistryKey<World>, List<ChunkPos>> map = retrogenChunks;
        synchronized (map) {
            List<ChunkPos> chunks = retrogenChunks.get(dimension);
            if (chunks != null && chunks.size() > 0) {
                if (this.indexToRemove >= chunks.size()) {
                    this.indexToRemove = 0;
                }
                for (int i = 0; i < 2 && this.indexToRemove < chunks.size() && chunks.size() > 0; ++i) {
                    ChunkPos loc = chunks.get(this.indexToRemove);
                    if (event.world.func_217354_b(loc.field_77276_a, loc.field_77275_b)) {
                        long worldSeed = ((ISeedReader)event.world).func_72905_C();
                        Random fmlRandom = new Random(worldSeed);
                        long xSeed = fmlRandom.nextLong() >> 3;
                        long zSeed = fmlRandom.nextLong() >> 3;
                        fmlRandom.setSeed(xSeed * (long)loc.field_77276_a + zSeed * (long)loc.field_77275_b ^ worldSeed);
                        this.generateOres(fmlRandom, loc.field_77276_a, loc.field_77275_b, (ServerWorld)event.world);
                        ++counter;
                        chunks.remove(this.indexToRemove);
                        continue;
                    }
                    ++this.indexToRemove;
                }
            }
            remaining = chunks == null ? 0 : chunks.size();
        }
        if (counter > 0 && ((Boolean)IEServerConfig.ORES.retrogen_log_remaining.get()).booleanValue()) {
            IELogger.info("Retrogen was performed on " + counter + " Chunks, " + remaining + " chunks remaining");
        }
    }

    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        FEATURE_REGISTER.register(bus);
        PLACEMENT_REGISTER.register(bus);
    }
}

