/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelated.islands.config;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelated.islands.helpers.WyHelper;

public class CommonConfig {
    private static CommonConfig instance;
    private ForgeConfigSpec.IntValue islandRarity;
    private ForgeConfigSpec.IntValue islandMinSize;
    private ForgeConfigSpec.IntValue islandMaxSize;
    private List<String> bannedBiomes;
    private ForgeConfigSpec.BooleanValue survivalIsland;

    public static void init() {
        Pair pair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        ForgeConfigSpec configSpec = (ForgeConfigSpec)pair.getRight();
        instance = (CommonConfig)pair.getLeft();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, configSpec);
    }

    public static CommonConfig instance() {
        return instance;
    }

    public CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("Islands");
        this.islandRarity = builder.comment("Determines how rare islands will generate \n10 by default").defineInRange("Rarity", 10, 5, 10000);
        this.islandMinSize = builder.comment("The minimum size an island can be \n2 by default").defineInRange("Minimum Size", 2, 1, 10);
        this.islandMaxSize = builder.comment("The maximum size an island can be \n5 by default").defineInRange("Maximum Size", 5, 1, 10);
        this.survivalIsland = builder.comment("Determines if the spawn island is the only island spawned in the world \nfalse by default").define("Survival Island", false);
        this.bannedBiomes = new ArrayList<String>();
        Predicate<Object> bannedBiomesTest = new Predicate<Object>(){

            @Override
            public boolean test(Object t) {
                if (!(t instanceof String)) {
                    return false;
                }
                String str = (String)t;
                return !WyHelper.isNullOrEmpty(str);
            }
        };
        this.bannedBiomes.add(Biomes.field_76779_k.getRegistryName().toString());
        this.bannedBiomes.add(Biomes.field_201939_S.getRegistryName().toString());
        this.bannedBiomes.add(Biomes.field_201938_R.getRegistryName().toString());
        this.bannedBiomes.add(Biomes.field_201937_Q.getRegistryName().toString());
        this.bannedBiomes.add(Biomes.field_201936_P.getRegistryName().toString());
        this.bannedBiomes.add(Biomes.field_76779_k.getRegistryName().toString());
        this.bannedBiomes.add(Biomes.field_76778_j.getRegistryName().toString());
        builder.comment("List of banned biomes, formated as resource keys <mod>:<biome> if <mod> is left out the system will treat them as vanilla biomes").defineList("Banned Biomes", this.bannedBiomes, (Predicate)bannedBiomesTest);
    }

    public boolean isSurvivalIsland() {
        return (Boolean)this.survivalIsland.get();
    }

    public List<String> getBannedBiomes() {
        return this.bannedBiomes;
    }

    public int getIslandMaxSize() {
        return (Integer)this.islandMaxSize.get();
    }

    public int getIslandMinSize() {
        return (Integer)this.islandMinSize.get();
    }

    public int getIslandRarity() {
        return (Integer)this.islandRarity.get();
    }
}

