/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelated.islands;

import java.util.function.LongFunction;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.ShoreLayer;
import net.minecraft.world.gen.layer.ZoomLayer;
import xyz.pixelated.islands.config.CommonConfig;
import xyz.pixelated.islands.helpers.WyHelper;
import xyz.pixelated.islands.layers.IslandMasterLayer;
import xyz.pixelated.islands.layers.OneBiomePerIslandLayer;

public class IslandLayerProvider {
    private static <A extends IArea, R extends IExtendedNoiseRandom<A>> IAreaFactory<A> setup(LongFunction<R> randomProvider) {
        IAreaFactory islandFactory = IslandMasterLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)randomProvider.apply(1000L));
        islandFactory = OneBiomePerIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)randomProvider.apply(9L), islandFactory);
        int min = CommonConfig.instance().getIslandMinSize();
        int max = CommonConfig.instance().getIslandMaxSize();
        int size = (int)WyHelper.randomWithRange(min, max);
        for (int islandSize = 0; islandSize <= size; ++islandSize) {
            islandFactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)randomProvider.apply(1000L + (long)islandSize), islandFactory);
        }
        islandFactory = ShoreLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)randomProvider.apply(10L), islandFactory);
        islandFactory = ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)randomProvider.apply(1000L), islandFactory);
        islandFactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)randomProvider.apply(1000L), islandFactory);
        return islandFactory;
    }

    public static Layer build(long seed) {
        return new Layer(IslandLayerProvider.setup(salt -> new LazyAreaLayerContext(25, seed, salt)));
    }
}

