/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelated.islands.helpers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xyz.pixelated.islands.config.CommonConfig;

public class IslandsHelper {
    public static boolean isOcean(int biomeId) {
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            if (IslandsHelper.getBiomeId(biome) != biomeId) continue;
            return true;
        }
        return false;
    }

    public static Set<Biome> getBiomeSet() {
        HashSet<Biome> set = new HashSet<Biome>();
        ForgeRegistries.BIOMES.forEach(set::add);
        return set;
    }

    public static int getRandomBiome(INoiseRandom rand) {
        List<String> bannedBiomes = CommonConfig.instance().getBannedBiomes();
        Predicate<Biome> ignorePredicate = biome -> !bannedBiomes.contains(biome.getRegistryName().toString());
        List list = new ArrayList(ForgeRegistries.BIOMES.getValues()).stream().filter(ignorePredicate).collect(Collectors.toList());
        Biome biome2 = (Biome)list.get(rand.func_202696_a(list.size()));
        return IslandsHelper.getBiomeId(biome2);
    }

    public static int getBiomeId(Biome biome) {
        return ((ForgeRegistry)ForgeRegistries.BIOMES).getID((IForgeRegistryEntry)biome);
    }

    public static Biome getBiome(int biomeId) {
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            if (IslandsHelper.getBiomeId(biome) != biomeId) continue;
            return biome;
        }
        return Biomes.field_150575_M;
    }
}

