/*
 * Decompiled with CFR 0.152.
 */
package me.lambdaurora.lambdynlights;

import com.electronwill.nightconfig.core.file.FileConfig;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import me.lambdaurora.lambdynlights.DynamicLightsMode;
import me.lambdaurora.lambdynlights.LambDynLights;
import me.lambdaurora.spruceui.option.SpruceCyclingOption;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_316;
import org.jetbrains.annotations.NotNull;

public class DynamicLightsConfig {
    private static final DynamicLightsMode DEFAULT_DYNAMIC_LIGHTS_MODE = DynamicLightsMode.OFF;
    private static final boolean DEFAULT_ENTITIES_LIGHT_SOURCE = true;
    private static final boolean DEFAULT_BLOCK_ENTITIES_LIGHT_SOURCE = true;
    private static final boolean DEFAULT_WATER_SENSITIVE_CHECK = true;
    public static final Path CONFIG_FILE_PATH = Paths.get("config/lambdynlights.toml", new String[0]);
    protected final FileConfig config;
    private final LambDynLights mod;
    private boolean firstTime;
    private DynamicLightsMode dynamicLightsMode;
    public final class_316 dynamicLightsModeOption = new SpruceCyclingOption("lambdynlights.option.mode", amount -> this.setDynamicLightsMode(this.dynamicLightsMode.next()), option -> option.getDisplayText(this.dynamicLightsMode.getTranslatedText()), (class_2561)new class_2588("lambdynlights.tooltip.mode.1").method_10852((class_2561)new class_2585("\n")).method_10852((class_2561)new class_2588("lambdynlights.tooltip.mode.2", new Object[]{DynamicLightsMode.FASTEST.getTranslatedText(), DynamicLightsMode.FAST.getTranslatedText()})).method_10852((class_2561)new class_2585("\n")).method_10852((class_2561)new class_2588("lambdynlights.tooltip.mode.3", new Object[]{DynamicLightsMode.FANCY.getTranslatedText()})));

    public DynamicLightsConfig(@NotNull LambDynLights mod) {
        this.mod = mod;
        this.firstTime = Files.notExists(CONFIG_FILE_PATH, new LinkOption[0]);
        this.config = FileConfig.builder(CONFIG_FILE_PATH).concurrent().defaultResource("/lambdynlights.toml").autosave().build();
    }

    public void load() {
        this.config.load();
        String dynamicLightsModeValue = this.config.getOrElse("mode", DEFAULT_DYNAMIC_LIGHTS_MODE.getName());
        this.dynamicLightsMode = DynamicLightsMode.byId(dynamicLightsModeValue).orElse(DEFAULT_DYNAMIC_LIGHTS_MODE);
        if (dynamicLightsModeValue.equalsIgnoreCase("none")) {
            this.firstTime = true;
        }
        this.mod.log("Configuration loaded.");
    }

    public void save() {
        this.config.save();
    }

    public void reset() {
        this.setDynamicLightsMode(DEFAULT_DYNAMIC_LIGHTS_MODE);
        this.setEntitiesLightSource(true);
        this.setBlockEntitiesLightSource(true);
        this.setWaterSensitiveCheck(true);
    }

    public boolean isFirstTime() {
        return this.firstTime;
    }

    public DynamicLightsMode getDynamicLightsMode() {
        return this.dynamicLightsMode;
    }

    public void setDynamicLightsMode(@NotNull DynamicLightsMode mode) {
        this.dynamicLightsMode = mode;
        this.config.set("mode", (Object)mode.getName());
        if (!mode.isEnabled()) {
            this.mod.clearLightSources();
        }
        this.firstTime = false;
    }

    public boolean hasEntitiesLightSource() {
        return this.config.getOrElse("light_sources.entities", Boolean.valueOf(true));
    }

    public void setEntitiesLightSource(boolean enabled) {
        if (!enabled) {
            this.mod.removeEntitiesLightSource();
        }
        this.config.set("light_sources.entities", (Object)enabled);
    }

    public boolean hasBlockEntitiesLightSource() {
        return this.config.getOrElse("light_sources.block_entities", Boolean.valueOf(true));
    }

    public void setBlockEntitiesLightSource(boolean enabled) {
        if (!enabled) {
            this.mod.removeBlockEntitiesLightSource();
        }
        this.config.set("light_sources.block_entities", (Object)enabled);
    }

    public boolean hasWaterSensitiveCheck() {
        return this.config.getOrElse("light_sources.water_sensitive_check", Boolean.valueOf(true));
    }

    public void setWaterSensitiveCheck(boolean waterSensitive) {
        this.config.set("light_sources.water_sensitive_check", (Object)waterSensitive);
    }
}

