/*
 * Decompiled with CFR 0.152.
 */
package me.lambdaurora.lambdynlights;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;
import me.lambdaurora.lambdynlights.DynamicLightSource;
import me.lambdaurora.lambdynlights.DynamicLightsConfig;
import me.lambdaurora.lambdynlights.accessor.WorldRendererAccessor;
import me.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.tag.TagRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3494;
import net.minecraft.class_3532;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_761;
import net.minecraft.class_765;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambDynLights
implements ClientModInitializer {
    public static final class_3494<class_1792> WATER_SENSITIVE_ITEMS = TagRegistry.item((class_2960)new class_2960("lambdynlights", "water_sensitive"));
    private static final double MAX_RADIUS = 7.75;
    private static LambDynLights INSTANCE;
    public final Logger logger = LogManager.getLogger((String)"lambdynlights");
    public final DynamicLightsConfig config = new DynamicLightsConfig(this);
    private final ConcurrentLinkedQueue<DynamicLightSource> dynamicLightSources = new ConcurrentLinkedQueue();
    private long lastUpdate = System.currentTimeMillis();
    private boolean notifiedFirstTime = false;

    public void onInitializeClient() {
        INSTANCE = this;
        this.log("Initializing LambDynamicLights...");
        this.config.load();
        ClientTickEvents.START_WORLD_TICK.register(world -> {
            if (!this.notifiedFirstTime && this.config.isFirstTime()) {
                this.notifiedFirstTime = true;
                class_310 client = class_310.method_1551();
                client.method_1566().method_1999((class_368)class_370.method_29047((class_310)client, (class_370.class_371)class_370.class_371.field_2218, (class_2561)new class_2585("LambDynamicLights").method_27692(class_124.field_1065), (class_2561)new class_2588("lambdynlights.toast.first_time")));
            }
        });
        DynamicLightHandlers.registerDefaultHandlers();
    }

    public void updateAll(@NotNull class_761 renderer) {
        if (!this.config.getDynamicLightsMode().isEnabled()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now >= this.lastUpdate + 50L) {
            this.lastUpdate = now;
            for (DynamicLightSource lightSource : this.dynamicLightSources) {
                lightSource.lambdynlights_updateDynamicLight(renderer);
            }
        }
    }

    public int getLightmapWithDynamicLight(@NotNull class_2338 pos, int lightmap) {
        return this.getLightmapWithDynamicLight(this.getDynamicLuminance(pos), lightmap);
    }

    public int getLightmapWithDynamicLight(@NotNull class_1297 entity, int lightmap) {
        int posLuminance = (int)this.getDynamicLuminance(entity.method_24515());
        int entityLuminance = ((DynamicLightSource)entity).getLuminance();
        return this.getLightmapWithDynamicLight(Math.max(posLuminance, entityLuminance), lightmap);
    }

    public int getLightmapWithDynamicLight(double dynamicLuminance, int lightmap) {
        int blockLevel;
        if (dynamicLuminance > 0.0 && dynamicLuminance > (double)(blockLevel = class_765.method_24186((int)lightmap))) {
            int luminance = (int)(dynamicLuminance * 16.0);
            lightmap &= 0xFFF00000;
            lightmap |= luminance & 0xFFFFF;
        }
        return lightmap;
    }

    public double getDynamicLuminance(@NotNull class_2338 pos) {
        double result = 0.0;
        for (DynamicLightSource lightSource : this.dynamicLightSources) {
            result = LambDynLights.maxDynamicLuminance(pos, lightSource, result);
        }
        return class_3532.method_15350((double)result, (double)0.0, (double)15.0);
    }

    public static double maxDynamicLuminance(@NotNull class_2338 pos, @NotNull DynamicLightSource lightSource, double currentLuminance) {
        double multiplier;
        double lightLevel;
        double dz;
        double dy;
        double dx;
        double distance;
        int luminance = lightSource.getLuminance();
        if (luminance > 0 && (distance = Math.sqrt((dx = (double)pos.method_10263() - lightSource.getDynamicLightX() + 0.5) * dx + (dy = (double)pos.method_10264() - lightSource.getDynamicLightY() + 0.5) * dy + (dz = (double)pos.method_10260() - lightSource.getDynamicLightZ() + 0.5) * dz)) <= 7.75 && (lightLevel = (multiplier = 1.0 - distance / 7.75) * (double)luminance) > currentLuminance) {
            currentLuminance = lightLevel;
        }
        return currentLuminance;
    }

    public int getDynamicLuminanceAt(@NotNull class_2338 pos) {
        return 0;
    }

    public void addLightSource(@NotNull DynamicLightSource lightSource) {
        if (!lightSource.getDynamicLightWorld().method_8608()) {
            return;
        }
        if (!this.config.getDynamicLightsMode().isEnabled()) {
            return;
        }
        if (this.containsLightSource(lightSource)) {
            return;
        }
        this.dynamicLightSources.add(lightSource);
    }

    public boolean containsLightSource(@NotNull DynamicLightSource lightSource) {
        if (!lightSource.getDynamicLightWorld().method_8608()) {
            return false;
        }
        return this.dynamicLightSources.contains(lightSource);
    }

    public void removeLightSource(@NotNull DynamicLightSource lightSource) {
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            DynamicLightSource it = dynamicLightSources.next();
            if (!it.equals(lightSource)) continue;
            dynamicLightSources.remove();
            if (class_310.method_1551().field_1769 == null) break;
            lightSource.lambdynlights_scheduleTrackedChunksRebuild(class_310.method_1551().field_1769);
            break;
        }
    }

    public void clearLightSources() {
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        if (dynamicLightSources.hasNext()) {
            DynamicLightSource it = dynamicLightSources.next();
            dynamicLightSources.remove();
            if (class_310.method_1551().field_1769 != null) {
                it.lambdynlights_scheduleTrackedChunksRebuild(class_310.method_1551().field_1769);
            }
        }
    }

    public void removeLightSources(@NotNull Predicate<DynamicLightSource> filter) {
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            DynamicLightSource it = dynamicLightSources.next();
            if (!filter.test(it)) continue;
            dynamicLightSources.remove();
            if (class_310.method_1551().field_1769 == null) break;
            it.lambdynlights_scheduleTrackedChunksRebuild(class_310.method_1551().field_1769);
            break;
        }
    }

    public void removeEntitiesLightSource() {
        this.removeLightSources(lightSource -> lightSource instanceof class_1297 && !(lightSource instanceof class_1657));
    }

    public void removeBlockEntitiesLightSource() {
        this.removeLightSources(lightSource -> lightSource instanceof class_2586);
    }

    public void log(String info) {
        this.logger.info("[LambDynLights] " + info);
    }

    public static void scheduleChunkRebuild(@NotNull class_761 renderer, @NotNull class_2338 chunkPos) {
        ((WorldRendererAccessor)renderer).lambdynlights_scheduleChunkRebuild(chunkPos.method_10263(), chunkPos.method_10264(), chunkPos.method_10260(), false);
    }

    public static void updateTrackedChunks(@NotNull class_2338 chunkPos, @Nullable Set<class_2338> old, @Nullable Set<class_2338> newPos) {
        if (old != null) {
            old.remove(chunkPos);
        }
        if (newPos != null) {
            newPos.add(chunkPos);
        }
    }

    public static void updateTracking(@NotNull DynamicLightSource lightSource) {
        if (!lightSource.isDynamicLightEnabled() && lightSource.getLuminance() > 0) {
            lightSource.setDynamicLightEnabled(true);
        } else if (lightSource.isDynamicLightEnabled() && lightSource.getLuminance() < 1) {
            lightSource.setDynamicLightEnabled(false);
        }
    }

    public static int getLuminanceFromItemStack(@NotNull class_1799 stack, boolean submergedInWater) {
        if (LambDynLights.INSTANCE.config.hasWaterSensitiveCheck() && submergedInWater && WATER_SENSITIVE_ITEMS.method_15141((Object)stack.method_7909())) {
            return 0;
        }
        if (stack.method_7909() instanceof class_1747) {
            return ((class_1747)stack.method_7909()).method_7711().method_9564().method_26213();
        }
        if (stack.method_7909() == class_1802.field_8187) {
            return class_2246.field_10164.method_9564().method_26213();
        }
        if (stack.method_7909() == class_1802.field_8894 || stack.method_7909() == class_1802.field_8183) {
            return 10;
        }
        if (stack.method_7909() == class_1802.field_8601 || stack.method_7909() == class_1802.field_8434) {
            return 8;
        }
        if (stack.method_7909() == class_1802.field_8137) {
            return class_2246.field_10327.method_9564().method_26213() / 2;
        }
        return 0;
    }

    public static LambDynLights get() {
        return INSTANCE;
    }
}

