/*
 * Decompiled with CFR 0.152.
 */
package me.lambdaurora.lambdynlights.mixin.lightsource;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import me.lambdaurora.lambdynlights.DynamicLightSource;
import me.lambdaurora.lambdynlights.DynamicLightsMode;
import me.lambdaurora.lambdynlights.LambDynLights;
import me.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_761;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2586.class})
public abstract class BlockEntityMixin
implements DynamicLightSource {
    @Shadow
    protected class_2338 field_11867;
    @Shadow
    @Nullable
    protected class_1937 field_11863;
    @Shadow
    protected boolean field_11865;
    private int lambdynlights_luminance = 0;
    private int lambdynlights_lastLuminance = 0;
    private long lambdynlights_lastUpdate = 0L;
    private Set<class_2338> trackedLitChunkPos = new HashSet<class_2338>();

    @Override
    public double getDynamicLightX() {
        return (double)this.field_11867.method_10263() + 0.5;
    }

    @Override
    public double getDynamicLightY() {
        return (double)this.field_11867.method_10264() + 0.5;
    }

    @Override
    public double getDynamicLightZ() {
        return (double)this.field_11867.method_10260() + 0.5;
    }

    @Override
    public class_1937 getDynamicLightWorld() {
        return this.field_11863;
    }

    @Inject(method={"markRemoved"}, at={@At(value="TAIL")})
    private void onRemoved(CallbackInfo ci) {
        this.setDynamicLightEnabled(false);
    }

    @Override
    public void resetDynamicLight() {
        this.lambdynlights_lastLuminance = 0;
    }

    @Override
    public void dynamicLightTick() {
        if (this.field_11863 == null || !this.field_11863.method_8608()) {
            return;
        }
        if (!this.field_11865) {
            this.lambdynlights_luminance = DynamicLightHandlers.getLuminanceFrom((class_2586)this);
            LambDynLights.updateTracking(this);
            if (!this.isDynamicLightEnabled()) {
                this.lambdynlights_lastLuminance = 0;
            }
        }
    }

    @Override
    public int getLuminance() {
        return this.lambdynlights_luminance;
    }

    @Override
    public boolean shouldUpdateDynamicLight() {
        DynamicLightsMode mode = LambDynLights.get().config.getDynamicLightsMode();
        if (!mode.isEnabled()) {
            return false;
        }
        if (mode.hasDelay()) {
            long currentTime = System.currentTimeMillis();
            if (currentTime < this.lambdynlights_lastUpdate + (long)mode.getDelay()) {
                return false;
            }
            this.lambdynlights_lastUpdate = currentTime;
        }
        return true;
    }

    @Override
    public void lambdynlights_updateDynamicLight(@NotNull class_761 renderer) {
        if (!this.shouldUpdateDynamicLight()) {
            return;
        }
        int luminance = this.getLuminance();
        if (luminance != this.lambdynlights_lastLuminance) {
            this.lambdynlights_lastLuminance = luminance;
            if (this.trackedLitChunkPos.isEmpty()) {
                class_2338 chunkPos = new class_2338(class_3532.method_15346((int)((int)this.getDynamicLightX()), (int)16), class_3532.method_15346((int)((int)this.getDynamicLightY()), (int)16), class_3532.method_15346((int)((int)this.getDynamicLightZ()), (int)16));
                LambDynLights.updateTrackedChunks(chunkPos, null, this.trackedLitChunkPos);
                class_2350 directionX = (class_3532.method_15365((double)this.getDynamicLightX()) & 0xF) >= 8 ? class_2350.field_11034 : class_2350.field_11039;
                class_2350 directionY = (class_3532.method_15365((double)this.getDynamicLightY()) & 0xF) >= 8 ? class_2350.field_11036 : class_2350.field_11033;
                class_2350 directionZ = (class_3532.method_15365((double)this.getDynamicLightZ()) & 0xF) >= 8 ? class_2350.field_11035 : class_2350.field_11043;
                for (int i = 0; i < 7; ++i) {
                    if (i % 4 == 0) {
                        chunkPos = chunkPos.method_10093(directionX);
                    } else if (i % 4 == 1) {
                        chunkPos = chunkPos.method_10093(directionZ);
                    } else if (i % 4 == 2) {
                        chunkPos = chunkPos.method_10093(directionX.method_10153());
                    } else {
                        chunkPos = chunkPos.method_10093(directionZ.method_10153());
                        chunkPos = chunkPos.method_10093(directionY);
                    }
                    LambDynLights.updateTrackedChunks(chunkPos, null, this.trackedLitChunkPos);
                }
            }
            this.lambdynlights_scheduleTrackedChunksRebuild(renderer);
        }
    }

    @Override
    public void lambdynlights_scheduleTrackedChunksRebuild(@NotNull class_761 renderer) {
        for (class_2338 pos : this.trackedLitChunkPos) {
            LambDynLights.scheduleChunkRebuild(renderer, pos);
        }
    }
}

