/*
 * Decompiled with CFR 0.152.
 */
package org.aperlambda.lambdacommon.config;

import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import org.aperlambda.lambdacommon.LambdaConstants;
import org.aperlambda.lambdacommon.config.FileConfig;

public class PropertiesConfig
extends FileConfig<Properties> {
    private String comments = "";
    private Properties properties = new Properties();

    public PropertiesConfig() {
    }

    public PropertiesConfig(File file) {
        super(file);
    }

    @Override
    public void load() {
        try {
            this.properties.load(Files.newInputStream(this.file.toPath(), new OpenOption[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void save() {
        try {
            this.properties.store(Files.newOutputStream(this.file.toPath(), new OpenOption[0]), this.comments);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T get(String key, T def, Class<T> type) {
        Object value = this.properties.getOrDefault((Object)key, def);
        if (value.equals(def)) {
            return def;
        }
        if (value instanceof String) {
            try {
                return (T)LambdaConstants.GSON.fromJson(LambdaConstants.JSON_PARSER.parse((String)value), type);
            }
            catch (JsonSyntaxException e) {
                return def;
            }
        }
        if (value instanceof Boolean) {
            return (T)(def instanceof Boolean ? value : def);
        }
        return def;
    }

    @Override
    public void set(String key, Object value) {
        if (value instanceof Boolean) {
            this.properties.put(key, value);
        } else {
            this.properties.setProperty(key, LambdaConstants.GSON.toJson(value));
        }
        if (this.autoSave) {
            this.save();
        }
    }

    @Override
    public <T> T at(String path, T def, Class<T> type) {
        return this.get(path, def, type);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public Properties getConfig() {
        return this.properties;
    }
}

