/*
 * Decompiled with CFR 0.152.
 */
package org.aperlambda.lambdacommon.utils;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.aperlambda.lambdacommon.utils.function.PairFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Pair<K, V>
implements Serializable {
    public final K key;
    public final V value;

    public Pair(@NotNull K key, V value) {
        this.key = key;
        this.value = value;
    }

    public static <K, V> Pair<K, V> of(@NotNull K key, @Nullable V value) {
        return new Pair<K, V>(key, value);
    }

    public static <K, V> Pair<K, V> fromEntry(Map.Entry<K, V> entry) {
        return new Pair<K, V>(entry.getKey(), entry.getValue());
    }

    public static <K, V> List<Pair<K, V>> newListFromMap(Map<K, V> map) {
        ArrayList list = new ArrayList();
        map.forEach((key, value) -> list.add(new Pair<Object, Object>(key, value)));
        return list;
    }

    @NotNull
    public <M, N> Pair<? extends M, ? extends N> map(@NotNull PairFunction<K, V, ? extends M, ? extends N> mapper) {
        Objects.requireNonNull(mapper);
        return mapper.apply(this);
    }

    @NotNull
    public <N> N mapValue(@NotNull Function<? super V, ? extends N> mapper) {
        Objects.requireNonNull(mapper);
        return mapper.apply(this.value);
    }

    public Stream<Pair<K, V>> stream() {
        return Stream.of(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        return Objects.equals(this.key, pair.key) && Objects.equals(this.value, pair.value);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Pair{key: " + this.key + ", value: " + this.value + '}';
    }

    public static class JsonPairSerializer
    implements JsonSerializer<Pair<?, ?>>,
    JsonDeserializer<Pair<?, ?>> {
        public JsonElement serialize(Pair<?, ?> src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            JsonObject key = new JsonObject();
            key.addProperty("type", src.key.getClass().getName());
            key.add("data", context.serialize(src.key));
            json.add("key", (JsonElement)key);
            Object value = src.value;
            if (value != null) {
                JsonObject jsonValue = new JsonObject();
                jsonValue.addProperty("type", value.getClass().getName());
                jsonValue.add("data", context.serialize(value));
                json.add("value", (JsonElement)jsonValue);
            }
            return json;
        }

        public Pair<?, ?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!(json instanceof JsonObject)) {
                throw new JsonParseException("Cannot parse Pair<?, ?>: the json must be an object!");
            }
            JsonObject obj = (JsonObject)json;
            if (!obj.has("key") || !obj.get("key").isJsonObject()) {
                throw new JsonParseException("Key is not present or is malformed.");
            }
            JsonObject jsonKey = obj.getAsJsonObject("key");
            try {
                Class<?> type = Class.forName(jsonKey.get("type").getAsString());
                Object key = context.deserialize(jsonKey.get("data"), type);
                if (!obj.has("value")) {
                    return Pair.of(key, null);
                }
                JsonObject jsonValue = obj.getAsJsonObject("value");
                Class<?> valueType = Class.forName(jsonValue.get("type").getAsString());
                Object value = context.deserialize(jsonValue.get("data"), valueType);
                return Pair.of(key, value);
            }
            catch (ClassNotFoundException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }
}

