/*
 * Decompiled with CFR 0.152.
 */
package com.drewhannay.lanterncolors.blocks;

import com.drewhannay.lanterncolors.blocks.ColoredLanternBlock;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.item.DyeColor;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public final class ColoredLanternBlocks {
    public static final DeferredRegister<Block> REGISTRY = new DeferredRegister(ForgeRegistries.BLOCKS, "lanterncolors");
    private static final Map<DyeColor, RegistryObject<ColoredLanternBlock>> REGISTRY_OBJECTS = new EnumMap<DyeColor, RegistryObject<ColoredLanternBlock>>(DyeColor.class);

    public static void init() {
        Stream.of(DyeColor.values()).forEach(dyeColor -> {
            ColoredLanternBlock block = new ColoredLanternBlock((DyeColor)dyeColor);
            RegistryObject registeredObject = REGISTRY.register(block.registryName(), () -> block);
            REGISTRY_OBJECTS.put((DyeColor)dyeColor, (RegistryObject<ColoredLanternBlock>)registeredObject);
        });
        REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static RegistryObject<ColoredLanternBlock> getRegistryObject(DyeColor color) {
        return REGISTRY_OBJECTS.get(color);
    }

    public static Stream<ColoredLanternBlock> getBlocks() {
        return REGISTRY_OBJECTS.values().stream().map(RegistryObject::get);
    }
}

