/*
 * Decompiled with CFR 0.152.
 */
package com.drewhannay.lanterncolors.items;

import com.drewhannay.lanterncolors.blocks.ColoredLanternBlock;
import com.drewhannay.lanterncolors.blocks.ColoredLanternBlocks;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public final class ColoredLanternItems {
    public static final DeferredRegister<Item> REGISTRY = new DeferredRegister(ForgeRegistries.ITEMS, "lanterncolors");
    private static final Map<DyeColor, RegistryObject<BlockItem>> REGISTRY_OBJECTS = new EnumMap<DyeColor, RegistryObject<BlockItem>>(DyeColor.class);

    public static void init() {
        Stream.of(DyeColor.values()).forEach(dyeColor -> {
            RegistryObject<ColoredLanternBlock> block = ColoredLanternBlocks.getRegistryObject(dyeColor);
            RegistryObject registeredObject = REGISTRY.register(block.getId().func_110623_a(), () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(ItemGroup.field_78031_c)));
            REGISTRY_OBJECTS.put((DyeColor)dyeColor, (RegistryObject<BlockItem>)registeredObject);
        });
        REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static Stream<BlockItem> getItems() {
        return REGISTRY_OBJECTS.values().stream().map(RegistryObject::get);
    }
}

