/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.letthemgrow;

import com.lothrazar.letthemgrow.GrowthMod;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GrowthEvents {
    private static final String MILKED_NBTKEY = "letthemgrow:milked";
    static final int FULLGROWN = 0;

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        Animal child;
        Level world = event.getEntity().f_19853_;
        if (!world.f_46443_ && event.getEntityLiving() instanceof Animal && (child = (Animal)event.getEntityLiving()).m_146764_() < 0 && world.f_46441_.nextDouble() * 100.0 < (double)GrowthMod.CONFIG.getAnimalChance()) {
            child.m_146762_(child.m_146764_() - 1);
        }
    }

    @SubscribeEvent
    public void onEntity(PlayerInteractEvent.EntityInteract event) {
        Cow cow;
        Player player = event.getPlayer();
        if (GrowthMod.CONFIG.milkNerf() && !player.f_19853_.f_46443_ && !player.m_7500_() && event.getTarget() instanceof Cow && event.getItemStack().m_41720_() == Items.f_42446_ && !(cow = (Cow)event.getTarget()).m_6162_()) {
            int prev = cow.getPersistentData().m_128451_(MILKED_NBTKEY);
            if (prev >= 6 && player.f_19853_.f_46441_.nextDouble() < 0.25) {
                cow.m_146762_(-24000);
                cow.getPersistentData().m_128405_(MILKED_NBTKEY, 0);
                cow.getPersistentData().m_128473_(MILKED_NBTKEY);
            }
            cow.getPersistentData().m_128405_(MILKED_NBTKEY, prev + 1);
        }
    }

    @SubscribeEvent
    public void onCropGrow(BlockEvent.CropGrowEvent.Pre event) {
        if (event.getWorld().m_5822_().nextDouble() * 100.0 <= (double)GrowthMod.CONFIG.getCropsChance()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onSaplingGrowTreeEvent(SaplingGrowTreeEvent event) {
        if (event.getWorld().m_5822_().nextDouble() * 100.0 <= (double)GrowthMod.CONFIG.getSaplingChance()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Animal child;
        AgeableMob growing;
        if (GrowthMod.CONFIG.disableFeeding() && event.getTarget() instanceof AgeableMob && (growing = (AgeableMob)event.getTarget()).m_6162_() && growing instanceof Animal && (child = (Animal)growing).m_6898_(event.getItemStack())) {
            event.setCanceled(true);
        }
    }
}

