/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.letthemgrow;

import com.lothrazar.letthemgrow.GrowthMod;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GrowthEvents {
    private static final String MILKED_NBTKEY = "letthemgrow:milked";

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        World world = event.getEntity().field_70170_p;
        if (!world.field_72995_K && event.getEntityLiving() instanceof AnimalEntity) {
            AnimalEntity child = (AnimalEntity)event.getEntityLiving();
            int FULLGROWN = 0;
            if (child.func_70874_b() < FULLGROWN && world.field_73012_v.nextDouble() * 100.0 < (double)GrowthMod.config.getAnimalChance()) {
                child.func_70873_a(child.func_70874_b() - 1);
            }
        }
    }

    @SubscribeEvent
    public void onEntity(PlayerInteractEvent.EntityInteract event) {
        CowEntity cow;
        PlayerEntity player = event.getPlayer();
        if (GrowthMod.config.milkNerf() && !player.field_70170_p.field_72995_K && !player.field_71075_bZ.field_75098_d && event.getTarget() instanceof CowEntity && event.getItemStack().func_77973_b() == Items.field_151133_ar && !(cow = (CowEntity)event.getTarget()).func_70631_g_()) {
            int prev = cow.getPersistentData().func_74762_e(MILKED_NBTKEY);
            if (prev >= 6 && player.field_70170_p.field_73012_v.nextDouble() < 0.25) {
                cow.func_70873_a(-24000);
                cow.getPersistentData().func_74768_a(MILKED_NBTKEY, 0);
                cow.getPersistentData().func_82580_o(MILKED_NBTKEY);
            }
            cow.getPersistentData().func_74768_a(MILKED_NBTKEY, prev + 1);
        }
    }

    @SubscribeEvent
    public void onCropGrow(BlockEvent.CropGrowEvent.Pre event) {
        if (event.getWorld().func_201674_k().nextDouble() * 100.0 <= (double)GrowthMod.config.getCropsChance()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onSaplingGrowTreeEvent(SaplingGrowTreeEvent event) {
        if (event.getWorld().func_201674_k().nextDouble() * 100.0 <= (double)GrowthMod.config.getSaplingChance()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onServerStarting(PlayerInteractEvent.EntityInteract event) {
        AnimalEntity child;
        AgeableEntity growing;
        if (GrowthMod.config.disableFeeding() && event.getTarget() instanceof AgeableEntity && (growing = (AgeableEntity)event.getTarget()).func_70631_g_() && growing instanceof AnimalEntity && (child = (AnimalEntity)growing).func_70877_b(event.getItemStack())) {
            event.setCanceled(true);
        }
    }
}

