/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.letthemgrow;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigManager {
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    private static ForgeConfigSpec COMMON_CONFIG;
    private static ForgeConfigSpec.IntValue ANIMALCHANCE;
    private static ForgeConfigSpec.BooleanValue DISABLEFEEDING;
    private static ForgeConfigSpec.BooleanValue MILKNERF;
    private static ForgeConfigSpec.IntValue CROPSCHANCE;
    private static ForgeConfigSpec.IntValue SAPLINGCHANCE;

    private static void initConfig() {
        COMMON_BUILDER.comment("General settings").push("letthemgrow");
        MILKNERF = COMMON_BUILDER.comment("When a cow is milked too often it becomes un-milkable for a time").define("limitedMilk", true);
        SAPLINGCHANCE = COMMON_BUILDER.comment("Once every tick, this is the percentage chance that growth will be blocked; so 99 is very slow, and 1 is fast.").defineInRange("saplingSlowdownChance", 75, 0, 100);
        CROPSCHANCE = COMMON_BUILDER.comment("Once every tick, this is the percentage chance that growth will be blocked; so 99 is very slow, and 1 is fast.").defineInRange("cropsSlowdownChance", 50, 0, 100);
        ANIMALCHANCE = COMMON_BUILDER.comment("Once every tick, this is the percentage chance that growth will be blocked; so 99 is very slow, and 1 is fast.").defineInRange("livestockSlowdownChance", 70, 0, 100);
        DISABLEFEEDING = COMMON_BUILDER.comment("True to disable feeding any compatible items to child animals").define("blockFeedingYoung", true);
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }

    public ConfigManager(Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        COMMON_CONFIG.setConfig((CommentedConfig)configData);
    }

    public int getCropsChance() {
        return (Integer)CROPSCHANCE.get();
    }

    public int getAnimalChance() {
        return (Integer)ANIMALCHANCE.get();
    }

    public int getSaplingChance() {
        return (Integer)SAPLINGCHANCE.get();
    }

    public boolean disableFeeding() {
        return (Boolean)DISABLEFEEDING.get();
    }

    public boolean milkNerf() {
        return (Boolean)MILKNERF.get();
    }

    static {
        ConfigManager.initConfig();
    }
}

