/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.render.shader.ShaderProgram;
import javax.annotation.Nullable;
import net.minecraft.class_1921;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import org.lwjgl.opengl.GL20;

public class LitematicaRenderer {
    private static final LitematicaRenderer INSTANCE = new LitematicaRenderer();
    private static final ShaderProgram SHADER_ALPHA = new ShaderProgram("litematica", null, "shaders/alpha.frag");
    private class_310 mc;
    private WorldRendererSchematic worldRenderer;
    private class_4604 frustum;
    private int frameCount;
    private int originalShaderProgram;
    private float translucencyAlpha;
    private long finishTimeNano;
    private boolean renderCollidingSchematicBlocks;
    private boolean renderPiecewise;
    private boolean renderPiecewiseSchematic;
    private boolean renderPiecewiseBlocks;
    private boolean renderPiecewisePrepared;
    private boolean translucentSchematic;

    private LitematicaRenderer() {
    }

    public static LitematicaRenderer getInstance() {
        return INSTANCE;
    }

    public WorldRendererSchematic getWorldRenderer() {
        if (this.worldRenderer == null) {
            this.mc = class_310.method_1551();
            this.worldRenderer = new WorldRendererSchematic(this.mc);
        }
        return this.worldRenderer;
    }

    public void loadRenderers() {
        this.getWorldRenderer().loadRenderers();
    }

    public void onSchematicWorldChanged(@Nullable WorldSchematic worldClient) {
        this.getWorldRenderer().setWorldAndLoadRenderers(worldClient);
    }

    private void calculateFinishTime() {
        long fpsTarget = 60L;
        this.finishTimeNano = Configs.Generic.RENDER_THREAD_NO_TIMEOUT.getBooleanValue() ? Long.MAX_VALUE : System.nanoTime() + Math.max(1000000000L / fpsTarget / 2L, 0L);
    }

    public void renderSchematicOverlay(class_4587 matrices) {
        boolean invert = Hotkeys.INVERT_OVERLAY_RENDER_STATE.getKeybind().isKeybindHeld();
        if (Configs.Visuals.ENABLE_SCHEMATIC_OVERLAY.getBooleanValue() != invert) {
            boolean renderThrough = Configs.Visuals.SCHEMATIC_OVERLAY_RENDER_THROUGH.getBooleanValue() || Hotkeys.RENDER_OVERLAY_THROUGH_BLOCKS.getKeybind().isKeybindHeld();
            float lineWidth = (float)(renderThrough ? Configs.Visuals.SCHEMATIC_OVERLAY_OUTLINE_WIDTH_THROUGH.getDoubleValue() : Configs.Visuals.SCHEMATIC_OVERLAY_OUTLINE_WIDTH.getDoubleValue());
            RenderSystem.disableTexture();
            RenderSystem.disableCull();
            RenderSystem.alphaFunc((int)516, (float)0.001f);
            RenderSystem.enablePolygonOffset();
            RenderSystem.polygonOffset((float)-0.4f, (float)-0.8f);
            RenderSystem.lineWidth((float)lineWidth);
            RenderUtils.setupBlend();
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.glMultiTexCoord2f((int)33985, (float)240.0f, (float)240.0f);
            if (renderThrough) {
                RenderSystem.disableDepthTest();
            } else {
                RenderSystem.enableDepthTest();
            }
            this.getWorldRenderer().renderBlockOverlays(matrices, this.getCamera());
            RenderSystem.enableDepthTest();
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
            RenderSystem.enableCull();
            RenderSystem.enableTexture();
        }
    }

    private void setupAlphaShader() {
        this.translucentSchematic = Configs.Visuals.RENDER_BLOCKS_AS_TRANSLUCENT.getBooleanValue();
        if (this.translucentSchematic) {
            this.originalShaderProgram = class_4493.method_21923((int)35725);
            this.translucencyAlpha = (float)Configs.Visuals.GHOST_BLOCK_ALPHA.getDoubleValue();
            class_4493.method_22045((int)SHADER_ALPHA.getProgram());
            GL20.glUniform1f((int)class_4493.method_21990((int)SHADER_ALPHA.getProgram(), (CharSequence)"alpha_multiplier"), (float)this.translucencyAlpha);
        }
    }

    private void enableAlphaShader() {
        if (this.translucentSchematic) {
            class_4493.method_22045((int)SHADER_ALPHA.getProgram());
        }
    }

    private void disableAlphaShader() {
        if (this.translucentSchematic) {
            class_4493.method_22045((int)this.originalShaderProgram);
        }
    }

    public void piecewisePrepareAndUpdate(class_4604 frustum) {
        this.renderPiecewise = Configs.Generic.BETTER_RENDER_ORDER.getBooleanValue() && Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && this.mc.method_1560() != null;
        this.renderPiecewisePrepared = false;
        this.renderPiecewiseBlocks = false;
        if (this.renderPiecewise && frustum != null) {
            boolean invert = Hotkeys.INVERT_GHOST_BLOCK_RENDER_STATE.getKeybind().isKeybindHeld();
            this.renderPiecewiseSchematic = Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue() != invert;
            this.renderPiecewiseBlocks = this.renderPiecewiseSchematic && Configs.Visuals.ENABLE_SCHEMATIC_BLOCKS.getBooleanValue();
            this.renderCollidingSchematicBlocks = Configs.Visuals.RENDER_COLLIDING_SCHEMATIC_BLOCKS.getBooleanValue();
            this.mc.method_16011().method_15396("litematica_culling");
            this.calculateFinishTime();
            WorldRendererSchematic worldRenderer = this.getWorldRenderer();
            this.mc.method_16011().method_15405("litematica_terrain_setup");
            worldRenderer.setupTerrain(this.getCamera(), frustum, this.frameCount++, this.mc.field_1724.method_7325());
            this.mc.method_16011().method_15405("litematica_update_chunks");
            worldRenderer.updateChunks(this.finishTimeNano);
            this.mc.method_16011().method_15407();
            this.frustum = frustum;
            this.renderPiecewisePrepared = true;
        }
    }

    public void piecewiseRenderSolid(class_4587 matrices) {
        if (this.renderPiecewiseBlocks) {
            this.mc.method_16011().method_15396("litematica_blocks_solid");
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            this.setupAlphaShader();
            this.getWorldRenderer().renderBlockLayer(class_1921.method_23577(), matrices, this.getCamera());
            this.disableAlphaShader();
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }
            this.mc.method_16011().method_15407();
        }
    }

    public void piecewiseRenderCutoutMipped(class_4587 matrices) {
        if (this.renderPiecewiseBlocks) {
            this.mc.method_16011().method_15396("litematica_blocks_cutout_mipped");
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            this.enableAlphaShader();
            this.getWorldRenderer().renderBlockLayer(class_1921.method_23579(), matrices, this.getCamera());
            this.disableAlphaShader();
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }
            this.mc.method_16011().method_15407();
        }
    }

    public void piecewiseRenderCutout(class_4587 matrices) {
        if (this.renderPiecewiseBlocks) {
            this.mc.method_16011().method_15396("litematica_blocks_cutout");
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            this.enableAlphaShader();
            this.getWorldRenderer().renderBlockLayer(class_1921.method_23581(), matrices, this.getCamera());
            this.disableAlphaShader();
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }
            this.mc.method_16011().method_15407();
        }
    }

    public void piecewiseRenderTranslucent(class_4587 matrices) {
        if (this.renderPiecewiseBlocks) {
            this.mc.method_16011().method_15396("litematica_translucent");
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            this.enableAlphaShader();
            this.getWorldRenderer().renderBlockLayer(class_1921.method_23583(), matrices, this.getCamera());
            this.disableAlphaShader();
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }
            this.mc.method_16011().method_15407();
        }
    }

    public void piecewiseRenderOverlay(class_4587 matrices) {
        if (this.renderPiecewiseSchematic) {
            class_276 fb;
            this.mc.method_16011().method_15396("litematica_overlay");
            class_276 class_2762 = fb = class_310.method_29611() ? this.mc.field_1769.method_29360() : null;
            if (fb != null) {
                fb.method_1235(false);
            }
            this.renderSchematicOverlay(matrices);
            if (fb != null) {
                this.mc.method_1522().method_1235(false);
            }
            this.mc.method_16011().method_15407();
        }
        this.cleanup();
    }

    public void piecewiseRenderEntities(class_4587 matrices, float partialTicks) {
        if (this.renderPiecewiseBlocks) {
            this.mc.method_16011().method_15396("litematica_entities");
            RenderUtils.setupBlend();
            this.getWorldRenderer().renderEntities(this.getCamera(), this.frustum, matrices, partialTicks);
            RenderSystem.disableBlend();
            this.mc.method_16011().method_15407();
        }
    }

    private class_4184 getCamera() {
        return this.mc.field_1773.method_19418();
    }

    private void cleanup() {
        this.renderPiecewise = false;
        this.renderPiecewisePrepared = false;
        this.renderPiecewiseSchematic = false;
        this.renderPiecewiseBlocks = false;
    }

    static {
        int program = SHADER_ALPHA.getProgram();
        int oldProgram = class_4493.method_21923((int)35725);
        class_4493.method_22045((int)program);
        class_4493.method_22030((int)class_4493.method_21990((int)program, (CharSequence)"texture"), (int)0);
        class_4493.method_22045((int)oldProgram);
    }
}

