/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import com.google.common.collect.ArrayListMultimap;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.infohud.IInfoHudRenderer;
import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.scheduler.tasks.TaskBase;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.ReplaceBehavior;
import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class TaskPasteSchematicSetblock
extends TaskBase
implements IInfoHudRenderer {
    private final ArrayListMultimap<class_1923, IntBoundingBox> boxesInChunks = ArrayListMultimap.create();
    private final List<IntBoundingBox> boxesInCurrentChunk = new ArrayList<IntBoundingBox>();
    private final List<class_1923> chunks = new ArrayList<class_1923>();
    private final PositionUtils.ChunkPosComparator comparator;
    private final int maxCommandsPerTick;
    private final boolean changedBlockOnly;
    private final ReplaceBehavior replace;
    private int sentCommandsThisTick;
    private int sentCommandsTotal;
    private int currentX;
    private int currentY;
    private int currentZ;
    private int currentIndex;
    private int boxVolume;
    private boolean boxInProgress;

    public TaskPasteSchematicSetblock(SchematicPlacement placement, boolean changedBlocksOnly) {
        this.changedBlockOnly = changedBlocksOnly;
        this.maxCommandsPerTick = Configs.Generic.PASTE_COMMAND_LIMIT.getIntegerValue();
        this.comparator = new PositionUtils.ChunkPosComparator();
        this.comparator.setClosestFirst(true);
        this.replace = (ReplaceBehavior)Configs.Generic.PASTE_REPLACE_BEHAVIOR.getOptionListValue();
        this.name = StringUtils.translate((String)"litematica.gui.label.task_name.paste", (Object[])new Object[0]);
        Set<class_1923> touchedChunks = placement.getTouchedChunks();
        for (class_1923 pos : touchedChunks) {
            this.boxesInChunks.putAll((Object)pos, (Iterable)placement.getBoxesWithinChunk(pos.field_9181, pos.field_9180).values());
            this.chunks.add(pos);
        }
        this.sortChunkList();
        InfoHud.getInstance().addInfoHudRenderer(this, true);
        this.updateInfoHudLines();
    }

    @Override
    public boolean canExecute() {
        return !this.boxesInChunks.isEmpty() && this.mc.field_1687 != null && this.mc.field_1724 != null;
    }

    @Override
    public boolean execute() {
        WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
        class_638 worldClient = this.mc.field_1687;
        this.sentCommandsThisTick = 0;
        int processed = 0;
        int chunkAttempts = 0;
        if (this.sentCommandsTotal == 0) {
            this.mc.field_1724.method_3142("/gamerule sendCommandFeedback false");
        }
        block0: while (!this.chunks.isEmpty()) {
            class_1923 pos = this.chunks.get(0);
            if (!this.canProcessChunk(pos, worldSchematic, worldClient)) {
                if (this.boxInProgress || chunkAttempts > 0) {
                    return false;
                }
                this.sortChunkList();
                ++chunkAttempts;
                continue;
            }
            while (!this.boxesInCurrentChunk.isEmpty()) {
                IntBoundingBox box = this.boxesInCurrentChunk.get(0);
                if (this.processBox(pos, box, worldSchematic, worldClient, this.mc.field_1724)) {
                    this.boxesInCurrentChunk.remove(0);
                    if (!this.boxesInCurrentChunk.isEmpty()) continue;
                    this.boxesInChunks.removeAll((Object)pos);
                    this.chunks.remove(0);
                    ++processed;
                    if (this.chunks.isEmpty()) {
                        this.finished = true;
                        return true;
                    }
                    this.sortChunkList();
                    continue block0;
                }
                if (processed > 0) {
                    this.updateInfoHudLines();
                }
                return false;
            }
        }
        if (processed > 0) {
            this.updateInfoHudLines();
        }
        return false;
    }

    private void sortChunkList() {
        if (this.chunks.size() > 0) {
            if (this.mc.field_1724 != null) {
                this.comparator.setReferencePosition(PositionUtils.getEntityBlockPos((class_1297)this.mc.field_1724));
                Collections.sort(this.chunks, this.comparator);
            }
            this.boxesInCurrentChunk.clear();
            this.boxesInCurrentChunk.addAll(this.boxesInChunks.get((Object)this.chunks.get(0)));
        }
    }

    protected boolean canProcessChunk(class_1923 pos, WorldSchematic worldSchematic, class_638 worldClient) {
        if (!worldSchematic.getChunkProvider().method_12123(pos.field_9181, pos.field_9180) || DataManager.getSchematicPlacementManager().hasPendingRebuildFor(pos)) {
            return false;
        }
        return this.areSurroundingChunksLoaded(pos, worldClient, 1);
    }

    protected boolean processBox(class_1923 pos, IntBoundingBox box, WorldSchematic worldSchematic, class_638 worldClient, class_746 player) {
        class_2338.class_2339 posMutable = new class_2338.class_2339();
        ChunkSchematic chunkSchematic = worldSchematic.getChunkProvider().getChunk(pos.field_9181, pos.field_9180);
        class_2818 chunkClient = worldClient.method_8497(pos.field_9181, pos.field_9180);
        if (!this.boxInProgress) {
            this.currentX = box.minX;
            this.currentY = box.minY;
            this.currentZ = box.minZ;
            this.boxVolume = (box.maxX - box.minX + 1) * (box.maxY - box.minY + 1) * (box.maxZ - box.minZ + 1);
            this.currentIndex = 0;
            this.boxInProgress = true;
        }
        while (this.currentIndex < this.boxVolume) {
            posMutable.method_10103(this.currentX, this.currentY, this.currentZ);
            if (++this.currentY > box.maxY) {
                this.currentY = box.minY;
                if (++this.currentX > box.maxX) {
                    this.currentX = box.minX;
                    ++this.currentZ;
                }
            }
            ++this.currentIndex;
            class_2680 stateSchematic = chunkSchematic.method_8320((class_2338)posMutable);
            class_2680 stateClient = chunkClient.method_8320((class_2338)posMutable);
            if (stateSchematic.method_26215() && stateClient.method_26215() || this.changedBlockOnly && stateClient == stateSchematic || this.replace == ReplaceBehavior.NONE && !stateClient.method_26215() || this.replace == ReplaceBehavior.WITH_NON_AIR && stateSchematic.method_26215()) continue;
            this.sendSetBlockCommand(posMutable.method_10263(), posMutable.method_10264(), posMutable.method_10260(), stateSchematic, player);
            if (++this.sentCommandsThisTick < this.maxCommandsPerTick) continue;
            break;
        }
        if (this.currentIndex >= this.boxVolume) {
            this.summonEntities(box, worldSchematic, player);
            this.boxInProgress = false;
            return true;
        }
        return false;
    }

    private void summonEntities(IntBoundingBox box, WorldSchematic worldSchematic, class_746 player) {
        class_238 bb = new class_238((double)box.minX, (double)box.minY, (double)box.minZ, (double)(box.maxX + 1), (double)(box.maxY + 1), (double)(box.maxZ + 1));
        List entities = worldSchematic.method_8333(null, bb, null);
        for (class_1297 entity : entities) {
            String id = EntityUtils.getEntityId(entity);
            if (id == null) continue;
            String strCommand = String.format(Locale.ROOT, "/summon %s %f %f %f", id, entity.method_23317(), entity.method_23318(), entity.method_23321());
            player.method_3142(strCommand);
        }
    }

    private void sendSetBlockCommand(int x, int y, int z, class_2680 state, class_746 player) {
        String cmdName = Configs.Generic.PASTE_COMMAND_SETBLOCK.getStringValue();
        String blockString = class_2259.method_9685((class_2680)state);
        String strCommand = String.format("/%s %d %d %d %s", cmdName, x, y, z, blockString);
        player.method_3142(strCommand);
        ++this.sentCommandsTotal;
    }

    @Override
    public void stop() {
        if (this.finished) {
            InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"litematica.message.schematic_pasted_using_setblock", (Object[])new Object[]{this.sentCommandsTotal});
        } else {
            InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.schematic_paste_failed", (Object[])new Object[0]);
        }
        if (this.mc.field_1724 != null) {
            this.mc.field_1724.method_3142("/gamerule sendCommandFeedback true");
        }
        InfoHud.getInstance().removeInfoHudRenderer(this, false);
        super.stop();
    }

    private void updateInfoHudLines() {
        ArrayList<String> hudLines = new ArrayList<String>();
        String pre = GuiBase.TXT_WHITE + GuiBase.TXT_BOLD;
        String title = StringUtils.translate((String)"litematica.gui.label.schematic_paste.missing_chunks", (Object[])new Object[]{this.chunks.size()});
        hudLines.add(String.format("%s%s%s", pre, title, GuiBase.TXT_RST));
        int maxLines = Math.min(this.chunks.size(), Configs.InfoOverlays.INFO_HUD_MAX_LINES.getIntegerValue());
        for (int i = 0; i < maxLines; ++i) {
            class_1923 pos = this.chunks.get(i);
            hudLines.add(String.format("cx: %5d, cz: %5d (x: %d, z: %d)", pos.field_9181, pos.field_9180, pos.field_9181 << 4, pos.field_9180 << 4));
        }
        this.infoHudLines = hudLines;
    }
}

