/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic.conversion;

import fi.dy.masa.litematica.schematic.conversion.SchematicConversionFixers;
import fi.dy.masa.litematica.schematic.conversion.SchematicConversionMaps;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import java.util.Arrays;
import java.util.IdentityHashMap;
import javax.annotation.Nullable;
import net.minecraft.class_2215;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2283;
import net.minecraft.class_2320;
import net.minecraft.class_2323;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2358;
import net.minecraft.class_2362;
import net.minecraft.class_2372;
import net.minecraft.class_2389;
import net.minecraft.class_2418;
import net.minecraft.class_2428;
import net.minecraft.class_2457;
import net.minecraft.class_2462;
import net.minecraft.class_2484;
import net.minecraft.class_2487;
import net.minecraft.class_2493;
import net.minecraft.class_2504;
import net.minecraft.class_2510;
import net.minecraft.class_2513;
import net.minecraft.class_2521;
import net.minecraft.class_2538;
import net.minecraft.class_2541;
import net.minecraft.class_2544;
import net.minecraft.class_2546;
import net.minecraft.class_2549;
import net.minecraft.class_2680;

public class SchematicConverter {
    private final IdentityHashMap<Class<? extends class_2248>, SchematicConversionFixers.IStateFixer> fixersPerBlock = new IdentityHashMap();
    private IdentityHashMap<class_2680, SchematicConversionFixers.IStateFixer> postProcessingStateFixers = new IdentityHashMap();

    private SchematicConverter() {
        this.addPostUpdateBlocks();
    }

    public static SchematicConverter create() {
        return new SchematicConverter();
    }

    public boolean getConvertedStatesForBlock(int schematicBlockId, String blockName, class_2680[] paletteOut) {
        int shiftedOldVanillaId = SchematicConversionMaps.getOldNameToShiftedBlockId(blockName);
        int successCount = 0;
        if (shiftedOldVanillaId >= 0) {
            for (int meta = 0; meta < 16; ++meta) {
                class_2680 state = SchematicConversionMaps.get_1_13_2_StateForIdMeta(shiftedOldVanillaId & 0xFFF0 | meta);
                if (state == null) continue;
                paletteOut[schematicBlockId << 4 | meta] = state;
                ++successCount;
            }
        } else {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)("Failed to convert block with old name '" + blockName + "'"), (Object[])new Object[0]);
        }
        return successCount > 0;
    }

    public boolean getVanillaBlockPalette(class_2680[] paletteOut) {
        for (int idMeta = 0; idMeta < paletteOut.length; ++idMeta) {
            class_2680 state = SchematicConversionMaps.get_1_13_2_StateForIdMeta(idMeta);
            if (state == null) continue;
            paletteOut[idMeta] = state;
        }
        return true;
    }

    public class_2680[] getBlockStatePaletteForBlockPalette(String[] blockPalette) {
        Object[] palette = new class_2680[blockPalette.length * 16];
        Arrays.fill(palette, class_2246.field_10124.method_9564());
        for (int schematicBlockId = 0; schematicBlockId < blockPalette.length; ++schematicBlockId) {
            String blockName = blockPalette[schematicBlockId];
            this.getConvertedStatesForBlock(schematicBlockId, blockName, (class_2680[])palette);
        }
        return palette;
    }

    public boolean createPostProcessStateFilter(class_2680[] palette) {
        boolean needsPostProcess = false;
        this.postProcessingStateFixers.clear();
        for (int i = 0; i < palette.length; ++i) {
            class_2680 state = palette[i];
            if (!this.needsPostProcess(state)) continue;
            this.postProcessingStateFixers.put(state, this.getFixerFor(state));
            needsPostProcess = true;
        }
        return needsPostProcess;
    }

    public IdentityHashMap<class_2680, SchematicConversionFixers.IStateFixer> getPostProcessStateFilter() {
        return this.postProcessingStateFixers;
    }

    private boolean needsPostProcess(class_2680 state) {
        return !state.method_26215() && this.fixersPerBlock.containsKey(state.method_26204().getClass());
    }

    @Nullable
    private SchematicConversionFixers.IStateFixer getFixerFor(class_2680 state) {
        return this.fixersPerBlock.get(state.method_26204().getClass());
    }

    public class_2487 fixTileEntityNBT(class_2487 tag, class_2680 state) {
        return tag;
    }

    private void addPostUpdateBlocks() {
        this.fixersPerBlock.put(class_2283.class, SchematicConversionFixers.FIXER_CHRORUS_PLANT);
        this.fixersPerBlock.put(class_2323.class, SchematicConversionFixers.FIXER_DOOR);
        this.fixersPerBlock.put(class_2354.class, SchematicConversionFixers.FIXER_FENCE);
        this.fixersPerBlock.put(class_2349.class, SchematicConversionFixers.FIXER_FENCE_GATE);
        this.fixersPerBlock.put(class_2358.class, SchematicConversionFixers.FIXER_FIRE);
        this.fixersPerBlock.put(class_2372.class, SchematicConversionFixers.FIXER_DIRT_SNOWY);
        this.fixersPerBlock.put(class_2418.class, SchematicConversionFixers.FIXER_DIRT_SNOWY);
        this.fixersPerBlock.put(class_2389.class, SchematicConversionFixers.FIXER_PANE);
        this.fixersPerBlock.put(class_2462.class, SchematicConversionFixers.FIXER_REDSTONE_REPEATER);
        this.fixersPerBlock.put(class_2457.class, SchematicConversionFixers.FIXER_REDSTONE_WIRE);
        this.fixersPerBlock.put(class_2493.class, SchematicConversionFixers.FIXER_DIRT_SNOWY);
        this.fixersPerBlock.put(class_2513.class, SchematicConversionFixers.FIXER_STEM);
        this.fixersPerBlock.put(class_2504.class, SchematicConversionFixers.FIXER_PANE);
        this.fixersPerBlock.put(class_2510.class, SchematicConversionFixers.FIXER_STAIRS);
        this.fixersPerBlock.put(class_2521.class, SchematicConversionFixers.FIXER_DOUBLE_PLANT);
        this.fixersPerBlock.put(class_2320.class, SchematicConversionFixers.FIXER_DOUBLE_PLANT);
        this.fixersPerBlock.put(class_2538.class, SchematicConversionFixers.FIXER_TRIPWIRE);
        this.fixersPerBlock.put(class_2541.class, SchematicConversionFixers.FIXER_VINE);
        this.fixersPerBlock.put(class_2544.class, SchematicConversionFixers.FIXER_WALL);
        this.fixersPerBlock.put(class_2215.class, SchematicConversionFixers.FIXER_BANNER);
        this.fixersPerBlock.put(class_2546.class, SchematicConversionFixers.FIXER_BANNER_WALL);
        this.fixersPerBlock.put(class_2244.class, SchematicConversionFixers.FIXER_BED);
        this.fixersPerBlock.put(class_2362.class, SchematicConversionFixers.FIXER_FLOWER_POT);
        this.fixersPerBlock.put(class_2428.class, SchematicConversionFixers.FIXER_NOTE_BLOCK);
        this.fixersPerBlock.put(class_2484.class, SchematicConversionFixers.FIXER_SKULL);
        this.fixersPerBlock.put(class_2549.class, SchematicConversionFixers.FIXER_SKULL_WALL);
    }
}

