/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import com.google.common.collect.ArrayListMultimap;
import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.scheduler.tasks.TaskPasteSchematicPerChunkBase;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.util.SchematicPlacingUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.WorldUtils;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_1132;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class TaskPasteSchematicPerChunkDirect
extends TaskPasteSchematicPerChunkBase {
    private final ArrayListMultimap<class_1923, SchematicPlacement> placementsPerChunk = ArrayListMultimap.create();

    public TaskPasteSchematicPerChunkDirect(Collection<SchematicPlacement> placements, LayerRange range, boolean changedBlocksOnly) {
        super(placements, range, changedBlocksOnly);
    }

    @Override
    protected void onChunkAddedForHandling(class_1923 pos, SchematicPlacement placement) {
        super.onChunkAddedForHandling(pos, placement);
        this.placementsPerChunk.put((Object)pos, (Object)placement);
    }

    @Override
    public boolean canExecute() {
        if (!super.canExecute() || !this.mc.method_1496()) {
            return false;
        }
        class_1937 world = WorldUtils.getBestWorld((class_310)this.mc);
        return world != null && !world.field_9236;
    }

    @Override
    public boolean execute() {
        WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
        class_638 worldClient = this.mc.field_1687;
        class_1937 world = WorldUtils.getBestWorld((class_310)this.mc);
        int processed = 0;
        class_1132 server = this.mc.method_1576();
        long timeStart = class_156.method_648();
        long vanillaTickTime = server.field_4573[server.method_3780() % 100];
        this.sortChunkList();
        for (int chunkIndex = 0; chunkIndex < this.chunks.size(); ++chunkIndex) {
            class_1923 pos = (class_1923)this.chunks.get(chunkIndex);
            long currentTime = class_156.method_648();
            long elapsedTickTime = vanillaTickTime + (currentTime - timeStart);
            if (elapsedTickTime >= 60000000L) break;
            if (!this.canProcessChunk(pos, worldSchematic, worldClient)) continue;
            ArrayList placements = new ArrayList(this.placementsPerChunk.get((Object)pos));
            for (SchematicPlacement placement : placements) {
                if (!SchematicPlacingUtils.placeToWorldWithinChunk(world, pos, placement, this.replace, false)) continue;
                this.placementsPerChunk.remove((Object)pos, (Object)placement);
                ++processed;
            }
            if (this.placementsPerChunk.containsKey((Object)pos)) continue;
            this.chunks.remove(chunkIndex);
            --chunkIndex;
        }
        if (this.chunks.isEmpty()) {
            this.finished = true;
            return true;
        }
        if (processed > 0) {
            this.updateInfoHudLines();
        }
        return false;
    }

    @Override
    public void stop() {
        if (this.finished) {
            InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"litematica.message.schematic_pasted", (Object[])new Object[0]);
        } else {
            InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.schematic_paste_failed", (Object[])new Object[0]);
        }
        InfoHud.getInstance().removeInfoHudRenderer(this, false);
        super.stop();
    }
}

