/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.world;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.litematica.render.LitematicaRenderer;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.world.ChunkManagerSchematic;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1863;
import net.minecraft.class_1925;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1951;
import net.minecraft.class_1959;
import net.minecraft.class_22;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_269;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3695;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5415;
import net.minecraft.class_5455;
import net.minecraft.class_5504;

public class WorldSchematic
extends class_1937 {
    private static final class_5321<class_1937> REGISTRY_KEY = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960("litematica", "schematic_world"));
    private final class_310 mc;
    private final WorldRendererSchematic worldRenderer;
    private final ChunkManagerSchematic chunkManagerSchematic;
    private final Int2ObjectOpenHashMap<class_1297> regularEntities = new Int2ObjectOpenHashMap();
    private int nextEntityId;

    protected WorldSchematic(class_5269 mutableWorldProperties, class_2874 dimensionType, Supplier<class_3695> supplier) {
        super(mutableWorldProperties, REGISTRY_KEY, dimensionType, supplier, true, true, 0L);
        this.mc = class_310.method_1551();
        this.worldRenderer = LitematicaRenderer.getInstance().getWorldRenderer();
        this.chunkManagerSchematic = new ChunkManagerSchematic(this);
    }

    public ChunkManagerSchematic getChunkProvider() {
        return this.chunkManagerSchematic;
    }

    public ChunkManagerSchematic getChunkManager() {
        return this.chunkManagerSchematic;
    }

    public class_1951<class_2248> method_8397() {
        return class_1925.method_8339();
    }

    public class_1951<class_3611> method_8405() {
        return class_1925.method_8339();
    }

    public int getRegularEntityCount() {
        return this.regularEntities.size();
    }

    public class_2818 method_8500(class_2338 pos) {
        return this.method_8497(pos.method_10263() >> 4, pos.method_10260() >> 4);
    }

    public class_2818 method_8497(int chunkX, int chunkZ) {
        return this.chunkManagerSchematic.getChunk(chunkX, chunkZ);
    }

    public class_2791 method_8402(int chunkX, int chunkZ, class_2806 status, boolean required) {
        return this.method_8497(chunkX, chunkZ);
    }

    public class_1959 method_22387(int biomeX, int biomeY, int biomeZ) {
        return class_5504.field_26734;
    }

    public boolean method_8652(class_2338 pos, class_2680 newState, int flags) {
        if (pos.method_10264() < 0 || pos.method_10264() >= 256) {
            return false;
        }
        return this.method_8497(pos.method_10263() >> 4, pos.method_10260() >> 4).method_12010(pos, newState, false) != null;
    }

    public boolean method_8649(class_1297 entityIn) {
        return this.spawnEntityBase(entityIn);
    }

    private boolean spawnEntityBase(class_1297 entity) {
        int cz;
        int cx = class_3532.method_15357((double)(entity.method_23317() / 16.0));
        if (!this.chunkManagerSchematic.method_12123(cx, cz = class_3532.method_15357((double)(entity.method_23321() / 16.0)))) {
            return false;
        }
        entity.method_5838(this.nextEntityId++);
        int id = entity.method_5628();
        this.removeEntity(id);
        this.regularEntities.put(id, (Object)entity);
        this.chunkManagerSchematic.getChunk(class_3532.method_15357((double)(entity.method_23317() / 16.0)), class_3532.method_15357((double)(entity.method_23321() / 16.0))).method_12002(entity);
        return true;
    }

    public void removeEntity(int id) {
        class_1297 entity = (class_1297)this.regularEntities.remove(id);
        if (entity != null) {
            entity.method_5650();
            entity.method_18375();
            if (entity.field_6016) {
                this.method_8497(entity.field_6024, entity.field_5980).method_12203(entity);
            }
        }
    }

    @Nullable
    public class_1297 method_8469(int id) {
        return (class_1297)this.regularEntities.get(id);
    }

    public List<? extends class_1657> method_18456() {
        return ImmutableList.of();
    }

    public void unloadBlockEntities(Collection<class_2586> blockEntities) {
        Set remove = Collections.newSetFromMap(new IdentityHashMap());
        remove.addAll(blockEntities);
        this.field_9246.removeAll(remove);
        this.field_9231.removeAll(remove);
    }

    public long method_8510() {
        return this.mc.field_1687 != null ? this.mc.field_1687.method_8510() : 0L;
    }

    @Nullable
    public class_22 method_17891(String id) {
        return null;
    }

    public void method_17890(class_22 mapState) {
    }

    public int method_17889() {
        return 0;
    }

    public class_269 method_8428() {
        return this.mc.field_1687 != null ? this.mc.field_1687.method_8428() : null;
    }

    public class_1863 method_8433() {
        return this.mc.field_1687 != null ? this.mc.field_1687.method_8433() : null;
    }

    public class_5415 method_8514() {
        return this.mc.field_1687 != null ? this.mc.field_1687.method_8514() : null;
    }

    public void method_16109(class_2338 pos, class_2680 stateOld, class_2680 stateNew) {
        this.scheduleBlockRenders(pos.method_10263() >> 4, pos.method_10264() >> 4, pos.method_10260() >> 4);
    }

    public void scheduleBlockRenders(int chunkX, int chunkY, int chunkZ) {
        if (chunkY >= 0 && chunkY < 16) {
            this.worldRenderer.scheduleChunkRenders(chunkX, chunkY, chunkZ);
        }
    }

    public void scheduleChunkRenders(int chunkX, int chunkZ) {
        for (int chunkY = 0; chunkY < 16; ++chunkY) {
            this.worldRenderer.scheduleChunkRenders(chunkX, chunkY, chunkZ);
        }
    }

    public void scheduleChunkRenders(int minBlockX, int minBlockY, int minBlockZ, int maxBlockX, int maxBlockY, int maxBlockZ) {
        int minChunkX = Math.min(minBlockX, maxBlockX) >> 4;
        int minChunkY = class_3532.method_15340((int)(Math.min(minBlockY, maxBlockY) >> 4), (int)0, (int)15);
        int minChunkZ = Math.min(minBlockZ, maxBlockZ) >> 4;
        int maxChunkX = Math.max(minBlockX, maxBlockX) >> 4;
        int maxChunkY = class_3532.method_15340((int)(Math.max(minBlockY, maxBlockY) >> 4), (int)0, (int)15);
        int maxChunkZ = Math.max(minBlockZ, maxBlockZ) >> 4;
        for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
            for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
                for (int cy = minChunkY; cy <= maxChunkY; ++cy) {
                    this.worldRenderer.scheduleChunkRenders(cx, cy, cz);
                }
            }
        }
    }

    public float method_24852(class_2350 direction, boolean shaded) {
        return 0.0f;
    }

    public int method_8314(class_1944 type, class_2338 pos) {
        return 15;
    }

    public int method_22335(class_2338 pos, int defaultValue) {
        return 15;
    }

    public void method_8413(class_2338 blockPos_1, class_2680 blockState_1, class_2680 blockState_2, int flags) {
    }

    public void method_8517(int entityId, class_2338 pos, int progress) {
    }

    public void method_8474(int eventId, class_2338 pos, int data) {
    }

    public void method_8444(@Nullable class_1657 entity, int id, class_2338 pos, int data) {
    }

    public void method_8406(class_2394 particleParameters_1, double double_1, double double_2, double double_3, double double_4, double double_5, double double_6) {
    }

    public void method_8466(class_2394 particleParameters_1, boolean boolean_1, double double_1, double double_2, double double_3, double double_4, double double_5, double double_6) {
    }

    public void method_8494(class_2394 particleParameters_1, double double_1, double double_2, double double_3, double double_4, double double_5, double double_6) {
    }

    public void method_17452(class_2394 particleParameters_1, boolean boolean_1, double double_1, double double_2, double double_3, double double_4, double double_5, double double_6) {
    }

    public void method_8486(double x, double y, double z, class_3414 soundIn, class_3419 category, float volume, float pitch, boolean distanceDelay) {
    }

    public void method_8396(class_1657 player, class_2338 pos, class_3414 soundIn, class_3419 category, float volume, float pitch) {
    }

    public void method_8465(class_1657 player, double x, double y, double z, class_3414 soundIn, class_3419 category, float volume, float pitch) {
    }

    public void method_8449(@Nullable class_1657 player, class_1297 entity, class_3414 sound, class_3419 category, float volume, float pitch) {
    }

    public class_5455 method_30349() {
        return this.mc.field_1687.method_30349();
    }
}

