/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigValue;
import fi.dy.masa.malilib.config.IHotkeyTogglable;
import fi.dy.masa.malilib.config.options.ConfigTypeWrapper;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.malilib.util.JsonUtils;
import java.util.List;

public class ConfigUtils {
    public static void readConfigBase(JsonObject root, String category, List<? extends IConfigBase> options) {
        JsonObject obj = JsonUtils.getNestedObject(root, category, false);
        if (obj != null) {
            for (IConfigBase iConfigBase : options) {
                if (!obj.has(iConfigBase.getName())) continue;
                iConfigBase.setValueFromJsonElement(obj.get(iConfigBase.getName()));
            }
        }
    }

    public static void readHotkeys(JsonObject root, String keyHotkey, List<? extends IHotkey> hotkeys) {
        JsonObject objHotkeys = JsonUtils.getNestedObject(root, keyHotkey, false);
        if (objHotkeys != null) {
            for (IHotkey iHotkey : hotkeys) {
                String keyVal = null;
                IKeybind keybind = iHotkey.getKeybind();
                JsonObject objKeybind = JsonUtils.getNestedObject(objHotkeys, iHotkey.getName(), false);
                if (objKeybind != null) {
                    if (JsonUtils.hasString(objKeybind, "keys")) {
                        keyVal = objKeybind.get("keys").getAsString();
                    }
                    if (JsonUtils.hasObject(objKeybind, "settings")) {
                        keybind.setSettings(KeybindSettings.fromJson(objKeybind.getAsJsonObject("settings")));
                    }
                } else if (JsonUtils.hasString(objHotkeys, iHotkey.getName())) {
                    keyVal = JsonUtils.getString(objHotkeys, iHotkey.getName());
                }
                if (keyVal == null) continue;
                iHotkey.getKeybind().setValueFromString(keyVal);
            }
        }
    }

    public static void readHotkeyToggleOptions(JsonObject root, String keyHotkey, String keyBoolean, List<? extends IHotkeyTogglable> options) {
        if (JsonUtils.hasObject(root, keyHotkey)) {
            ConfigUtils.readHotkeys(root, keyHotkey, options);
        }
        if (JsonUtils.hasObject(root, keyBoolean)) {
            ConfigUtils.readConfigBase(root, keyBoolean, options);
        }
    }

    public static void writeConfigBase(JsonObject root, String category, List<? extends IConfigBase> options) {
        JsonObject obj = JsonUtils.getNestedObject(root, category, true);
        for (IConfigBase iConfigBase : options) {
            obj.add(iConfigBase.getName(), iConfigBase.getAsJsonElement());
        }
    }

    public static void writeHotkeys(JsonObject root, String keyHotkey, List<? extends IHotkey> hotkeys) {
        JsonObject objHotkeys = JsonUtils.getNestedObject(root, keyHotkey, true);
        for (IHotkey iHotkey : hotkeys) {
            JsonObject obj = new JsonObject();
            obj.add("keys", (JsonElement)new JsonPrimitive(iHotkey.getKeybind().getStringValue()));
            obj.add("settings", (JsonElement)iHotkey.getKeybind().getSettings().toJson());
            objHotkeys.add(iHotkey.getName(), (JsonElement)obj);
        }
    }

    public static void writeHotkeyToggleOptions(JsonObject root, String keyHotkey, String keyBoolean, List<? extends IHotkeyTogglable> options) {
        ConfigUtils.writeConfigBase(root, keyBoolean, options);
        ConfigUtils.writeHotkeys(root, keyHotkey, options);
    }

    public static List<? extends IConfigValue> createConfigWrapperForType(ConfigType wrappedType, List<? extends IConfigValue> toWrap) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < toWrap.size(); ++i) {
            builder.add((Object)new ConfigTypeWrapper(wrappedType, toWrap.get(i)));
        }
        return builder.build();
    }
}

