/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.config.IConfigInteger;
import fi.dy.masa.malilib.gui.GuiDialogBase;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.GuiTextFieldInteger;
import fi.dy.masa.malilib.gui.interfaces.IDialogHandler;
import fi.dy.masa.malilib.gui.interfaces.ITextFieldListener;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.render.shader.ShaderProgram;
import fi.dy.masa.malilib.util.StringUtils;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.class_285;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.lwjgl.opengl.GL20;

public class GuiColorEditorHSV
extends GuiDialogBase {
    protected static final ShaderProgram SHADER_HUE = new ShaderProgram("malilib", null, "shaders/sv_selector.frag");
    protected final IConfigInteger config;
    @Nullable
    protected final IDialogHandler dialogHandler;
    @Nullable
    protected Element clickedElement;
    @Nullable
    protected Element currentTextInputElement;
    protected GuiTextFieldGeneric textFieldFullColor;
    protected GuiTextFieldGeneric textFieldH;
    protected GuiTextFieldGeneric textFieldS;
    protected GuiTextFieldGeneric textFieldV;
    protected GuiTextFieldGeneric textFieldR;
    protected GuiTextFieldGeneric textFieldG;
    protected GuiTextFieldGeneric textFieldB;
    protected boolean mouseDown;
    protected int color;
    protected int xHS;
    protected int yHS;
    protected int xHFullSV;
    protected int xH;
    protected int yH;
    protected int sizeHS;
    protected int widthHFullSV;
    protected int widthSlider;
    protected int heightSlider;
    protected int gapSlider;
    protected float relH;
    protected float relS;
    protected float relV;
    protected float relR;
    protected float relG;
    protected float relB;

    public GuiColorEditorHSV(IConfigInteger config, @Nullable IDialogHandler dialogHandler, class_437 parent) {
        this.config = config;
        this.dialogHandler = dialogHandler;
        if (this.dialogHandler == null) {
            this.setParent(parent);
        }
        this.title = StringUtils.translate("malilib.gui.title.color_editor", new Object[0]);
        this.setWidthAndHeight(300, 160);
        this.centerOnScreen();
        this.method_25423(this.mc, this.dialogWidth, this.dialogHeight);
    }

    @Override
    public void setPosition(int left, int top) {
        super.setPosition(left, top);
        this.xHS = this.dialogLeft + 6;
        this.yHS = this.dialogTop + 24;
        this.xH = this.dialogLeft + 160;
        this.yH = this.dialogTop + 24;
        this.xHFullSV = this.xHS + 110;
        this.sizeHS = 102;
        this.widthHFullSV = 16;
        this.widthSlider = 90;
        this.heightSlider = 12;
        this.gapSlider = 6;
    }

    @Override
    public void initGui() {
        this.clearElements();
        int xLabel = this.dialogLeft + 148;
        int xTextField = xLabel + 110;
        int y = this.dialogTop + 24;
        y += this.createComponentElements(xTextField, y, xLabel, Element.H);
        y += this.createComponentElements(xTextField, y, xLabel, Element.S);
        y += this.createComponentElements(xTextField, y, xLabel, Element.V);
        y += this.createComponentElements(xTextField, y, xLabel, Element.R);
        y += this.createComponentElements(xTextField, y, xLabel, Element.G);
        y += this.createComponentElements(xTextField, y, xLabel, Element.B);
        this.addLabel(this.xH - 26, y + 3, 12, 12, 0xFFFFFF, "HEX:");
        this.textFieldFullColor = new GuiTextFieldGeneric(this.xH, y + 1, 68, 14, this.textRenderer);
        this.textFieldFullColor.method_1880(12);
        this.addTextField(this.textFieldFullColor, new TextFieldListener(null, this));
        this.setColor(this.config.getIntegerValue());
    }

    protected int createComponentElements(int x, int y, int xLabel, Element element) {
        TextFieldListener listener = new TextFieldListener(element, this);
        GuiTextFieldInteger textField = new GuiTextFieldInteger(x, y, 32, 12, this.textRenderer);
        switch (element) {
            case H: {
                this.textFieldH = textField;
                break;
            }
            case S: {
                this.textFieldS = textField;
                break;
            }
            case V: {
                this.textFieldV = textField;
                break;
            }
            case R: {
                this.textFieldR = textField;
                break;
            }
            case G: {
                this.textFieldG = textField;
                break;
            }
            case B: {
                this.textFieldB = textField;
                break;
            }
        }
        this.addLabel(xLabel, y, 12, 12, 0xFFFFFF, element.name() + ":");
        this.addTextField(textField, listener);
        return this.heightSlider + this.gapSlider;
    }

    @Override
    public void method_25432() {
        this.config.setIntegerValue(this.color);
        super.method_25432();
    }

    @Override
    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.getParent() != null) {
            this.getParent().method_25394(matrixStack, mouseX, mouseY, partialTicks);
        }
        super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        if (this.mouseDown && this.clickedElement != null) {
            this.updateColorFromMouseInput(this.clickedElement, mouseX, mouseY);
        }
        this.drawColorSelector();
    }

    @Override
    protected void drawScreenBackground(int mouseX, int mouseY) {
        RenderUtils.drawOutlinedBox(this.dialogLeft, this.dialogTop, this.dialogWidth, this.dialogHeight, -16777216, -6710887);
    }

    @Override
    protected void drawTitle(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.drawStringWithShadow(matrixStack, this.title, this.dialogLeft + 10, this.dialogTop + 6, -1);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return this.onKeyTyped(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean onKeyTyped(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.dialogHandler != null) {
            this.dialogHandler.closeDialog();
            return true;
        }
        return super.onKeyTyped(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean onMouseClicked(int mouseX, int mouseY, int mouseButton) {
        this.clickedElement = this.getHoveredElement(mouseX, mouseY);
        if (this.clickedElement != null) {
            this.mouseDown = true;
            this.updateColorFromMouseInput(this.clickedElement, mouseX, mouseY);
        }
        return super.onMouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean onMouseReleased(int mouseX, int mouseY, int mouseButton) {
        this.mouseDown = false;
        this.clickedElement = null;
        return super.onMouseReleased(mouseX, mouseY, mouseButton);
    }

    protected float[] getCurrentColorHSV() {
        return this.getColorHSV(this.color);
    }

    protected float[] getColorHSV(int color) {
        int r = color >>> 16 & 0xFF;
        int g = color >>> 8 & 0xFF;
        int b = color & 0xFF;
        float[] hsv = new float[3];
        Color.RGBtoHSB(r, g, b, hsv);
        return hsv;
    }

    protected void setColor(int color) {
        this.color = color;
        this.setHSVFromRGB(color);
        this.setRGBFromHSV();
        this.currentTextInputElement = null;
    }

    protected void setHSVFromRGB() {
        this.setHSVFromRGB(this.relR, this.relG, this.relB);
    }

    protected void setHSVFromRGB(float r, float g, float b) {
        float[] hsv = new float[3];
        int ri = (int)(r * 255.0f);
        int gi = (int)(g * 255.0f);
        int bi = (int)(b * 255.0f);
        Color.RGBtoHSB(ri, gi, bi, hsv);
        this.relH = hsv[0];
        this.relS = hsv[1];
        this.relV = hsv[2];
        this.color = ri << 16 | gi << 8 | bi;
        this.updateTextFieldsHSV(this.relH, this.relS, this.relV);
    }

    protected void setHSVFromRGB(int rgb) {
        float[] hsv = this.getColorHSV(rgb);
        this.relH = hsv[0];
        this.relS = hsv[1];
        this.relV = hsv[2];
        this.updateTextFieldsHSV(this.relH, this.relS, this.relV);
    }

    protected void setRGBFromHSV() {
        this.setRGBFromHSV(this.relH, this.relS, this.relV);
    }

    protected void setRGBFromHSV(float h, float s, float v) {
        int rgb;
        this.color = rgb = Color.HSBtoRGB(h, s, v);
        this.relR = (float)(rgb >>> 16 & 0xFF) / 255.0f;
        this.relG = (float)(rgb >>> 8 & 0xFF) / 255.0f;
        this.relB = (float)(rgb & 0xFF) / 255.0f;
        this.updateTextFieldsRGB();
    }

    protected void updateColorFromMouseInput(Element element, int mouseX, int mouseY) {
        if (element == Element.SV) {
            mouseX = class_3532.method_15340((int)mouseX, (int)this.xHS, (int)(this.xHS + this.sizeHS));
            mouseY = class_3532.method_15340((int)mouseY, (int)this.yHS, (int)(this.yHS + this.sizeHS));
            int relX = mouseX - this.xHS;
            int relY = mouseY - this.yHS;
            float saturation = 1.0f - (float)relY / (float)this.sizeHS;
            float value = (float)relX / (float)this.sizeHS;
            this.relS = saturation;
            this.relV = value;
            this.setRGBFromHSV();
            this.updateTextField(Element.S);
            this.updateTextField(Element.V);
        } else if (element == Element.H_FULL_SV) {
            float hue;
            mouseY = class_3532.method_15340((int)mouseY, (int)this.yHS, (int)(this.yHS + this.sizeHS));
            int relY = mouseY - this.yHS;
            this.relH = hue = 1.0f - (float)relY / (float)this.sizeHS;
            this.setRGBFromHSV();
            this.updateTextField(Element.H);
        } else {
            mouseX = class_3532.method_15340((int)mouseX, (int)this.xH, (int)(this.xH + this.widthSlider));
            int relX = mouseX - this.xH;
            float relVal = (float)relX / (float)this.widthSlider;
            switch (element) {
                case H: {
                    this.relH = relVal;
                    this.setRGBFromHSV();
                    this.updateTextField(Element.H);
                    break;
                }
                case S: {
                    this.relS = relVal;
                    this.setRGBFromHSV();
                    this.updateTextField(Element.S);
                    break;
                }
                case V: {
                    this.relV = relVal;
                    this.setRGBFromHSV();
                    this.updateTextField(Element.V);
                    break;
                }
                case R: {
                    this.relR = relVal;
                    this.setHSVFromRGB();
                    this.updateTextField(Element.R);
                    break;
                }
                case G: {
                    this.relG = relVal;
                    this.setHSVFromRGB();
                    this.updateTextField(Element.G);
                    break;
                }
                case B: {
                    this.relB = relVal;
                    this.setHSVFromRGB();
                    this.updateTextField(Element.B);
                    break;
                }
            }
        }
    }

    protected void updateTextFieldsHSV(float h, float s, float v) {
        this.updateTextField(Element.HEX);
        this.updateTextField(Element.H);
        this.updateTextField(Element.S);
        this.updateTextField(Element.V);
    }

    protected void updateTextFieldsRGB() {
        this.updateTextField(Element.HEX);
        this.updateTextField(Element.R);
        this.updateTextField(Element.G);
        this.updateTextField(Element.B);
    }

    protected void updateTextField(Element type) {
        if (this.currentTextInputElement != type) {
            switch (type) {
                case HEX: {
                    this.textFieldFullColor.method_1852(String.format("#%08X", this.color));
                    break;
                }
                case H: {
                    this.textFieldH.method_1852(String.valueOf((int)(this.relH * 360.0f)));
                    break;
                }
                case S: {
                    this.textFieldS.method_1852(String.valueOf((int)(this.relS * 100.0f)));
                    break;
                }
                case V: {
                    this.textFieldV.method_1852(String.valueOf((int)(this.relV * 100.0f)));
                    break;
                }
                case R: {
                    this.textFieldR.method_1852(String.valueOf((int)(this.relR * 255.0f)));
                    break;
                }
                case G: {
                    this.textFieldG.method_1852(String.valueOf((int)(this.relG * 255.0f)));
                    break;
                }
                case B: {
                    this.textFieldB.method_1852(String.valueOf((int)(this.relB * 255.0f)));
                    break;
                }
            }
        }
    }

    protected void drawColorSelector() {
        int x = this.xH - 1;
        int y = this.yH - 1;
        int w = this.widthSlider + 2;
        int h = this.heightSlider + 2;
        int z = this.method_25305();
        int yd = this.heightSlider + this.gapSlider;
        int cx = this.xHS;
        int cy = this.yHS + this.sizeHS + 8;
        int cw = this.sizeHS;
        int ch = 16;
        RenderUtils.drawOutline(x, y, w, h, -1056964609, z);
        RenderUtils.drawOutline(x, y += yd, w, h, -1056964609, z);
        RenderUtils.drawOutline(x, y += yd, w, h, -1056964609, z);
        RenderUtils.drawOutline(x, y += yd, w, h, -1056964609, z);
        RenderUtils.drawOutline(x, y += yd, w, h, -1056964609, z);
        RenderUtils.drawOutline(x, y += yd, w, h, -1056964609, z);
        x = this.xHS;
        y = this.yHS;
        w = this.sizeHS;
        h = this.sizeHS;
        RenderUtils.drawOutline(x - 1, y - 1, w + 2, h + 2, -1056964609, z);
        RenderUtils.drawOutline(cx - 1, cy - 1, cw + 2, ch + 2, -1056964609, z);
        RenderUtils.drawOutline(this.xHFullSV, y - 1, this.widthHFullSV, this.sizeHS + 2, -1056964609, z);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        RenderSystem.disableTexture();
        RenderUtils.setupBlend();
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        class_285.method_22094((int)SHADER_HUE.getProgram());
        GL20.glUniform1f((int)GL20.glGetUniformLocation((int)SHADER_HUE.getProgram(), (CharSequence)"hue_value"), (float)this.relH);
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22912((double)x, (double)y, (double)z).method_22913(1.0f, 0.0f).method_1344();
        buffer.method_22912((double)x, (double)(y + h), (double)z).method_22913(0.0f, 0.0f).method_1344();
        buffer.method_22912((double)(x + w), (double)(y + h), (double)z).method_22913(0.0f, 1.0f).method_1344();
        buffer.method_22912((double)(x + w), (double)y, (double)z).method_22913(1.0f, 1.0f).method_1344();
        tessellator.method_1350();
        RenderSystem.setShader(class_757::method_34540);
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        float r = this.relR;
        float g = this.relG;
        float b = this.relB;
        buffer.method_22912((double)cx, (double)cy, (double)z).method_22915(r, g, b, 1.0f).method_1344();
        buffer.method_22912((double)cx, (double)(cy + ch), (double)z).method_22915(r, g, b, 1.0f).method_1344();
        buffer.method_22912((double)(cx + cw), (double)(cy + ch), (double)z).method_22915(r, g, b, 1.0f).method_1344();
        buffer.method_22912((double)(cx + cw), (double)cy, (double)z).method_22915(r, g, b, 1.0f).method_1344();
        int yt = y + (int)((1.0f - this.relS) * (float)h);
        int c = 255;
        buffer.method_22912((double)(x - 1), (double)yt, (double)z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912((double)(x - 1), (double)(yt + 1), (double)z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912((double)(x + w + 1), (double)(yt + 1), (double)z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912((double)(x + w + 1), (double)yt, (double)z).method_1336(c, c, c, c).method_1344();
        int xt = x + (int)(this.relV * (float)w);
        buffer.method_22912((double)xt, (double)(y - 1), (double)z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912((double)xt, (double)(y + h + 1), (double)z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912((double)(xt + 1), (double)(y + h + 1), (double)z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912((double)(xt + 1), (double)(y - 1), (double)z).method_1336(c, c, c, c).method_1344();
        x = this.xH;
        w = this.widthSlider;
        h = this.heightSlider;
        yd = this.heightSlider + this.gapSlider;
        GuiColorEditorHSV.renderHueBarVertical(this.xHFullSV + 1, this.yHS, z, this.widthHFullSV - 2, this.sizeHS, 1.0f, 1.0f, buffer);
        GuiColorEditorHSV.renderBarMarkerVerticalBar(this.xHFullSV, this.yHS, z, this.widthHFullSV, this.sizeHS, this.relH, buffer);
        GuiColorEditorHSV.renderHueBarHorizontal(x, y, z, w, h, this.relS, this.relV, buffer);
        GuiColorEditorHSV.renderBarMarkerHorizontalBar(x, y, z, w, h, this.relH, buffer);
        int color1 = Color.HSBtoRGB(this.relH, 0.0f, this.relV);
        int color2 = Color.HSBtoRGB(this.relH, 1.0f, this.relV);
        GuiColorEditorHSV.renderGradientColorBar(x, y += yd, z, w, h, color1, color2, buffer);
        GuiColorEditorHSV.renderBarMarkerHorizontalBar(x, y, z, w, h, this.relS, buffer);
        color1 = Color.HSBtoRGB(this.relH, this.relS, 0.0f);
        color2 = Color.HSBtoRGB(this.relH, this.relS, 1.0f);
        GuiColorEditorHSV.renderGradientColorBar(x, y += yd, z, w, h, color1, color2, buffer);
        GuiColorEditorHSV.renderBarMarkerHorizontalBar(x, y, z, w, h, this.relV, buffer);
        color1 = this.color & 0xFFFF;
        color2 = this.color | 0xFF0000;
        GuiColorEditorHSV.renderGradientColorBar(x, y += yd, z, w, h, color1, color2, buffer);
        GuiColorEditorHSV.renderBarMarkerHorizontalBar(x, y, z, w, h, r, buffer);
        color1 = this.color & 0xFF00FF;
        color2 = this.color | 0xFF00;
        GuiColorEditorHSV.renderGradientColorBar(x, y += yd, z, w, h, color1, color2, buffer);
        GuiColorEditorHSV.renderBarMarkerHorizontalBar(x, y, z, w, h, g, buffer);
        color1 = this.color & 0xFFFF00;
        color2 = this.color | 0xFF;
        GuiColorEditorHSV.renderGradientColorBar(x, y += yd, z, w, h, color1, color2, buffer);
        GuiColorEditorHSV.renderBarMarkerHorizontalBar(x, y, z, w, h, b, buffer);
        y += yd;
        tessellator.method_1350();
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
    }

    public static void renderGradientColorBar(int x, int y, float z, int width, int height, int colorStart, int colorEnd, class_287 buffer) {
        int r1 = colorStart >>> 16 & 0xFF;
        int g1 = colorStart >>> 8 & 0xFF;
        int b1 = colorStart & 0xFF;
        int r2 = colorEnd >>> 16 & 0xFF;
        int g2 = colorEnd >>> 8 & 0xFF;
        int b2 = colorEnd & 0xFF;
        int a = 255;
        buffer.method_22912((double)x, (double)y, (double)z).method_1336(r1, g1, b1, a).method_1344();
        buffer.method_22912((double)x, (double)(y + height), (double)z).method_1336(r1, g1, b1, a).method_1344();
        buffer.method_22912((double)(x + width), (double)(y + height), (double)z).method_1336(r2, g2, b2, a).method_1344();
        buffer.method_22912((double)(x + width), (double)y, (double)z).method_1336(r2, g2, b2, a).method_1344();
    }

    public static void renderHueBarHorizontal(int x, int y, float z, int width, int height, float saturation, float value, class_287 buffer) {
        GuiColorEditorHSV.renderHueBar(x, y, z, 0, height, width / 6, 0, saturation, value, buffer);
    }

    public static void renderHueBarVertical(int x, int y, float z, int width, int height, float saturation, float value, class_287 buffer) {
        y = y + height - height / 6;
        GuiColorEditorHSV.renderHueBar(x, y, z, width, 0, 0, height / 6, saturation, value, buffer);
    }

    public static void renderHueBar(int x, int y, float z, int width, int height, int segmentWidth, int segmentHeight, float saturation, float value, class_287 buffer) {
        int color1 = Color.HSBtoRGB(0.0f, saturation, value);
        int color2 = Color.HSBtoRGB(0.16666667f, saturation, value);
        GuiColorEditorHSV.renderHueBarSegment(x, y, z, width, height, segmentWidth, segmentHeight, color1, color2, buffer);
        color1 = Color.HSBtoRGB(0.16666667f, saturation, value);
        color2 = Color.HSBtoRGB(0.33333334f, saturation, value);
        GuiColorEditorHSV.renderHueBarSegment(x += segmentWidth, y -= segmentHeight, z, width, height, segmentWidth, segmentHeight, color1, color2, buffer);
        color1 = Color.HSBtoRGB(0.33333334f, saturation, value);
        color2 = Color.HSBtoRGB(0.5f, saturation, value);
        GuiColorEditorHSV.renderHueBarSegment(x += segmentWidth, y -= segmentHeight, z, width, height, segmentWidth, segmentHeight, color1, color2, buffer);
        color1 = Color.HSBtoRGB(0.5f, saturation, value);
        color2 = Color.HSBtoRGB(0.6666667f, saturation, value);
        GuiColorEditorHSV.renderHueBarSegment(x += segmentWidth, y -= segmentHeight, z, width, height, segmentWidth, segmentHeight, color1, color2, buffer);
        color1 = Color.HSBtoRGB(0.6666667f, saturation, value);
        color2 = Color.HSBtoRGB(0.8333333f, saturation, value);
        GuiColorEditorHSV.renderHueBarSegment(x += segmentWidth, y -= segmentHeight, z, width, height, segmentWidth, segmentHeight, color1, color2, buffer);
        color1 = Color.HSBtoRGB(0.8333333f, saturation, value);
        color2 = Color.HSBtoRGB(1.0f, saturation, value);
        GuiColorEditorHSV.renderHueBarSegment(x += segmentWidth, y -= segmentHeight, z, width, height, segmentWidth, segmentHeight, color1, color2, buffer);
    }

    public static void renderHueBarSegment(int x, int y, float z, int width, int height, int segmentWidth, int segmentHeight, int color1, int color2, class_287 buffer) {
        int r1 = color1 >>> 16 & 0xFF;
        int g1 = color1 >>> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >>> 16 & 0xFF;
        int g2 = color2 >>> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = 255;
        buffer.method_22912((double)x, (double)(y + segmentHeight), (double)z).method_1336(r1, g1, b1, a).method_1344();
        buffer.method_22912((double)(x + width), (double)(y + height + segmentHeight), (double)z).method_1336(r1, g1, b1, a).method_1344();
        buffer.method_22912((double)(x + width + segmentWidth), (double)(y + height), (double)z).method_1336(r2, g2, b2, a).method_1344();
        buffer.method_22912((double)(x + segmentWidth), (double)y, (double)z).method_1336(r2, g2, b2, a).method_1344();
    }

    public static void renderHSSelector(int xStart, int yStart, float z, int width, int height, float hue, class_287 buffer) {
        int x2 = xStart + width;
        for (int y = yStart; y <= yStart + height; ++y) {
            float saturation = 1.0f - (float)(y - yStart) / (float)height;
            int color1 = Color.HSBtoRGB(hue, saturation, 0.0f);
            int color2 = Color.HSBtoRGB(hue, saturation, 1.0f);
            int r1 = color1 >>> 16 & 0xFF;
            int g1 = color1 >>> 8 & 0xFF;
            int b1 = color1 & 0xFF;
            int r2 = color2 >>> 16 & 0xFF;
            int g2 = color2 >>> 8 & 0xFF;
            int b2 = color2 & 0xFF;
            int a = 255;
            buffer.method_22912((double)xStart, (double)y, (double)z).method_1336(r1, g1, b1, a).method_1344();
            buffer.method_22912((double)x2, (double)y, (double)z).method_1336(r2, g2, b2, a).method_1344();
        }
    }

    public static void renderBarMarkerHorizontalBar(int x, int y, float z, int barWidth, int barHeight, float value, class_287 buffer) {
        int s = 2;
        int c = 255;
        buffer.method_22912((double)((x += (int)((float)barWidth * value)) - s), (double)(y - s), (double)z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912((double)x, (double)(y + s), (double)z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912((double)x, (double)(y + s), (double)z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912((double)(x + s), (double)(y - s), (double)z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912((double)(x - s), (double)((y += barHeight) + s), (double)z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912((double)(x + s), (double)(y + s), (double)z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912((double)x, (double)(y - s), (double)z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912((double)x, (double)(y - s), (double)z).method_1336(c, c, c, c).method_1344();
    }

    public static void renderBarMarkerVerticalBar(int x, int y, float z, int barWidth, int barHeight, float value, class_287 buffer) {
        int s = 2;
        int c = 255;
        buffer.method_22912((double)(x - s), (double)((y += (int)((float)barHeight * (1.0f - value))) - s), (double)z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912((double)(x - s), (double)(y + s), (double)z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912((double)(x + s), (double)y, (double)z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912((double)(x + s), (double)y, (double)z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912((double)((x += barWidth) + s), (double)(y - s), (double)z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912((double)(x - s), (double)y, (double)z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912((double)(x - s), (double)y, (double)z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912((double)(x + s), (double)(y + s), (double)z).method_1336(c, c, c, c).method_1344();
    }

    @Nullable
    protected Element getHoveredElement(int mouseX, int mouseY) {
        if (mouseX >= this.xHS && mouseX <= this.xHS + this.sizeHS && mouseY >= this.yHS && mouseY <= this.yHS + this.sizeHS) {
            return Element.SV;
        }
        if (mouseX >= this.xHFullSV && mouseX <= this.xHFullSV + this.widthHFullSV && mouseY >= this.yHS && mouseY <= this.yHS + this.sizeHS) {
            return Element.H_FULL_SV;
        }
        if (mouseX >= this.xH && mouseX <= this.xH + this.widthSlider) {
            int relY;
            int index;
            int h = this.heightSlider + this.gapSlider;
            if (mouseY >= this.yH && mouseY <= this.yH + h * 6 - this.gapSlider && (index = (relY = mouseY - this.yH) / h) < 6 && relY % h < this.heightSlider) {
                return Element.values()[index];
            }
        }
        return null;
    }

    protected static enum Element {
        H,
        S,
        V,
        R,
        G,
        B,
        SV,
        H_FULL_SV,
        HEX;

    }

    protected static class TextFieldListener
    implements ITextFieldListener<GuiTextFieldGeneric> {
        protected final GuiColorEditorHSV gui;
        @Nullable
        protected final Element type;

        protected TextFieldListener(@Nullable Element type, GuiColorEditorHSV gui) {
            this.gui = gui;
            this.type = type;
        }

        @Override
        public boolean onTextChange(GuiTextFieldGeneric textField) {
            int colorOld = this.gui.color;
            if (this.type == null) {
                this.gui.currentTextInputElement = Element.HEX;
                this.gui.setColor(StringUtils.getColor(textField.method_1882(), colorOld));
            } else {
                try {
                    int val = Integer.parseInt(textField.method_1882());
                    float[] hsv = this.gui.getCurrentColorHSV();
                    int colorNew = colorOld;
                    switch (this.type) {
                        case H: {
                            val = class_3532.method_15340((int)val, (int)0, (int)360);
                            float h = (float)val / 360.0f;
                            colorNew = Color.HSBtoRGB(h, hsv[1], hsv[2]);
                            break;
                        }
                        case S: {
                            val = class_3532.method_15340((int)val, (int)0, (int)100);
                            float s = (float)val / 100.0f;
                            colorNew = Color.HSBtoRGB(hsv[0], s, hsv[2]);
                            break;
                        }
                        case V: {
                            val = class_3532.method_15340((int)val, (int)0, (int)100);
                            float v = (float)val / 100.0f;
                            colorNew = Color.HSBtoRGB(hsv[0], hsv[1], v);
                            break;
                        }
                        case R: {
                            val = class_3532.method_15340((int)val, (int)0, (int)255);
                            colorNew = colorOld & 0xFFFF | val << 16;
                            break;
                        }
                        case G: {
                            val = class_3532.method_15340((int)val, (int)0, (int)255);
                            colorNew = colorOld & 0xFF00FF | val << 8;
                            break;
                        }
                        case B: {
                            val = class_3532.method_15340((int)val, (int)0, (int)255);
                            colorNew = colorOld & 0xFFFF00 | val;
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                    if (colorNew != colorOld) {
                        this.gui.currentTextInputElement = this.type;
                        this.gui.setColor(colorNew);
                    }
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

