/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import com.google.common.collect.ArrayListMultimap;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.infohud.IInfoHudRenderer;
import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.scheduler.tasks.TaskBase;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.PasteNbtBehavior;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.ReplaceBehavior;
import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1809;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class TaskPasteSchematicSetblock
extends TaskBase
implements IInfoHudRenderer {
    private final ArrayListMultimap<class_1923, IntBoundingBox> boxesInChunks = ArrayListMultimap.create();
    private final List<IntBoundingBox> boxesInCurrentChunk = new ArrayList<IntBoundingBox>();
    private final List<class_1923> chunks = new ArrayList<class_1923>();
    private final PositionUtils.ChunkPosComparator comparator;
    private final int maxCommandsPerTick;
    private final boolean changedBlockOnly;
    private final ReplaceBehavior replace;
    private int sentCommandsThisTick;
    private int sentSetblockCommands;
    private int sentCommandsTotal;
    private int currentX;
    private int currentY;
    private int currentZ;
    private int currentIndex;
    private int boxVolume;
    private boolean boxInProgress;

    public TaskPasteSchematicSetblock(SchematicPlacement placement, boolean changedBlocksOnly) {
        this.changedBlockOnly = changedBlocksOnly;
        this.maxCommandsPerTick = Configs.Generic.PASTE_COMMAND_LIMIT.getIntegerValue();
        this.comparator = new PositionUtils.ChunkPosComparator();
        this.comparator.setClosestFirst(true);
        this.replace = (ReplaceBehavior)Configs.Generic.PASTE_REPLACE_BEHAVIOR.getOptionListValue();
        this.name = StringUtils.translate((String)"litematica.gui.label.task_name.paste", (Object[])new Object[0]);
        Set<class_1923> touchedChunks = placement.getTouchedChunks();
        for (class_1923 pos : touchedChunks) {
            this.boxesInChunks.putAll((Object)pos, (Iterable)placement.getBoxesWithinChunk(pos.field_9181, pos.field_9180).values());
            this.chunks.add(pos);
        }
        this.sortChunkList();
        InfoHud.getInstance().addInfoHudRenderer(this, true);
        this.updateInfoHudLines();
    }

    @Override
    public boolean canExecute() {
        return !this.boxesInChunks.isEmpty() && this.mc.field_1687 != null && this.mc.field_1724 != null;
    }

    @Override
    public boolean execute() {
        WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
        class_638 worldClient = this.mc.field_1687;
        this.sentCommandsThisTick = 0;
        int processed = 0;
        int chunkAttempts = 0;
        if (this.sentCommandsTotal == 0) {
            this.mc.field_1724.method_3142("/gamerule sendCommandFeedback false");
        }
        block0: while (!this.chunks.isEmpty()) {
            class_1923 pos = this.chunks.get(0);
            if (!this.canProcessChunk(pos, worldSchematic, worldClient)) {
                if (this.boxInProgress || chunkAttempts > 0) {
                    return false;
                }
                this.sortChunkList();
                ++chunkAttempts;
                continue;
            }
            while (!this.boxesInCurrentChunk.isEmpty()) {
                IntBoundingBox box = this.boxesInCurrentChunk.get(0);
                if (this.processBox(pos, box, worldSchematic, worldClient, this.mc.field_1724)) {
                    this.boxesInCurrentChunk.remove(0);
                    if (!this.boxesInCurrentChunk.isEmpty()) continue;
                    this.boxesInChunks.removeAll((Object)pos);
                    this.chunks.remove(0);
                    ++processed;
                    if (this.chunks.isEmpty()) {
                        this.finished = true;
                        return true;
                    }
                    this.sortChunkList();
                    continue block0;
                }
                if (processed > 0) {
                    this.updateInfoHudLines();
                }
                return false;
            }
        }
        if (processed > 0) {
            this.updateInfoHudLines();
        }
        return false;
    }

    private void sortChunkList() {
        if (this.chunks.size() > 0) {
            if (this.mc.field_1724 != null) {
                this.comparator.setReferencePosition(PositionUtils.getEntityBlockPos((class_1297)this.mc.field_1724));
                Collections.sort(this.chunks, this.comparator);
            }
            this.boxesInCurrentChunk.clear();
            this.boxesInCurrentChunk.addAll(this.boxesInChunks.get((Object)this.chunks.get(0)));
        }
    }

    protected boolean canProcessChunk(class_1923 pos, WorldSchematic worldSchematic, class_638 worldClient) {
        if (!worldSchematic.getChunkProvider().method_12123(pos.field_9181, pos.field_9180) || DataManager.getSchematicPlacementManager().hasPendingRebuildFor(pos)) {
            return false;
        }
        return this.areSurroundingChunksLoaded(pos, worldClient, 1);
    }

    protected boolean processBox(class_1923 pos, IntBoundingBox box, WorldSchematic worldSchematic, class_638 worldClient, class_746 player) {
        class_2338.class_2339 posMutable = new class_2338.class_2339();
        ChunkSchematic chunkSchematic = worldSchematic.getChunkProvider().getChunk(pos.field_9181, pos.field_9180);
        class_2818 chunkClient = worldClient.method_8497(pos.field_9181, pos.field_9180);
        PasteNbtBehavior nbtBehavior = (PasteNbtBehavior)Configs.Generic.PASTE_NBT_BEHAVIOR.getOptionListValue();
        if (!this.boxInProgress) {
            this.currentX = box.minX;
            this.currentY = box.minY;
            this.currentZ = box.minZ;
            this.boxVolume = (box.maxX - box.minX + 1) * (box.maxY - box.minY + 1) * (box.maxZ - box.minZ + 1);
            this.currentIndex = 0;
            this.boxInProgress = true;
        }
        while (this.currentIndex < this.boxVolume) {
            posMutable.method_10103(this.currentX, this.currentY, this.currentZ);
            if (++this.currentY > box.maxY) {
                this.currentY = box.minY;
                if (++this.currentX > box.maxX) {
                    this.currentX = box.minX;
                    ++this.currentZ;
                }
            }
            ++this.currentIndex;
            class_2680 stateSchematic = chunkSchematic.method_8320((class_2338)posMutable);
            class_2680 stateClient = chunkClient.method_8320((class_2338)posMutable);
            if (stateSchematic.method_26215() && stateClient.method_26215() || this.changedBlockOnly && stateClient == stateSchematic || this.replace == ReplaceBehavior.NONE && !stateClient.method_26215() || this.replace == ReplaceBehavior.WITH_NON_AIR && stateSchematic.method_26215()) continue;
            class_2586 be = worldSchematic.method_8321((class_2338)posMutable);
            if (be != null && nbtBehavior != PasteNbtBehavior.NONE) {
                if (nbtBehavior == PasteNbtBehavior.PLACE_MODIFY) {
                    this.setDataViaDataModify((class_2338)posMutable, stateSchematic, be, worldSchematic, worldClient, player);
                } else if (nbtBehavior == PasteNbtBehavior.PLACE_CLONE) {
                    this.placeBlockViaClone((class_2338)posMutable, stateSchematic, be, worldSchematic, worldClient, player);
                } else if (nbtBehavior == PasteNbtBehavior.TELEPORT_PLACE) {
                    this.placeBlockDirectly((class_2338)posMutable, stateSchematic, be, worldSchematic, worldClient, player);
                }
            } else {
                this.sendSetBlockCommand(posMutable.method_10263(), posMutable.method_10264(), posMutable.method_10260(), stateSchematic, player);
            }
            if (this.sentCommandsThisTick < this.maxCommandsPerTick) continue;
            break;
        }
        if (this.currentIndex >= this.boxVolume) {
            this.summonEntities(box, worldSchematic, player);
            this.boxInProgress = false;
            return true;
        }
        return false;
    }

    private void summonEntities(IntBoundingBox box, WorldSchematic worldSchematic, class_746 player) {
        class_238 bb = new class_238((double)box.minX, (double)box.minY, (double)box.minZ, (double)(box.maxX + 1), (double)(box.maxY + 1), (double)(box.maxZ + 1));
        List<class_1297> entities = worldSchematic.method_8333(null, bb, e -> true);
        for (class_1297 entity : entities) {
            String id = EntityUtils.getEntityId(entity);
            if (id == null) continue;
            String strCommand = String.format(Locale.ROOT, "/summon %s %f %f %f", id, entity.method_23317(), entity.method_23318(), entity.method_23321());
            player.method_3142(strCommand);
        }
    }

    private void sendSetBlockCommand(int x, int y, int z, class_2680 state, class_746 player) {
        String cmdName = Configs.Generic.PASTE_COMMAND_SETBLOCK.getStringValue();
        String blockString = class_2259.method_9685((class_2680)state);
        String strCommand = String.format("/%s %d %d %d %s", cmdName, x, y, z, blockString);
        this.sendCommand(strCommand, player);
        ++this.sentSetblockCommands;
    }

    private void setDataViaDataModify(class_2338 pos, class_2680 state, class_2586 be, class_1937 schematicWorld, class_638 clientWorld, class_746 player) {
        class_2338 placementPos = TaskPasteSchematicSetblock.findEmptyNearbyPosition((class_1937)clientWorld, player.method_24515(), 3);
        if (placementPos != null && this.preparePickedStack(pos, state, be, schematicWorld, player)) {
            class_243 posVec = new class_243((double)placementPos.method_10263() + 0.5, (double)placementPos.method_10264() + 1.0, (double)placementPos.method_10260() + 0.5);
            class_3965 hitResult = new class_3965(posVec, class_2350.field_11036, placementPos, false);
            this.mc.field_1761.method_2896(player, clientWorld, class_1268.field_5810, hitResult);
            HashSet keys = new HashSet();
            try {
                keys.addAll(be.method_11007(new class_2487()).method_10541());
            }
            catch (Exception exception) {
                // empty catch block
            }
            keys.remove("id");
            keys.remove("x");
            keys.remove("y");
            keys.remove("z");
            this.sendSetBlockCommand(pos.method_10263(), pos.method_10264(), pos.method_10260(), state, player);
            for (String key : keys) {
                String command = String.format("/data modify block %d %d %d %s set from block %d %d %d %s", pos.method_10263(), pos.method_10264(), pos.method_10260(), key, placementPos.method_10263(), placementPos.method_10264(), placementPos.method_10260(), key);
                this.sendCommand(command, player);
            }
            String command = String.format("/setblock %d %d %d air", placementPos.method_10263(), placementPos.method_10264(), placementPos.method_10260());
            this.sendCommand(command, player);
        }
    }

    private void placeBlockViaClone(class_2338 pos, class_2680 state, class_2586 be, class_1937 schematicWorld, class_638 clientWorld, class_746 player) {
        class_2338 placementPos = TaskPasteSchematicSetblock.findEmptyNearbyPosition((class_1937)clientWorld, player.method_24515(), 3);
        if (placementPos != null && this.preparePickedStack(pos, state, be, schematicWorld, player)) {
            class_243 posVec = new class_243((double)placementPos.method_10263() + 0.5, (double)placementPos.method_10264() + 1.0, (double)placementPos.method_10260() + 0.5);
            class_3965 hitResult = new class_3965(posVec, class_2350.field_11036, placementPos, false);
            this.mc.field_1761.method_2896(player, clientWorld, class_1268.field_5810, hitResult);
            String command = String.format("/data get block %d %d %d", placementPos.method_10263(), placementPos.method_10264(), placementPos.method_10260());
            this.sendCommand(command, player);
            command = String.format("/clone %d %d %d %d %d %d %d %d %d", placementPos.method_10263(), placementPos.method_10264(), placementPos.method_10260(), placementPos.method_10263(), placementPos.method_10264(), placementPos.method_10260(), pos.method_10263(), pos.method_10264(), pos.method_10260());
            this.sendCommand(command, player);
            command = String.format("/setblock %d %d %d air", placementPos.method_10263(), placementPos.method_10264(), placementPos.method_10260());
            this.sendCommand(command, player);
        }
    }

    private void placeBlockDirectly(class_2338 pos, class_2680 state, class_2586 be, class_1937 schematicWorld, class_638 clientWorld, class_746 player) {
        if (this.preparePickedStack(pos, state, be, schematicWorld, player)) {
            player.method_23327((double)pos.method_10263(), (double)(pos.method_10264() + 2), (double)pos.method_10260());
            String command = String.format("/tp @p %d %d %d", pos.method_10263(), pos.method_10264() + 2, pos.method_10260());
            this.sendCommand(command, player);
            class_243 posVec = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5);
            class_3965 hitResult = new class_3965(posVec, class_2350.field_11036, pos, false);
            this.mc.field_1761.method_2896(player, clientWorld, class_1268.field_5810, hitResult);
        }
    }

    private void sendCommand(String command, class_746 player) {
        player.method_3142(command);
        ++this.sentCommandsThisTick;
        ++this.sentCommandsTotal;
    }

    @Nullable
    public static class_2338 findEmptyNearbyPosition(class_1937 world, class_2338 centerPos, int radius) {
        class_2338.class_2339 pos = new class_2338.class_2339();
        class_2338.class_2339 sidePos = new class_2338.class_2339();
        for (int y = centerPos.method_10264(); y <= centerPos.method_10264() + radius; ++y) {
            for (int z = centerPos.method_10260() - radius; z <= centerPos.method_10260() + radius; ++z) {
                for (int x = centerPos.method_10263() - radius; x <= centerPos.method_10263() + radius; ++x) {
                    pos.method_10103(x, y, z);
                    if (!TaskPasteSchematicSetblock.isPositionAndSidesEmpty(world, pos, sidePos)) continue;
                    return pos;
                }
            }
        }
        return null;
    }

    public static boolean isPositionAndSidesEmpty(class_1937 world, class_2338.class_2339 centerPos, class_2338.class_2339 pos) {
        if (!world.method_22347((class_2338)centerPos)) {
            return false;
        }
        for (class_2350 side : PositionUtils.ALL_DIRECTIONS) {
            if (world.method_22347((class_2338)pos.method_25505((class_2382)centerPos, side))) continue;
            return false;
        }
        return true;
    }

    private boolean preparePickedStack(class_2338 pos, class_2680 state, class_2586 be, class_1937 world, class_746 player) {
        class_1799 stack = state.method_26204().method_9574((class_1922)world, pos, state);
        if (!stack.method_7960()) {
            TaskPasteSchematicSetblock.addBlockEntityNbt(stack, be);
            player.method_31548().field_7544.set(0, (Object)stack);
            this.mc.field_1761.method_2909(stack, 45);
            return true;
        }
        return false;
    }

    public static void addBlockEntityNbt(class_1799 stack, class_2586 be) {
        class_2487 tag = be.method_11007(new class_2487());
        if (stack.method_7909() instanceof class_1809 && tag.method_10545("SkullOwner")) {
            class_2487 ownerTag = tag.method_10562("SkullOwner");
            stack.method_7948().method_10566("SkullOwner", (class_2520)ownerTag);
        } else {
            stack.method_7959("BlockEntityTag", (class_2520)tag);
        }
    }

    @Override
    public void stop() {
        if (this.finished) {
            InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"litematica.message.schematic_pasted_using_setblock", (Object[])new Object[]{this.sentSetblockCommands});
        } else {
            InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.schematic_paste_failed", (Object[])new Object[0]);
        }
        if (this.mc.field_1724 != null) {
            this.mc.field_1724.method_3142("/gamerule sendCommandFeedback true");
        }
        InfoHud.getInstance().removeInfoHudRenderer(this, false);
        super.stop();
    }

    private void updateInfoHudLines() {
        ArrayList<String> hudLines = new ArrayList<String>();
        String pre = GuiBase.TXT_WHITE + GuiBase.TXT_BOLD;
        String title = StringUtils.translate((String)"litematica.gui.label.schematic_paste.missing_chunks", (Object[])new Object[]{this.chunks.size()});
        hudLines.add(String.format("%s%s%s", pre, title, GuiBase.TXT_RST));
        int maxLines = Math.min(this.chunks.size(), Configs.InfoOverlays.INFO_HUD_MAX_LINES.getIntegerValue());
        for (int i = 0; i < maxLines; ++i) {
            class_1923 pos = this.chunks.get(i);
            hudLines.add(String.format("cx: %5d, cz: %5d (x: %d, z: %d)", pos.field_9181, pos.field_9180, pos.field_9181 << 4, pos.field_9180 << 4));
        }
        this.infoHudLines = hudLines;
    }
}

