/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.scheduler.tasks.TaskProcessChunkBase;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class TaskFillArea
extends TaskProcessChunkBase {
    protected final class_2680 fillState;
    @Nullable
    protected final class_2680 replaceState;
    protected final String blockString;
    protected final boolean removeEntities;
    protected int chunkCount;

    public TaskFillArea(List<Box> boxes, class_2680 fillState, @Nullable class_2680 replaceState, boolean removeEntities) {
        this(boxes, fillState, replaceState, removeEntities, "litematica.gui.label.task_name.fill");
    }

    protected TaskFillArea(List<Box> boxes, class_2680 fillState, @Nullable class_2680 replaceState, boolean removeEntities, String nameOnHud) {
        super(nameOnHud);
        this.fillState = fillState;
        this.replaceState = replaceState;
        this.removeEntities = removeEntities;
        Object blockString = class_2259.method_9685((class_2680)fillState);
        if (replaceState != null) {
            blockString = (String)blockString + " replace " + class_2259.method_9685((class_2680)replaceState);
        }
        this.blockString = blockString;
        this.addBoxesPerChunks(boxes);
        this.updateInfoHudLinesMissingChunks(this.requiredChunks);
    }

    @Override
    public boolean canExecute() {
        return super.canExecute() && this.blockString != null;
    }

    @Override
    protected boolean canProcessChunk(class_1923 pos) {
        return this.mc.field_1724 != null && this.areSurroundingChunksLoaded(pos, this.clientWorld, 1);
    }

    @Override
    protected boolean processChunk(class_1923 pos) {
        for (IntBoundingBox box : this.getBoxesInChunk(pos)) {
            if (this.isClientWorld) {
                this.fillBoxCommands(box, this.removeEntities);
                continue;
            }
            this.fillBoxDirect(box, this.removeEntities);
        }
        ++this.chunkCount;
        return true;
    }

    protected void fillBoxDirect(IntBoundingBox box, boolean removeEntities) {
        if (removeEntities) {
            class_238 aabb = new class_238((double)box.minX, (double)box.minY, (double)box.minZ, (double)(box.maxX + 1), (double)(box.maxY + 1), (double)(box.maxZ + 1));
            List entities = this.world.method_8333((class_1297)this.mc.field_1724, aabb, EntityUtils.NOT_PLAYER);
            for (class_1297 entity : entities) {
                if (entity instanceof class_1657) continue;
                entity.method_31472();
            }
        }
        WorldUtils.setShouldPreventBlockUpdates(this.world, true);
        class_2680 barrier = class_2246.field_10499.method_9564();
        class_2338.class_2339 posMutable = new class_2338.class_2339();
        for (int z = box.minZ; z <= box.maxZ; ++z) {
            for (int x = box.minX; x <= box.maxX; ++x) {
                for (int y = box.maxY; y >= box.minY; --y) {
                    posMutable.method_10103(x, y, z);
                    class_2680 oldState = this.world.method_8320((class_2338)posMutable);
                    if ((this.replaceState != null || oldState == this.fillState) && oldState != this.replaceState) continue;
                    class_2586 te = this.world.method_8321((class_2338)posMutable);
                    if (te instanceof class_1263) {
                        ((class_1263)te).method_5448();
                        this.world.method_8652((class_2338)posMutable, barrier, 18);
                    }
                    this.world.method_8652((class_2338)posMutable, this.fillState, 18);
                }
            }
        }
        WorldUtils.setShouldPreventBlockUpdates(this.world, false);
    }

    protected void fillBoxCommands(IntBoundingBox box, boolean removeEntities) {
        class_238 aabb;
        if (removeEntities && this.world.method_8333((class_1297)this.mc.field_1724, aabb = new class_238((double)box.minX, (double)box.minY, (double)box.minZ, (double)(box.maxX + 1), (double)(box.maxY + 1), (double)(box.maxZ + 1)), EntityUtils.NOT_PLAYER).size() > 0) {
            String killCmd = String.format("/kill @e[type=!player,x=%d,y=%d,z=%d,dx=%d,dy=%d,dz=%d]", box.minX, box.minY, box.minZ, box.maxX - box.minX + 1, box.maxY - box.minY + 1, box.maxZ - box.minZ + 1);
            this.mc.field_1724.method_3142(killCmd);
        }
        String fillCmd = String.format("/fill %d %d %d %d %d %d %s", box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ, this.blockString);
        this.mc.field_1724.method_3142(fillCmd);
    }

    @Override
    protected void onStop() {
        InfoHud.getInstance().removeInfoHudRenderer(this, false);
        this.printCompletionMessage();
        this.notifyListener();
    }

    protected void printCompletionMessage() {
        if (this.finished) {
            if (this.printCompletionMessage) {
                InfoUtils.showGuiMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"litematica.message.area_filled", (Object[])new Object[0]);
            }
        } else {
            InfoUtils.showGuiMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.area_fill_fail", (Object[])new Object[0]);
        }
    }
}

