/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.world;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.litematica.render.LitematicaRenderer;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.world.ChunkManagerSchematic;
import fi.dy.masa.litematica.world.ChunkSchematic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_22;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_269;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3695;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5415;
import net.minecraft.class_5455;
import net.minecraft.class_5458;
import net.minecraft.class_5575;
import net.minecraft.class_5577;
import net.minecraft.class_5712;
import net.minecraft.class_6754;
import net.minecraft.class_6756;
import org.jetbrains.annotations.Nullable;

public class WorldSchematic
extends class_1937 {
    private static final class_5321<class_1937> REGISTRY_KEY = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960("litematica", "schematic_world"));
    private final class_310 mc = class_310.method_1551();
    private final WorldRendererSchematic worldRenderer = LitematicaRenderer.getInstance().getWorldRenderer();
    private final ChunkManagerSchematic chunkManagerSchematic = new ChunkManagerSchematic(this);
    private final class_1959 biome = (class_1959)class_5458.field_25933.method_29107(class_1972.field_9451);
    private int nextEntityId;
    private int entityCount;

    protected WorldSchematic(class_5269 mutableWorldProperties, class_2874 dimensionType, Supplier<class_3695> supplier) {
        super(mutableWorldProperties, REGISTRY_KEY, dimensionType, supplier, true, true, 0L);
    }

    public ChunkManagerSchematic getChunkProvider() {
        return this.chunkManagerSchematic;
    }

    public ChunkManagerSchematic getChunkManager() {
        return this.chunkManagerSchematic;
    }

    public class_6756<class_2248> method_8397() {
        return class_6754.method_39362();
    }

    public class_6756<class_3611> method_8405() {
        return class_6754.method_39362();
    }

    public int getRegularEntityCount() {
        return this.entityCount;
    }

    public class_2818 method_8500(class_2338 pos) {
        return this.getChunk(pos.method_10263() >> 4, pos.method_10260() >> 4);
    }

    public ChunkSchematic getChunk(int chunkX, int chunkZ) {
        return this.chunkManagerSchematic.getChunk(chunkX, chunkZ);
    }

    public class_2791 method_8402(int chunkX, int chunkZ, class_2806 status, boolean required) {
        return this.getChunk(chunkX, chunkZ);
    }

    public class_1959 method_22387(int biomeX, int biomeY, int biomeZ) {
        return this.biome;
    }

    public boolean method_8652(class_2338 pos, class_2680 newState, int flags) {
        if (pos.method_10264() < this.method_31607() || pos.method_10264() >= this.method_31600()) {
            return false;
        }
        return this.getChunk(pos.method_10263() >> 4, pos.method_10260() >> 4).method_12010(pos, newState, false) != null;
    }

    public boolean method_8649(class_1297 entity) {
        int chunkZ;
        int chunkX = class_3532.method_15357((double)(entity.method_23317() / 16.0));
        if (!this.chunkManagerSchematic.method_12123(chunkX, chunkZ = class_3532.method_15357((double)(entity.method_23321() / 16.0)))) {
            return false;
        }
        entity.method_5838(this.nextEntityId++);
        this.chunkManagerSchematic.getChunk(chunkX, chunkZ).method_12002(entity);
        ++this.entityCount;
        return true;
    }

    public void unloadedEntities(int count) {
        this.entityCount -= count;
    }

    @javax.annotation.Nullable
    public class_1297 method_8469(int id) {
        return null;
    }

    public List<? extends class_1657> method_18456() {
        return ImmutableList.of();
    }

    public long method_8510() {
        return this.mc.field_1687 != null ? this.mc.field_1687.method_8510() : 0L;
    }

    @javax.annotation.Nullable
    public class_22 method_17891(String id) {
        return null;
    }

    public void method_17890(String name, class_22 mapState) {
    }

    public int method_17889() {
        return 0;
    }

    public class_269 method_8428() {
        return this.mc.field_1687 != null ? this.mc.field_1687.method_8428() : null;
    }

    public class_1863 method_8433() {
        return this.mc.field_1687 != null ? this.mc.field_1687.method_8433() : null;
    }

    public class_5415 method_8514() {
        return this.mc.field_1687 != null ? this.mc.field_1687.method_8514() : null;
    }

    protected class_5577<class_1297> method_31592() {
        return null;
    }

    public List<class_1297> method_8333(@javax.annotation.Nullable class_1297 except, class_238 box, Predicate<? super class_1297> predicate) {
        int minY = class_3532.method_15357((double)(box.field_1322 / 16.0));
        int maxY = class_3532.method_15357((double)(box.field_1325 / 16.0));
        ArrayList<class_1297> entities = new ArrayList<class_1297>();
        List<ChunkSchematic> chunks = this.getChunksWithinBox(box);
        for (ChunkSchematic chunk : chunks) {
            for (int cy = minY; cy <= maxY; ++cy) {
                chunk.getEntityListForSectionIfExists(cy).forEach(e -> {
                    if (e != except && box.method_994(e.method_5829()) && predicate.test((class_1297)e)) {
                        entities.add((class_1297)e);
                    }
                });
            }
        }
        return entities;
    }

    public <T extends class_1297> List<T> method_18023(class_5575<class_1297, T> arg, class_238 box, Predicate<? super T> predicate) {
        return Collections.emptyList();
    }

    public List<ChunkSchematic> getChunksWithinBox(class_238 box) {
        int minX = class_3532.method_15357((double)(box.field_1323 / 16.0));
        int minZ = class_3532.method_15357((double)(box.field_1321 / 16.0));
        int maxX = class_3532.method_15357((double)(box.field_1320 / 16.0));
        int maxZ = class_3532.method_15357((double)(box.field_1324 / 16.0));
        ArrayList<ChunkSchematic> chunks = new ArrayList<ChunkSchematic>();
        for (int cx = minX; cx <= maxX; ++cx) {
            for (int cz = minZ; cz <= maxZ; ++cz) {
                ChunkSchematic chunk = this.chunkManagerSchematic.getChunkIfExists(cx, cz);
                if (chunk == null) continue;
                chunks.add(chunk);
            }
        }
        return chunks;
    }

    public void method_16109(class_2338 pos, class_2680 stateOld, class_2680 stateNew) {
        this.scheduleBlockRenders(pos.method_10263() >> 4, pos.method_10264() >> 4, pos.method_10260() >> 4);
    }

    public void scheduleBlockRenders(int chunkX, int chunkY, int chunkZ) {
        this.worldRenderer.scheduleChunkRenders(chunkX, chunkY, chunkZ);
    }

    public void scheduleChunkRenders(int chunkX, int chunkZ) {
        int startChunkY = this.method_32891();
        int endChunkY = this.method_31597() - 1;
        for (int chunkY = startChunkY; chunkY <= endChunkY; ++chunkY) {
            this.worldRenderer.scheduleChunkRenders(chunkX, chunkY, chunkZ);
        }
    }

    public void scheduleChunkRenders(int minBlockX, int minBlockY, int minBlockZ, int maxBlockX, int maxBlockY, int maxBlockZ) {
        minBlockY = Math.max(minBlockY, this.method_31607());
        maxBlockY = Math.min(maxBlockY, this.method_31600() - 1);
        int minChunkX = Math.min(minBlockX, maxBlockX) >> 4;
        int minChunkY = Math.min(minBlockY, maxBlockY) >> 4;
        int minChunkZ = Math.min(minBlockZ, maxBlockZ) >> 4;
        int maxChunkX = Math.max(minBlockX, maxBlockX) >> 4;
        int maxChunkY = Math.max(minBlockY, maxBlockY) >> 4;
        int maxChunkZ = Math.max(minBlockZ, maxBlockZ) >> 4;
        for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
            for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
                for (int cy = minChunkY; cy <= maxChunkY; ++cy) {
                    this.worldRenderer.scheduleChunkRenders(cx, cy, cz);
                }
            }
        }
    }

    public int method_31607() {
        return this.mc.field_1687 != null ? this.mc.field_1687.method_31607() : -64;
    }

    public int method_31605() {
        return this.mc.field_1687 != null ? this.mc.field_1687.method_31605() : 384;
    }

    public int method_31600() {
        return this.method_31607() + this.method_31605();
    }

    public int method_32891() {
        return this.method_31607() >> 4;
    }

    public int method_31597() {
        return this.method_31600() >> 4;
    }

    public int method_32890() {
        return this.method_31597() - this.method_32891();
    }

    public boolean method_31606(class_2338 pos) {
        return this.method_31601(pos.method_10264());
    }

    public boolean method_31601(int y) {
        return y < this.method_31607() || y >= this.method_31600();
    }

    public int method_31602(int y) {
        return (y >> 4) - (this.method_31607() >> 4);
    }

    public int method_31603(int coord) {
        return coord - (this.method_31607() >> 4);
    }

    public int method_31604(int index) {
        return index + (this.method_31607() >> 4);
    }

    public float method_24852(class_2350 direction, boolean shaded) {
        return 0.0f;
    }

    public int method_8314(class_1944 type, class_2338 pos) {
        return 15;
    }

    public int method_22335(class_2338 pos, int defaultValue) {
        return 15;
    }

    public void method_8413(class_2338 blockPos_1, class_2680 blockState_1, class_2680 blockState_2, int flags) {
    }

    public void method_8517(int entityId, class_2338 pos, int progress) {
    }

    public void method_8474(int eventId, class_2338 pos, int data) {
    }

    public void method_8444(@javax.annotation.Nullable class_1657 entity, int id, class_2338 pos, int data) {
    }

    public void method_32888(@Nullable class_1297 entity, class_5712 event, class_2338 pos) {
    }

    public void method_8406(class_2394 particleParameters_1, double double_1, double double_2, double double_3, double double_4, double double_5, double double_6) {
    }

    public void method_8466(class_2394 particleParameters_1, boolean boolean_1, double double_1, double double_2, double double_3, double double_4, double double_5, double double_6) {
    }

    public void method_8494(class_2394 particleParameters_1, double double_1, double double_2, double double_3, double double_4, double double_5, double double_6) {
    }

    public void method_17452(class_2394 particleParameters_1, boolean boolean_1, double double_1, double double_2, double double_3, double double_4, double double_5, double double_6) {
    }

    public void method_8486(double x, double y, double z, class_3414 soundIn, class_3419 category, float volume, float pitch, boolean distanceDelay) {
    }

    public void method_8396(class_1657 player, class_2338 pos, class_3414 soundIn, class_3419 category, float volume, float pitch) {
    }

    public void method_8465(class_1657 player, double x, double y, double z, class_3414 soundIn, class_3419 category, float volume, float pitch) {
    }

    public void method_8449(@javax.annotation.Nullable class_1657 player, class_1297 entity, class_3414 sound, class_3419 category, float volume, float pitch) {
    }

    public class_5455 method_30349() {
        return this.mc.field_1687.method_30349();
    }

    public String method_31419() {
        return "Chunks[SCH] W: " + this.getChunkManager().method_12122() + " E: " + this.getRegularEntityCount();
    }
}

