/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.schematic.BlockModelRendererSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDataSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDispatcherLitematica;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDispatcherSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRendererSchematicVbo;
import fi.dy.masa.litematica.render.schematic.IChunkRendererFactory;
import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.SubChunkPos;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_148;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_284;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_291;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_5539;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import net.minecraft.class_776;
import net.minecraft.class_824;
import net.minecraft.class_898;

public class WorldRendererSchematic {
    private final class_310 mc;
    private final class_898 entityRenderDispatcher;
    private final class_776 blockRenderManager;
    private final BlockModelRendererSchematic blockModelRenderer;
    private final Set<class_2586> blockEntities = new HashSet<class_2586>();
    private final List<ChunkRendererSchematicVbo> renderInfos = new ArrayList<ChunkRendererSchematicVbo>(1024);
    private final class_4599 bufferBuilders;
    private Set<ChunkRendererSchematicVbo> chunksToUpdate = new LinkedHashSet<ChunkRendererSchematicVbo>();
    private WorldSchematic world;
    private ChunkRenderDispatcherSchematic chunkRendererDispatcher;
    private double lastCameraChunkUpdateX = Double.MIN_VALUE;
    private double lastCameraChunkUpdateY = Double.MIN_VALUE;
    private double lastCameraChunkUpdateZ = Double.MIN_VALUE;
    private int cameraChunkX = Integer.MIN_VALUE;
    private int cameraChunkY = Integer.MIN_VALUE;
    private int cameraChunkZ = Integer.MIN_VALUE;
    private double lastCameraX = Double.MIN_VALUE;
    private double lastCameraY = Double.MIN_VALUE;
    private double lastCameraZ = Double.MIN_VALUE;
    private float lastCameraPitch = Float.MIN_VALUE;
    private float lastCameraYaw = Float.MIN_VALUE;
    private ChunkRenderDispatcherLitematica renderDispatcher;
    private final IChunkRendererFactory renderChunkFactory;
    private int renderDistanceChunks = -1;
    private int renderEntitiesStartupCounter = 2;
    private int countEntitiesTotal;
    private int countEntitiesRendered;
    private int countEntitiesHidden;
    private double lastTranslucentSortX;
    private double lastTranslucentSortY;
    private double lastTranslucentSortZ;
    private boolean displayListEntitiesDirty = true;

    public WorldRendererSchematic(class_310 mc) {
        this.mc = mc;
        this.entityRenderDispatcher = mc.method_1561();
        this.bufferBuilders = mc.method_22940();
        this.renderChunkFactory = ChunkRendererSchematicVbo::new;
        this.blockRenderManager = class_310.method_1551().method_1541();
        this.blockModelRenderer = new BlockModelRendererSchematic(mc.method_1505());
    }

    public void markNeedsUpdate() {
        this.displayListEntitiesDirty = true;
    }

    public boolean hasWorld() {
        return this.world != null;
    }

    public String getDebugInfoRenders() {
        int rcTotal = this.chunkRendererDispatcher != null ? this.chunkRendererDispatcher.renderers.length : 0;
        int rcRendered = this.chunkRendererDispatcher != null ? this.getRenderedChunks() : 0;
        return String.format("C: %d/%d %sD: %d, L: %d, %s", rcRendered, rcTotal, this.mc.field_1730 ? "(s) " : "", this.renderDistanceChunks, 0, this.renderDispatcher == null ? "null" : this.renderDispatcher.getDebugInfo());
    }

    public String getDebugInfoEntities() {
        return "E: " + this.countEntitiesRendered + "/" + this.countEntitiesTotal + ", B: " + this.countEntitiesHidden;
    }

    protected int getRenderedChunks() {
        int count = 0;
        for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
            ChunkRenderDataSchematic data = chunkRenderer.chunkRenderData;
            if (data == ChunkRenderDataSchematic.EMPTY || data.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public void setWorldAndLoadRenderers(@Nullable WorldSchematic worldSchematic) {
        this.lastCameraChunkUpdateX = Double.MIN_VALUE;
        this.lastCameraChunkUpdateY = Double.MIN_VALUE;
        this.lastCameraChunkUpdateZ = Double.MIN_VALUE;
        this.cameraChunkX = Integer.MIN_VALUE;
        this.cameraChunkY = Integer.MIN_VALUE;
        this.cameraChunkZ = Integer.MIN_VALUE;
        this.world = worldSchematic;
        if (worldSchematic != null) {
            this.loadRenderers();
        } else {
            this.chunksToUpdate.clear();
            this.renderInfos.clear();
            if (this.chunkRendererDispatcher != null) {
                this.chunkRendererDispatcher.delete();
                this.chunkRendererDispatcher = null;
            }
            if (this.renderDispatcher != null) {
                this.renderDispatcher.stopWorkerThreads();
            }
            this.renderDispatcher = null;
            this.blockEntities.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRenderers() {
        if (this.hasWorld()) {
            if (this.renderDispatcher == null) {
                this.renderDispatcher = new ChunkRenderDispatcherLitematica();
            }
            this.displayListEntitiesDirty = true;
            this.renderDistanceChunks = this.mc.field_1690.field_1870;
            if (this.chunkRendererDispatcher != null) {
                this.chunkRendererDispatcher.delete();
            }
            this.stopChunkUpdates();
            Set<class_2586> set = this.blockEntities;
            synchronized (set) {
                this.blockEntities.clear();
            }
            this.chunkRendererDispatcher = new ChunkRenderDispatcherSchematic(this.world, this.renderDistanceChunks, this, this.renderChunkFactory);
            class_1297 entity = this.mc.method_1560();
            if (entity != null) {
                this.chunkRendererDispatcher.updateCameraPosition(entity.method_23317(), entity.method_23321());
            }
            this.renderEntitiesStartupCounter = 2;
        }
    }

    protected void stopChunkUpdates() {
        this.chunksToUpdate.clear();
        this.renderDispatcher.stopChunkUpdates();
    }

    public void setupTerrain(class_4184 camera, class_4604 frustum, int frameCount, boolean playerSpectator) {
        class_1297 entity;
        this.world.method_16107().method_15396("setup_terrain");
        if (this.chunkRendererDispatcher == null || this.mc.field_1690.field_1870 != this.renderDistanceChunks) {
            this.loadRenderers();
        }
        if ((entity = this.mc.method_1560()) == null) {
            entity = this.mc.field_1724;
        }
        this.world.method_16107().method_15396("camera");
        double entityX = entity.method_23317();
        double entityY = entity.method_23318();
        double entityZ = entity.method_23321();
        int chunkX = class_4076.method_32204((double)entityX);
        int chunkY = class_4076.method_32204((double)entityY);
        int chunkZ = class_4076.method_32204((double)entityZ);
        double diffX = entityX - this.lastCameraChunkUpdateX;
        double diffY = entityY - this.lastCameraChunkUpdateY;
        double diffZ = entityZ - this.lastCameraChunkUpdateZ;
        if (this.cameraChunkX != chunkX || this.cameraChunkY != chunkY || this.cameraChunkZ != chunkZ || diffX * diffX + diffY * diffY + diffZ * diffZ > 16.0) {
            this.lastCameraChunkUpdateX = entityX;
            this.lastCameraChunkUpdateY = entityY;
            this.lastCameraChunkUpdateZ = entityZ;
            this.cameraChunkX = chunkX;
            this.cameraChunkY = chunkY;
            this.cameraChunkZ = chunkZ;
            this.chunkRendererDispatcher.updateCameraPosition(entityX, entityZ);
        }
        this.world.method_16107().method_15405("renderlist_camera");
        class_243 cameraPos = camera.method_19326();
        double cameraX = cameraPos.field_1352;
        double cameraY = cameraPos.field_1351;
        double cameraZ = cameraPos.field_1350;
        this.renderDispatcher.setCameraPosition(cameraPos);
        this.world.method_16107().method_15405("culling");
        class_2338 viewPos = new class_2338(cameraX, cameraY + (double)entity.method_5751(), cameraZ);
        int centerChunkX = viewPos.method_10263() >> 4;
        int centerChunkZ = viewPos.method_10260() >> 4;
        int renderDistance = this.mc.field_1690.field_1870;
        SubChunkPos viewSubChunk = new SubChunkPos(centerChunkX, viewPos.method_10264() >> 4, centerChunkZ);
        class_2338 viewPosSubChunk = new class_2338(viewSubChunk.method_10263() << 4, viewSubChunk.method_10264() << 4, viewSubChunk.method_10260() << 4);
        this.displayListEntitiesDirty = this.displayListEntitiesDirty || !this.chunksToUpdate.isEmpty() || entityX != this.lastCameraX || entityY != this.lastCameraY || entityZ != this.lastCameraZ || entity.method_36455() != this.lastCameraPitch || entity.method_36454() != this.lastCameraYaw;
        this.lastCameraX = cameraX;
        this.lastCameraY = cameraY;
        this.lastCameraZ = cameraZ;
        this.lastCameraPitch = camera.method_19329();
        this.lastCameraYaw = camera.method_19330();
        this.world.method_16107().method_15405("update");
        if (this.displayListEntitiesDirty) {
            this.world.method_16107().method_15396("fetch");
            this.displayListEntitiesDirty = false;
            this.renderInfos.clear();
            this.world.method_16107().method_15405("sort");
            List<SubChunkPos> positions = DataManager.getSchematicPlacementManager().getAndUpdateVisibleSubChunks(viewSubChunk);
            this.world.method_16107().method_15405("iteration");
            class_2338.class_2339 subChunkCornerPos = new class_2338.class_2339();
            for (SubChunkPos subChunk : positions) {
                if (Math.abs(subChunk.method_10263() - centerChunkX) > renderDistance || Math.abs(subChunk.method_10260() - centerChunkZ) > renderDistance || !this.world.getChunkProvider().method_12123(subChunk.method_10263(), subChunk.method_10260())) continue;
                subChunkCornerPos.method_10103(subChunk.method_10263() << 4, subChunk.method_10264() << 4, subChunk.method_10260() << 4);
                ChunkRendererSchematicVbo chunkRenderer = this.chunkRendererDispatcher.getChunkRenderer((class_2338)subChunkCornerPos);
                if (chunkRenderer == null || !frustum.method_23093(chunkRenderer.getBoundingBox())) continue;
                if (chunkRenderer.needsUpdate() && subChunkCornerPos.equals((Object)viewPosSubChunk)) {
                    chunkRenderer.setNeedsUpdate(true);
                }
                this.renderInfos.add(chunkRenderer);
            }
            this.world.method_16107().method_15407();
        }
        this.world.method_16107().method_15405("rebuild_near");
        Set<ChunkRendererSchematicVbo> set = this.chunksToUpdate;
        this.chunksToUpdate = new LinkedHashSet<ChunkRendererSchematicVbo>();
        for (ChunkRendererSchematicVbo chunkRendererTmp : this.renderInfos) {
            boolean isNear;
            if (!chunkRendererTmp.needsUpdate() && !set.contains(chunkRendererTmp)) continue;
            this.displayListEntitiesDirty = true;
            class_2338 pos = chunkRendererTmp.getOrigin().method_10069(8, 8, 8);
            boolean bl = isNear = pos.method_10262((class_2382)viewPos) < 1024.0;
            if (!chunkRendererTmp.needsImmediateUpdate() && !isNear) {
                this.chunksToUpdate.add(chunkRendererTmp);
                continue;
            }
            this.world.method_16107().method_15396("build_near");
            this.renderDispatcher.updateChunkNow(chunkRendererTmp);
            chunkRendererTmp.clearNeedsUpdate();
            this.world.method_16107().method_15407();
        }
        this.chunksToUpdate.addAll(set);
        this.world.method_16107().method_15407();
        this.world.method_16107().method_15407();
    }

    public void updateChunks(long finishTimeNano) {
        this.mc.method_16011().method_15396("litematica_run_chunk_uploads");
        this.displayListEntitiesDirty |= this.renderDispatcher.runChunkUploads(finishTimeNano);
        this.mc.method_16011().method_15405("litematica_check_update");
        if (!this.chunksToUpdate.isEmpty()) {
            Iterator<ChunkRendererSchematicVbo> iterator = this.chunksToUpdate.iterator();
            while (iterator.hasNext()) {
                boolean flag;
                ChunkRendererSchematicVbo renderChunk = iterator.next();
                if (renderChunk.needsImmediateUpdate()) {
                    this.mc.method_16011().method_15396("litematica_update_now");
                    flag = this.renderDispatcher.updateChunkNow(renderChunk);
                } else {
                    this.mc.method_16011().method_15396("litematica_update_later");
                    flag = this.renderDispatcher.updateChunkLater(renderChunk);
                }
                this.mc.method_16011().method_15407();
                if (!flag) break;
                renderChunk.clearNeedsUpdate();
                iterator.remove();
                long i = finishTimeNano - System.nanoTime();
                if (i >= 0L) continue;
                break;
            }
        }
        this.mc.method_16011().method_15407();
    }

    public int renderBlockLayer(class_1921 renderLayer, class_4587 matrices, class_4184 camera, class_1159 projMatrix) {
        this.world.method_16107().method_15396("render_block_layer_" + renderLayer.toString());
        boolean isTranslucent = renderLayer == class_1921.method_23583();
        renderLayer.method_23516();
        class_243 cameraPos = camera.method_19326();
        double x = cameraPos.field_1352;
        double y = cameraPos.field_1351;
        double z = cameraPos.field_1350;
        if (isTranslucent) {
            this.world.method_16107().method_15396("translucent_sort");
            double diffX = x - this.lastTranslucentSortX;
            double diffY = y - this.lastTranslucentSortY;
            double diffZ = z - this.lastTranslucentSortZ;
            if (diffX * diffX + diffY * diffY + diffZ * diffZ > 1.0) {
                this.lastTranslucentSortX = x;
                this.lastTranslucentSortY = y;
                this.lastTranslucentSortZ = z;
                int i = 0;
                for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
                    if (!chunkRenderer.getChunkRenderData().isBlockLayerStarted(renderLayer) && (chunkRenderer.getChunkRenderData() == ChunkRenderDataSchematic.EMPTY || !chunkRenderer.hasOverlay()) || i++ >= 15) continue;
                    this.renderDispatcher.updateTransparencyLater(chunkRenderer);
                }
            }
            this.world.method_16107().method_15407();
        }
        this.world.method_16107().method_15396("filter_empty");
        this.world.method_16107().method_15405("render");
        boolean reverse = isTranslucent;
        int startIndex = reverse ? this.renderInfos.size() - 1 : 0;
        int stopIndex = reverse ? -1 : this.renderInfos.size();
        int increment = reverse ? -1 : 1;
        int count = 0;
        class_5944 shader = RenderSystem.getShader();
        class_286.method_34420();
        boolean renderAsTranslucent = Configs.Visuals.RENDER_BLOCKS_AS_TRANSLUCENT.getBooleanValue();
        if (renderAsTranslucent) {
            float alpha = (float)Configs.Visuals.GHOST_BLOCK_ALPHA.getDoubleValue();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        }
        WorldRendererSchematic.initShader(shader, matrices, projMatrix);
        RenderSystem.setupShaderLights((class_5944)shader);
        shader.method_34586();
        class_284 chunkOffsetUniform = shader.field_29482;
        boolean startedDrawing = false;
        for (int i = startIndex; i != stopIndex; i += increment) {
            ChunkRendererSchematicVbo renderer = this.renderInfos.get(i);
            if (renderer.getChunkRenderData().isBlockLayerEmpty(renderLayer)) continue;
            class_2338 chunkOrigin = renderer.getOrigin();
            class_291 buffer = renderer.getBlocksVertexBufferByLayer(renderLayer);
            if (chunkOffsetUniform != null) {
                chunkOffsetUniform.method_1249((float)((double)chunkOrigin.method_10263() - x), (float)((double)chunkOrigin.method_10264() - y), (float)((double)chunkOrigin.method_10260() - z));
                chunkOffsetUniform.method_1300();
            }
            buffer.method_1353();
            buffer.method_34432();
            startedDrawing = true;
            ++count;
        }
        if (renderAsTranslucent) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (chunkOffsetUniform != null) {
            chunkOffsetUniform.method_34413(class_1160.field_29501);
        }
        shader.method_34585();
        if (startedDrawing) {
            renderLayer.method_23031().method_22651();
        }
        class_291.method_1354();
        class_291.method_34430();
        renderLayer.method_23518();
        this.world.method_16107().method_15407();
        this.world.method_16107().method_15407();
        return count;
    }

    public void renderBlockOverlays(class_4587 matrices, class_4184 camera, class_1159 projMatrix) {
        this.renderBlockOverlay(ChunkRendererSchematicVbo.OverlayRenderType.OUTLINE, matrices, camera, projMatrix);
        this.renderBlockOverlay(ChunkRendererSchematicVbo.OverlayRenderType.QUAD, matrices, camera, projMatrix);
    }

    private static void initShader(class_5944 shader, class_4587 matrices, class_1159 projMatrix) {
        for (int i = 0; i < 12; ++i) {
            shader.method_34583("Sampler" + i, (Object)RenderSystem.getShaderTexture((int)i));
        }
        if (shader.field_29470 != null) {
            shader.field_29470.method_1250(matrices.method_23760().method_23761());
        }
        if (shader.field_29471 != null) {
            shader.field_29471.method_1250(projMatrix);
        }
        if (shader.field_29474 != null) {
            shader.field_29474.method_1253(RenderSystem.getShaderColor());
        }
        if (shader.field_29477 != null) {
            shader.field_29477.method_1251(RenderSystem.getShaderFogStart());
        }
        if (shader.field_29478 != null) {
            shader.field_29478.method_1251(RenderSystem.getShaderFogEnd());
        }
        if (shader.field_29479 != null) {
            shader.field_29479.method_1253(RenderSystem.getShaderFogColor());
        }
        if (shader.field_29472 != null) {
            shader.field_29472.method_1250(RenderSystem.getTextureMatrix());
        }
        if (shader.field_29481 != null) {
            shader.field_29481.method_1251(RenderSystem.getShaderGameTime());
        }
    }

    private void renderBlockOverlay(ChunkRendererSchematicVbo.OverlayRenderType type, class_4587 matrixStack, class_4184 camera, class_1159 projMatrix) {
        boolean renderThrough;
        class_1921 renderLayer = class_1921.method_23583();
        renderLayer.method_23516();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_243 cameraPos = camera.method_19326();
        double x = cameraPos.field_1352;
        double y = cameraPos.field_1351;
        double z = cameraPos.field_1350;
        this.world.method_16107().method_15396("overlay_" + type.name());
        this.world.method_16107().method_15405("render");
        boolean bl = renderThrough = Configs.Visuals.SCHEMATIC_OVERLAY_RENDER_THROUGH.getBooleanValue() || Hotkeys.RENDER_OVERLAY_THROUGH_BLOCKS.getKeybind().isKeybindHeld();
        if (renderThrough) {
            RenderSystem.disableDepthTest();
        } else {
            RenderSystem.enableDepthTest();
        }
        class_5944 originalShader = RenderSystem.getShader();
        RenderSystem.setShader(class_757::method_34540);
        class_5944 shader = RenderSystem.getShader();
        class_286.method_34420();
        for (int i = this.renderInfos.size() - 1; i >= 0; --i) {
            ChunkRenderDataSchematic compiledChunk;
            ChunkRendererSchematicVbo renderer = this.renderInfos.get(i);
            if (renderer.getChunkRenderData() == ChunkRenderDataSchematic.EMPTY || !renderer.hasOverlay() || (compiledChunk = renderer.getChunkRenderData()).isOverlayTypeEmpty(type)) continue;
            class_291 buffer = renderer.getOverlayVertexBuffer(type);
            class_2338 chunkOrigin = renderer.getOrigin();
            matrixStack.method_22903();
            matrixStack.method_22904((double)chunkOrigin.method_10263() - x, (double)chunkOrigin.method_10264() - y, (double)chunkOrigin.method_10260() - z);
            buffer.method_34427(matrixStack.method_23760().method_23761(), projMatrix, shader);
            matrixStack.method_22909();
        }
        renderLayer.method_23518();
        RenderSystem.setShader(() -> originalShader);
        RenderSystem.disableBlend();
        this.world.method_16107().method_15407();
    }

    public boolean renderBlock(class_1920 world, class_2680 state, class_2338 pos, class_4587 matrices, class_287 bufferBuilderIn) {
        try {
            class_2464 renderType = state.method_26217();
            if (renderType == class_2464.field_11455) {
                return false;
            }
            return renderType == class_2464.field_11458 && this.blockModelRenderer.renderModel(world, this.getModelForState(state), state, pos, matrices, (class_4588)bufferBuilderIn, state.method_26190(pos));
        }
        catch (Throwable throwable) {
            class_128 crashreport = class_128.method_560((Throwable)throwable, (String)"Tesselating block in world");
            class_129 crashreportcategory = crashreport.method_562("Block being tesselated");
            class_129.method_586((class_129)crashreportcategory, (class_5539)world, (class_2338)pos, (class_2680)state);
            throw new class_148(crashreport);
        }
    }

    public boolean renderFluid(class_1920 world, class_3610 state, class_2338 pos, class_287 bufferBuilderIn) {
        return this.blockRenderManager.method_3352(pos, world, (class_4588)bufferBuilderIn, state.method_15759(), state);
    }

    public class_1087 getModelForState(class_2680 state) {
        if (state.method_26217() == class_2464.field_11456) {
            return this.blockRenderManager.method_3351().method_3333().method_4744();
        }
        return this.blockRenderManager.method_3349(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderEntities(class_4184 camera, class_4604 frustum, class_4587 matrices, float partialTicks) {
        if (this.renderEntitiesStartupCounter > 0) {
            --this.renderEntitiesStartupCounter;
        } else {
            this.world.method_16107().method_15396("prepare");
            double cameraX = camera.method_19326().field_1352;
            double cameraY = camera.method_19326().field_1351;
            double cameraZ = camera.method_19326().field_1350;
            class_310.method_1551().method_31975().method_3549((class_1937)this.world, camera, this.mc.field_1765);
            this.entityRenderDispatcher.method_3941((class_1937)this.world, camera, this.mc.field_1692);
            this.countEntitiesTotal = 0;
            this.countEntitiesRendered = 0;
            this.countEntitiesHidden = 0;
            this.countEntitiesTotal = this.world.getRegularEntityCount();
            this.world.method_16107().method_15405("regular_entities");
            class_4597.class_4598 entityVertexConsumers = this.bufferBuilders.method_23000();
            LayerRange layerRange = DataManager.getRenderLayerRange();
            for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
                class_2338 pos = chunkRenderer.getOrigin();
                ChunkSchematic chunk = this.world.getChunk(pos.method_10263() >> 4, pos.method_10260() >> 4);
                List<class_1297> list = chunk.getEntityListForSectionIfExists(pos.method_10264() >> 4);
                if (list.isEmpty()) continue;
                for (class_1297 entityTmp : list) {
                    boolean shouldRender;
                    if (!layerRange.isPositionWithinRange((int)entityTmp.method_23317(), (int)entityTmp.method_23318(), (int)entityTmp.method_23321()) || !(shouldRender = this.entityRenderDispatcher.method_3950(entityTmp, frustum, cameraX, cameraY, cameraZ))) continue;
                    double x = entityTmp.method_23317() - cameraX;
                    double y = entityTmp.method_23318() - cameraY;
                    double z = entityTmp.method_23321() - cameraZ;
                    this.entityRenderDispatcher.method_3954(entityTmp, x, y, z, entityTmp.method_36454(), 1.0f, matrices, (class_4597)entityVertexConsumers, this.entityRenderDispatcher.method_23839(entityTmp, partialTicks));
                    ++this.countEntitiesRendered;
                }
            }
            this.world.method_16107().method_15405("block_entities");
            class_824 renderer = class_310.method_1551().method_31975();
            for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
                ChunkRenderDataSchematic data = chunkRenderer.getChunkRenderData();
                List<class_2586> tiles = data.getBlockEntities();
                if (tiles.isEmpty()) continue;
                class_2338 chunkOrigin = chunkRenderer.getOrigin();
                ChunkSchematic chunk = this.world.getChunkProvider().getChunk(chunkOrigin.method_10263() >> 4, chunkOrigin.method_10260() >> 4);
                if (chunk == null || data.getTimeBuilt() < chunk.getTimeCreated()) continue;
                for (class_2586 te : tiles) {
                    try {
                        class_2338 pos = te.method_11016();
                        matrices.method_22903();
                        matrices.method_22904((double)pos.method_10263() - cameraX, (double)pos.method_10264() - cameraY, (double)pos.method_10260() - cameraZ);
                        renderer.method_3555(te, partialTicks, matrices, (class_4597)entityVertexConsumers);
                        matrices.method_22909();
                    }
                    catch (Exception exception) {}
                }
            }
            Set<class_2586> set = this.blockEntities;
            synchronized (set) {
                for (class_2586 te : this.blockEntities) {
                    try {
                        class_2338 pos = te.method_11016();
                        matrices.method_22903();
                        matrices.method_22904((double)pos.method_10263() - cameraX, (double)pos.method_10264() - cameraY, (double)pos.method_10260() - cameraZ);
                        renderer.method_3555(te, partialTicks, matrices, (class_4597)entityVertexConsumers);
                        matrices.method_22909();
                    }
                    catch (Exception exception) {}
                }
            }
            this.world.method_16107().method_15407();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBlockEntities(Collection<class_2586> toRemove, Collection<class_2586> toAdd) {
        Set<class_2586> set = this.blockEntities;
        synchronized (set) {
            this.blockEntities.removeAll(toRemove);
            this.blockEntities.addAll(toAdd);
        }
    }

    public void scheduleChunkRenders(int chunkX, int chunkY, int chunkZ) {
        if (Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue()) {
            this.chunkRendererDispatcher.scheduleChunkRender(chunkX, chunkY, chunkZ, false);
        }
    }
}

