/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.util.ItemType;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class InventoryUtils {
    private static final class_2371<class_1799> EMPTY_LIST = class_2371.method_10211();

    public static boolean areStacksEqual(class_1799 stack1, class_1799 stack2) {
        return class_1799.method_7987((class_1799)stack1, (class_1799)stack2) && class_1799.method_7975((class_1799)stack1, (class_1799)stack2);
    }

    public static boolean areStacksEqualIgnoreDurability(class_1799 stack1, class_1799 stack2) {
        return class_1799.method_7984((class_1799)stack1, (class_1799)stack2) && class_1799.method_7975((class_1799)stack1, (class_1799)stack2);
    }

    public static void swapSlots(class_1703 container, int slotNum, int hotbarSlot) {
        class_310 mc = class_310.method_1551();
        mc.field_1761.method_2906(container.field_7763, slotNum, hotbarSlot, class_1713.field_7791, (class_1657)mc.field_1724);
    }

    public static boolean isRegularInventorySlot(int slotNumber, boolean allowOffhand) {
        return slotNumber > 8 && (allowOffhand || slotNumber < 45);
    }

    public static int findEmptySlotInPlayerInventory(class_1703 containerPlayer, boolean allowOffhand, boolean reverse) {
        int startSlot = reverse ? containerPlayer.field_7761.size() - 1 : 0;
        int endSlot = reverse ? -1 : containerPlayer.field_7761.size();
        int increment = reverse ? -1 : 1;
        for (int slotNum = startSlot; slotNum != endSlot; slotNum += increment) {
            class_1735 slot = (class_1735)containerPlayer.field_7761.get(slotNum);
            class_1799 stackSlot = slot.method_7677();
            if (!stackSlot.method_7960() || !InventoryUtils.isRegularInventorySlot(slot.field_7874, allowOffhand)) continue;
            return slot.field_7874;
        }
        return -1;
    }

    public static int findSlotWithItem(class_1703 container, class_1799 stackReference, boolean reverse) {
        int startSlot = reverse ? container.field_7761.size() - 1 : 0;
        int endSlot = reverse ? -1 : container.field_7761.size();
        int increment = reverse ? -1 : 1;
        boolean isPlayerInv = container instanceof class_1723;
        for (int slotNum = startSlot; slotNum != endSlot; slotNum += increment) {
            class_1735 slot = (class_1735)container.field_7761.get(slotNum);
            if (isPlayerInv && !InventoryUtils.isRegularInventorySlot(slot.field_7874, false) || !InventoryUtils.areStacksEqualIgnoreDurability(slot.method_7677(), stackReference)) continue;
            return slot.field_7874;
        }
        return -1;
    }

    public static boolean swapItemToMainHand(class_1799 stackReference, class_310 mc) {
        class_746 player = mc.field_1724;
        boolean isCreative = player.method_7337();
        if (InventoryUtils.areStacksEqual(stackReference, player.method_6047())) {
            return false;
        }
        if (isCreative) {
            player.method_31548().method_7374(stackReference);
            mc.field_1761.method_2909(player.method_6047(), 36 + player.method_31548().field_7545);
            return true;
        }
        int slot = InventoryUtils.findSlotWithItem((class_1703)player.field_7498, stackReference, true);
        if (slot != -1) {
            int currentHotbarSlot = player.method_31548().field_7545;
            mc.field_1761.method_2906(player.field_7498.field_7763, slot, currentHotbarSlot, class_1713.field_7791, (class_1657)mc.field_1724);
            return true;
        }
        return false;
    }

    @Nullable
    public static class_1263 getInventory(class_1937 world, class_2338 pos) {
        boolean isLoaded = world.method_22340(pos);
        if (!isLoaded) {
            return null;
        }
        class_2586 te = world.method_8500(pos).method_8321(pos);
        if (te instanceof class_1263) {
            class_2338 posAdj;
            boolean isLoadedAdj;
            class_2745 type;
            class_1263 inv = (class_1263)te;
            class_2680 state = world.method_8320(pos);
            if (state.method_26204() instanceof class_2281 && te instanceof class_2595 && (type = (class_2745)state.method_11654((class_2769)class_2281.field_10770)) != class_2745.field_12569 && (isLoadedAdj = world.method_22340(posAdj = pos.method_10093(class_2281.method_9758((class_2680)state))))) {
                class_2680 stateAdj = world.method_8320(posAdj);
                class_2586 te2 = world.method_8500(posAdj).method_8321(posAdj);
                if (stateAdj.method_26204() == state.method_26204() && te2 instanceof class_2595 && stateAdj.method_11654((class_2769)class_2281.field_10770) != class_2745.field_12569 && stateAdj.method_11654((class_2769)class_2281.field_10768) == state.method_11654((class_2769)class_2281.field_10768)) {
                    class_1263 invRight = type == class_2745.field_12571 ? inv : (class_1263)te2;
                    class_1263 invLeft = type == class_2745.field_12571 ? (class_1263)te2 : inv;
                    inv = new class_1258(invRight, invLeft);
                }
            }
            return inv;
        }
        return null;
    }

    public static boolean shulkerBoxHasItems(class_1799 stackShulkerBox) {
        class_2487 tag;
        class_2487 nbt = stackShulkerBox.method_7969();
        if (nbt != null && nbt.method_10573("BlockEntityTag", 10) && (tag = nbt.method_10562("BlockEntityTag")).method_10573("Items", 9)) {
            class_2499 tagList = tag.method_10554("Items", 10);
            return tagList.size() > 0;
        }
        return false;
    }

    public static class_2371<class_1799> getStoredItems(class_1799 stackIn) {
        class_2487 tagBlockEntity;
        class_2487 nbt = stackIn.method_7969();
        if (nbt != null && nbt.method_10573("BlockEntityTag", 10) && (tagBlockEntity = nbt.method_10562("BlockEntityTag")).method_10573("Items", 9)) {
            class_2371 items = class_2371.method_10211();
            class_2499 tagList = tagBlockEntity.method_10554("Items", 10);
            int count = tagList.size();
            for (int i = 0; i < count; ++i) {
                class_1799 stack = class_1799.method_7915((class_2487)tagList.method_10602(i));
                if (stack.method_7960()) continue;
                items.add((Object)stack);
            }
            return items;
        }
        return class_2371.method_10211();
    }

    public static class_2371<class_1799> getStoredItems(class_1799 stackIn, int slotCount) {
        class_2487 tagBlockEntity;
        class_2487 nbt = stackIn.method_7969();
        if (nbt != null && nbt.method_10573("BlockEntityTag", 10) && (tagBlockEntity = nbt.method_10562("BlockEntityTag")).method_10573("Items", 9)) {
            class_2499 tagList = tagBlockEntity.method_10554("Items", 10);
            int count = tagList.size();
            byte maxSlot = -1;
            if (slotCount <= 0) {
                for (int i = 0; i < count; ++i) {
                    class_2487 tag = tagList.method_10602(i);
                    byte slot = tag.method_10571("Slot");
                    if (slot <= maxSlot) continue;
                    maxSlot = slot;
                }
                slotCount = maxSlot + 1;
            }
            class_2371 items = class_2371.method_10213((int)slotCount, (Object)class_1799.field_8037);
            for (int i = 0; i < count; ++i) {
                class_2487 tag = tagList.method_10602(i);
                class_1799 stack = class_1799.method_7915((class_2487)tag);
                byte slot = tag.method_10571("Slot");
                if (slot < 0 || slot >= items.size() || stack.method_7960()) continue;
                items.set((int)slot, (Object)stack);
            }
            return items;
        }
        return EMPTY_LIST;
    }

    public static Object2IntOpenHashMap<ItemType> getStoredItemCounts(class_1799 stackShulkerBox) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        class_2371<class_1799> items = InventoryUtils.getStoredItems(stackShulkerBox);
        for (class_1799 stack : items) {
            if (stack.method_7960()) continue;
            map.addTo((Object)new ItemType(stack), stack.method_7947());
        }
        return map;
    }

    public static Object2IntOpenHashMap<ItemType> getInventoryItemCounts(class_1263 inv) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        int slots = inv.method_5439();
        for (int slot = 0; slot < slots; ++slot) {
            class_1799 stack = inv.method_5438(slot);
            if (stack.method_7960()) continue;
            map.addTo((Object)new ItemType(stack, false, true), stack.method_7947());
            if (!(stack.method_7909() instanceof class_1747) || !(((class_1747)stack.method_7909()).method_7711() instanceof class_2480) || !InventoryUtils.shulkerBoxHasItems(stack)) continue;
            Object2IntOpenHashMap<ItemType> boxCounts = InventoryUtils.getStoredItemCounts(stack);
            for (ItemType type : boxCounts.keySet()) {
                map.addTo((Object)type, boxCounts.getInt((Object)type));
            }
        }
        return map;
    }

    public static class_1263 getAsInventory(class_2371<class_1799> items) {
        class_1277 inv = new class_1277(items.size());
        for (int slot = 0; slot < items.size(); ++slot) {
            inv.method_5447(slot, (class_1799)items.get(slot));
        }
        return inv;
    }
}

