/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.network;

import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.network.IClientPacketChannelHandler;
import fi.dy.masa.malilib.network.IPluginChannelHandler;
import fi.dy.masa.malilib.network.PacketSplitter;
import fi.dy.masa.malilib.util.PacketUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;

public class ClientPacketChannelHandler
implements IClientPacketChannelHandler {
    public static final class_2960 REGISTER = new class_2960("minecraft:register");
    public static final class_2960 UNREGISTER = new class_2960("minecraft:unregister");
    private static final ClientPacketChannelHandler INSTANCE = new ClientPacketChannelHandler();
    private final ArrayListMultimap<class_2960, IPluginChannelHandler> handlers = ArrayListMultimap.create();

    public static IClientPacketChannelHandler getInstance() {
        return INSTANCE;
    }

    private ClientPacketChannelHandler() {
    }

    @Override
    public void registerClientChannelHandler(IPluginChannelHandler handler) {
        HashSet<class_2960> toRegister = new HashSet<class_2960>();
        for (class_2960 channel : handler.getChannels()) {
            if (this.handlers.containsEntry((Object)channel, (Object)handler)) continue;
            this.handlers.put((Object)channel, (Object)handler);
            if (!handler.registerToServer()) continue;
            toRegister.add(channel);
        }
        if (!toRegister.isEmpty()) {
            this.sendRegisterPacket(REGISTER, toRegister);
        }
    }

    @Override
    public void unregisterClientChannelHandler(IPluginChannelHandler handler) {
        HashSet<class_2960> toUnRegister = new HashSet<class_2960>();
        for (class_2960 channel : handler.getChannels()) {
            if (!this.handlers.remove((Object)channel, (Object)handler) || !handler.registerToServer()) continue;
            toUnRegister.add(channel);
        }
        if (!toUnRegister.isEmpty()) {
            this.sendRegisterPacket(UNREGISTER, toUnRegister);
        }
    }

    public boolean processPacketFromServer(class_2658 packet, class_634 netHandler) {
        class_2960 channel = packet.method_11456();
        List handlers = this.handlers.get((Object)channel);
        if (!handlers.isEmpty()) {
            for (IPluginChannelHandler handler : handlers) {
                class_2540 buf = handler.usePacketSplitter() ? PacketSplitter.receive((class_2602)netHandler, packet) : PacketUtils.retainedSlice((ByteBuf)packet.method_11458());
                if (buf == null) continue;
                handler.onPacketReceived(buf);
            }
            return true;
        }
        return false;
    }

    private void sendRegisterPacket(class_2960 type, Collection<class_2960> channels) {
        String joinedChannels = channels.stream().map(class_2960::toString).collect(Collectors.joining("\u0000"));
        ByteBuf payload = Unpooled.wrappedBuffer((byte[])joinedChannels.getBytes(Charsets.UTF_8));
        class_2817 packet = new class_2817(type, new class_2540(payload));
        class_634 netHandler = class_310.method_1551().method_1562();
        if (netHandler != null) {
            netHandler.method_2883((class_2596)packet);
        } else {
            MaLiLib.logger.warn("Failed to send register channel packet - network handler was null");
        }
    }
}

