/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.util.StringUtils;

public enum MessageOutputType implements IConfigOptionListEntry
{
    NONE("none", "malilib.label.message_output_type.none"),
    ACTIONBAR("actionbar", "malilib.label.message_output_type.actionbar"),
    MESSAGE("message", "malilib.label.message_output_type.message");

    public static final ImmutableList<MessageOutputType> VALUES;
    private final String configString;
    private final String translationKey;

    private MessageOutputType(String configString, String translationKey) {
        this.configString = configString;
        this.translationKey = translationKey;
    }

    @Override
    public String getStringValue() {
        return this.configString;
    }

    @Override
    public String getDisplayName() {
        return StringUtils.translate(this.translationKey, new Object[0]);
    }

    @Override
    public IConfigOptionListEntry cycle(boolean forward) {
        int id = this.ordinal();
        if (forward) {
            if (++id >= MessageOutputType.values().length) {
                id = 0;
            }
        } else if (--id < 0) {
            id = MessageOutputType.values().length - 1;
        }
        return MessageOutputType.values()[id % MessageOutputType.values().length];
    }

    @Override
    public MessageOutputType fromString(String name) {
        return MessageOutputType.fromStringStatic(name);
    }

    public static MessageOutputType fromStringStatic(String name) {
        for (MessageOutputType val : VALUES) {
            if (!val.configString.equalsIgnoreCase(name)) continue;
            return val;
        }
        return NONE;
    }

    static {
        VALUES = ImmutableList.copyOf((Object[])MessageOutputType.values());
    }
}

