/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.config;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import me.jellysquid.mods.lithium.common.config.Option;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LithiumConfig {
    private static final Logger LOGGER = LogManager.getLogger((String)"LithiumConfig");
    private final Map<String, Option> options = new HashMap<String, Option>();

    private LithiumConfig() {
        this.addDefaultMixinOption("chunk.no_locking", false);
    }

    private void addDefaultMixinOption(String mixin, boolean enabled) {
        this.addDefaultOption(LithiumConfig.getMixinRuleName(mixin), enabled);
    }

    private void addDefaultOption(String name, boolean enabled) {
        this.options.put(name, new Option(enabled, false));
    }

    private void discoverMixins(String path) {
        try (InputStream in = LithiumConfig.class.getResourceAsStream(path);){
            if (in == null) {
                throw new IOException("Could not find mixin config at path: " + path);
            }
            JsonObject mixinConfig = (JsonObject)new Gson().fromJson((Reader)new InputStreamReader(in), JsonObject.class);
            this.addKnownMixins(mixinConfig.getAsJsonArray("mixins"));
            this.addKnownMixins(mixinConfig.getAsJsonArray("client"));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not examine mixin config", e);
        }
    }

    private void addKnownMixins(JsonArray array) {
        if (array == null) {
            return;
        }
        for (JsonElement e : array) {
            String name = e.getAsString();
            String packageName = name.substring(0, name.lastIndexOf(46));
            this.addKnownMixinName(packageName);
        }
    }

    private void addKnownMixinName(String name) {
        this.options.computeIfAbsent(LithiumConfig.getMixinRuleName(name), key -> new Option(true, false));
    }

    private void read(Properties props) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            boolean enabled;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Option option = this.options.get(key);
            if (option == null) {
                LOGGER.warn("No configuration key exists with name '{}', ignoring", (Object)key);
                continue;
            }
            if (value.equalsIgnoreCase("true")) {
                enabled = true;
            } else if (value.equalsIgnoreCase("false")) {
                enabled = false;
            } else {
                LOGGER.warn("Invalid value '{}' encountered for configuration key '{}', ignoring", (Object)value, (Object)key);
                continue;
            }
            option.setEnabled(enabled, true);
        }
    }

    public Option getOptionForMixin(String mixinClassName) {
        int nextSplit;
        int start;
        int lastSplit = start = 0;
        Option rule = new Option(true, false);
        while ((nextSplit = mixinClassName.indexOf(46, lastSplit + 1)) != -1) {
            String key = LithiumConfig.getMixinRuleName(mixinClassName.substring(start, nextSplit));
            Option candidate = this.options.get(key);
            if (candidate != null) {
                rule = candidate;
            }
            lastSplit = nextSplit;
        }
        return rule;
    }

    public static LithiumConfig load(File file, String mixinPath) {
        if (!file.exists()) {
            try {
                LithiumConfig.writeDefaultConfig(file);
            }
            catch (IOException e) {
                LOGGER.warn("Could not write default configuration file", (Throwable)e);
            }
            return new LithiumConfig();
        }
        Properties props = new Properties();
        try (FileInputStream fin = new FileInputStream(file);){
            props.load(fin);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load config file", e);
        }
        LithiumConfig config = new LithiumConfig();
        config.discoverMixins(mixinPath);
        config.read(props);
        return config;
    }

    private static void writeDefaultConfig(File file) throws IOException {
        File dir = file.getParentFile();
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new IOException("Could not create parent directories");
            }
        } else if (!dir.isDirectory()) {
            throw new IOException("The parent file is not a directory");
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.write("# This is the configuration file for Lithium.\n");
            writer.write("#\n");
            writer.write("# You can find information on editing this file and all the available options here:\n");
            writer.write("# https://github.com/jellysquid3/lithium-fabric/wiki/Configuration-File\n");
            writer.write("#\n");
            writer.write("# By default, this file will be empty except for this notice.\n");
        }
    }

    private static String getMixinRuleName(String name) {
        return "mixin." + name;
    }

    public int getOptionCount() {
        return this.options.size();
    }

    public int getOptionOverrideCount() {
        return (int)this.options.values().stream().filter(Option::isUserDefined).count();
    }
}

