/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.world.scheduler;

import it.unimi.dsi.fastutil.HashCommon;
import me.jellysquid.mods.lithium.common.world.scheduler.TickEntry;

public class TickEntryQueue<T> {
    private static final int INITIAL_CAPACITY = 16;
    private TickEntry<T>[] arr;
    private int size;

    public TickEntryQueue(int capacity) {
        this.arr = new TickEntry[capacity];
        this.size = 0;
    }

    public TickEntryQueue() {
        this(16);
    }

    public void push(TickEntry<T> tick) {
        if (this.size >= this.arr.length) {
            this.arr = TickEntryQueue.copyArray(this.arr, HashCommon.nextPowerOfTwo((int)(this.arr.length + 1)));
        }
        this.arr[this.size++] = tick;
    }

    public int size() {
        return this.size;
    }

    public void resize(int size) {
        if (size == 0 || size < this.arr.length / 2) {
            this.arr = TickEntryQueue.copyArray(this.arr, size);
        } else {
            for (int i = size; i < this.arr.length; ++i) {
                this.arr[i] = null;
            }
        }
        this.size = size;
    }

    public TickEntry<T> getTickAtIndex(int index) {
        return this.arr[index];
    }

    public void setTickAtIndex(int index, TickEntry<T> tick) {
        this.arr[index] = tick;
    }

    private static <T> TickEntry<T>[] copyArray(TickEntry<T>[] src, int size) {
        TickEntry[] copy = new TickEntry[size];
        if (size != 0) {
            System.arraycopy(src, 0, copy, 0, Math.min(src.length, size));
        }
        return copy;
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }
}

