/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.world.explosions;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1657;
import net.minecraft.class_1900;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1927.class})
public abstract class ExplosionMixin {
    @Shadow
    @Final
    private float field_9190;
    @Shadow
    @Final
    private double field_9195;
    @Shadow
    @Final
    private double field_9192;
    @Shadow
    @Final
    private double field_9189;
    @Shadow
    @Final
    private class_1937 field_9187;
    @Shadow
    @Final
    private class_1297 field_9185;
    @Shadow
    @Final
    private List<class_2338> field_9188;
    @Shadow
    @Final
    private Map<class_1657, class_243> field_9194;
    private final class_2338.class_2339 cachedPos = new class_2338.class_2339();
    private int prevChunkX = Integer.MIN_VALUE;
    private int prevChunkZ = Integer.MIN_VALUE;
    private class_2791 prevChunk;

    @Shadow
    public abstract class_1282 method_8349();

    @Shadow
    public static float method_17752(class_243 self, class_1297 entity) {
        throw new UnsupportedOperationException();
    }

    @Inject(method={"collectBlocksAndDamageEntities"}, at={@At(value="HEAD")}, cancellable=true)
    public void collectBlocksAndDamageEntities(CallbackInfo ci) {
        ci.cancel();
        LongOpenHashSet touched = new LongOpenHashSet(216);
        Random random = this.field_9187.field_9229;
        for (int rayX = 0; rayX < 16; ++rayX) {
            boolean xPlane = rayX == 0 || rayX == 15;
            for (int rayY = 0; rayY < 16; ++rayY) {
                boolean yPlane = rayY == 0 || rayY == 15;
                for (int rayZ = 0; rayZ < 16; ++rayZ) {
                    boolean zPlane;
                    boolean bl = zPlane = rayZ == 0 || rayZ == 15;
                    if (!xPlane && !yPlane && !zPlane) continue;
                    double vecX = (float)rayX / 15.0f * 2.0f - 1.0f;
                    double vecY = (float)rayY / 15.0f * 2.0f - 1.0f;
                    double vecZ = (float)rayZ / 15.0f * 2.0f - 1.0f;
                    this.performRayCast(random, vecX, vecY, vecZ, touched);
                }
            }
        }
        List<class_2338> affectedBlocks = this.field_9188;
        LongIterator it = touched.iterator();
        while (it.hasNext()) {
            affectedBlocks.add(class_2338.method_10092((long)it.nextLong()));
        }
        this.damageEntities();
    }

    private void performRayCast(Random random, double vecX, double vecY, double vecZ, LongOpenHashSet touched) {
        double dist = Math.sqrt(vecX * vecX + vecY * vecY + vecZ * vecZ);
        double normX = vecX / dist;
        double normY = vecY / dist;
        double normZ = vecZ / dist;
        float strength = this.field_9190 * (0.7f + random.nextFloat() * 0.6f);
        double stepX = this.field_9195;
        double stepY = this.field_9192;
        double stepZ = this.field_9189;
        int prevX = Integer.MIN_VALUE;
        int prevY = Integer.MIN_VALUE;
        int prevZ = Integer.MIN_VALUE;
        float prevResistance = 0.0f;
        while (strength > 0.0f) {
            float resistance;
            int blockX = class_3532.method_15357((double)stepX);
            int blockY = class_3532.method_15357((double)stepY);
            int blockZ = class_3532.method_15357((double)stepZ);
            if (prevX != blockX || prevY != blockY || prevZ != blockZ) {
                resistance = this.traverseBlock(strength, blockX, blockY, blockZ, touched);
                prevX = blockX;
                prevY = blockY;
                prevZ = blockZ;
                prevResistance = resistance;
            } else {
                resistance = prevResistance;
            }
            strength -= resistance + 0.225f;
            stepX += normX * 0.3;
            stepY += normY * 0.3;
            stepZ += normZ * 0.3;
        }
    }

    private float traverseBlock(float strength, int blockX, int blockY, int blockZ, LongOpenHashSet touched) {
        class_2826 section;
        if (class_1937.method_8476((int)blockY)) {
            return 0.0f;
        }
        class_2338.class_2339 pos = this.cachedPos.method_10103(blockX, blockY, blockZ);
        int chunkX = blockX >> 4;
        int chunkZ = blockZ >> 4;
        if (this.prevChunkX != chunkX || this.prevChunkZ != chunkZ) {
            this.prevChunk = this.field_9187.method_8497(chunkX, chunkZ);
            this.prevChunkX = chunkX;
            this.prevChunkZ = chunkZ;
        }
        class_2791 chunk = this.prevChunk;
        class_2680 blockState = class_2246.field_10124.method_9564();
        float totalResistance = 0.0f;
        if (chunk != null && (section = chunk.method_12006()[blockY >> 4]) != null && !section.method_12261() && (blockState = section.method_12254(blockX & 0xF, blockY & 0xF, blockZ & 0xF)).method_26204() != class_2246.field_10124) {
            class_3610 fluidState = blockState.method_26227();
            float resistance = Math.max(blockState.method_26204().method_9520(), fluidState.method_15760());
            if (this.field_9185 != null) {
                resistance = this.field_9185.method_5774((class_1927)this, (class_1922)this.field_9187, (class_2338)pos, blockState, fluidState, resistance);
            }
            totalResistance = (resistance + 0.3f) * 0.3f;
        }
        if (strength - totalResistance > 0.0f && (this.field_9185 == null || this.field_9185.method_5853((class_1927)this, (class_1922)this.field_9187, (class_2338)pos, blockState, strength))) {
            touched.add(pos.method_10063());
        }
        return totalResistance;
    }

    private void damageEntities() {
        float range = this.field_9190 * 2.0f;
        int minX = class_3532.method_15357((double)(this.field_9195 - (double)range - 1.0));
        int maxX = class_3532.method_15357((double)(this.field_9195 + (double)range + 1.0));
        int minY = class_3532.method_15357((double)(this.field_9192 - (double)range - 1.0));
        int maxY = class_3532.method_15357((double)(this.field_9192 + (double)range + 1.0));
        int minZ = class_3532.method_15357((double)(this.field_9189 - (double)range - 1.0));
        int maxZ = class_3532.method_15357((double)(this.field_9189 + (double)range + 1.0));
        List entities = this.field_9187.method_8335(this.field_9185, new class_238((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        class_243 selfPos = new class_243(this.field_9195, this.field_9192, this.field_9189);
        for (class_1297 entity : entities) {
            class_1657 player;
            double distZSq;
            double distYSq;
            double damageScale;
            if (entity.method_5659() || (damageScale = (double)(class_3532.method_15368((double)entity.method_5707(selfPos)) / range)) > 1.0) continue;
            double distXSq = entity.method_23317() - this.field_9195;
            double dist = class_3532.method_15368((double)(distXSq * distXSq + (distYSq = (entity instanceof class_1541 ? entity.method_23318() : entity.method_23320()) - this.field_9192) * distYSq + (distZSq = entity.method_23321() - this.field_9189) * distZSq));
            if (dist == 0.0) continue;
            distXSq /= dist;
            distYSq /= dist;
            distZSq /= dist;
            double exposure = ExplosionMixin.method_17752(selfPos, entity);
            double damage = (1.0 - damageScale) * exposure;
            entity.method_5643(this.method_8349(), (float)((int)((damage * damage + damage) / 2.0 * 7.0 * (double)range + 1.0)));
            double knockback = damage;
            if (entity instanceof class_1309) {
                knockback = class_1900.method_8237((class_1309)((class_1309)entity), (double)damage);
            }
            entity.method_18799(entity.method_18798().method_1031(distXSq * knockback, distYSq * knockback, distZSq * knockback));
            if (!(entity instanceof class_1657) || (player = (class_1657)entity).method_7325() || player.method_7337() && player.field_7503.field_7479) continue;
            this.field_9194.put(player, new class_243(distXSq * damage, distYSq * damage, distZSq * damage));
        }
    }
}

