/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.jellysquid.mods.lithium.common.entity.movement.ChunkAwareBlockCollisionSweeper;
import me.jellysquid.mods.lithium.common.util.Producer;
import net.minecraft.class_1297;
import net.minecraft.class_1924;
import net.minecraft.class_1941;
import net.minecraft.class_238;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2784;

public class LithiumEntityCollisions {
    public static final double EPSILON = 1.0E-7;

    public static Stream<class_265> getBlockCollisions(final class_1941 world, final class_1297 entity, class_238 box) {
        if (LithiumEntityCollisions.isBoxEmpty(box)) {
            return Stream.empty();
        }
        final ChunkAwareBlockCollisionSweeper sweeper = new ChunkAwareBlockCollisionSweeper(world, entity, box);
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<class_265>(Long.MAX_VALUE, 1280){
            private boolean skipWorldBorderCheck;
            {
                super(x0, x1);
                this.skipWorldBorderCheck = entity == null;
            }

            @Override
            public boolean tryAdvance(Consumer<? super class_265> consumer) {
                class_265 shape;
                if (!this.skipWorldBorderCheck) {
                    this.skipWorldBorderCheck = true;
                    if (LithiumEntityCollisions.canEntityCollideWithWorldBorder(world, entity)) {
                        consumer.accept((class_265)world.method_8621().method_17903());
                        return true;
                    }
                }
                if ((shape = sweeper.step()) != null) {
                    consumer.accept((class_265)shape);
                    return true;
                }
                return false;
            }
        }, false);
    }

    public static boolean doesBoxCollideWithBlocks(class_1941 world, class_1297 entity, class_238 box) {
        if (LithiumEntityCollisions.isBoxEmpty(box)) {
            return false;
        }
        ChunkAwareBlockCollisionSweeper sweeper = new ChunkAwareBlockCollisionSweeper(world, entity, box);
        class_265 shape = sweeper.step();
        return shape != null;
    }

    public static boolean doesBoxCollideWithEntities(class_1924 view, class_1297 entity, class_238 box, Predicate<class_1297> predicate) {
        if (LithiumEntityCollisions.isBoxEmpty(box)) {
            return false;
        }
        return LithiumEntityCollisions.getEntityCollisionProducer(view, entity, box.method_1014(1.0E-7), predicate).computeNext(null);
    }

    public static Stream<class_265> getEntityCollisions(class_1924 view, class_1297 entity, class_238 box, Predicate<class_1297> predicate) {
        if (LithiumEntityCollisions.isBoxEmpty(box)) {
            return Stream.empty();
        }
        return Producer.asStream(LithiumEntityCollisions.getEntityCollisionProducer(view, entity, box.method_1014(1.0E-7), predicate));
    }

    public static Producer<class_265> getEntityCollisionProducer(final class_1924 view, final class_1297 entity, final class_238 box, final Predicate<class_1297> predicate) {
        return new Producer<class_265>(){
            private Iterator<class_1297> it;

            @Override
            public boolean computeNext(Consumer<? super class_265> consumer) {
                if (this.it == null) {
                    this.it = view.method_8335(entity, box).iterator();
                }
                while (this.it.hasNext()) {
                    class_1297 otherEntity = this.it.next();
                    if (!predicate.test(otherEntity) || (entity != null ? !entity.method_30949(otherEntity) : !otherEntity.method_30948())) continue;
                    if (consumer != null) {
                        consumer.accept((class_265)class_259.method_1078((class_238)otherEntity.method_5829()));
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public static boolean isBoxFullyWithinWorldBorder(class_2784 border, class_238 box) {
        double wboxMinX = Math.floor(border.method_11976());
        double wboxMinZ = Math.floor(border.method_11958());
        double wboxMaxX = Math.ceil(border.method_11963());
        double wboxMaxZ = Math.ceil(border.method_11977());
        return box.field_1323 >= wboxMinX && box.field_1323 < wboxMaxX && box.field_1321 >= wboxMinZ && box.field_1321 < wboxMaxZ && box.field_1320 >= wboxMinX && box.field_1320 < wboxMaxX && box.field_1324 >= wboxMinZ && box.field_1324 < wboxMaxZ;
    }

    private static boolean canEntityCollideWithWorldBorder(class_1941 world, class_1297 entity) {
        class_2784 border = world.method_8621();
        boolean isInsideBorder = LithiumEntityCollisions.isBoxFullyWithinWorldBorder(border, entity.method_5829().method_1011(1.0E-7));
        boolean isCrossingBorder = LithiumEntityCollisions.isBoxFullyWithinWorldBorder(border, entity.method_5829().method_1014(1.0E-7));
        return !isInsideBorder && isCrossingBorder;
    }

    private static boolean isBoxEmpty(class_238 box) {
        return box.method_995() <= 1.0E-7;
    }
}

