/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.shapes;

import me.jellysquid.mods.lithium.common.shapes.VoxelShapeAlignedCuboid_Offset;
import me.jellysquid.mods.lithium.common.shapes.VoxelShapeSimpleCube;
import net.minecraft.class_2335;
import net.minecraft.class_238;
import net.minecraft.class_251;
import net.minecraft.class_265;
import net.minecraft.class_3532;

public class VoxelShapeAlignedCuboid
extends VoxelShapeSimpleCube {
    static final double LARGE_EPSILON = 1.0E-6;
    protected final int xSegments;
    protected final int ySegments;
    protected final int zSegments;

    public VoxelShapeAlignedCuboid(class_251 voxels, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, int xRes, int yRes, int zRes) {
        super(voxels, minX, minY, minZ, maxX, maxY, maxZ);
        this.xSegments = xRes <= 1 ? 1 : 1 << xRes;
        this.ySegments = yRes <= 1 ? 1 : 1 << yRes;
        this.zSegments = zRes <= 1 ? 1 : 1 << zRes;
    }

    public VoxelShapeAlignedCuboid(class_251 voxels, int xSegments, int ySegments, int zSegments, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        super(voxels, minX, minY, minZ, maxX, maxY, maxZ);
        this.xSegments = xSegments;
        this.ySegments = ySegments;
        this.zSegments = zSegments;
    }

    @Override
    public class_265 method_1096(double x, double y, double z) {
        return new VoxelShapeAlignedCuboid_Offset(this, this.field_1401, x, y, z);
    }

    @Override
    public double method_1103(class_2335 cycleDirection, class_238 box, double maxDist) {
        if (Math.abs(maxDist) < 1.0E-7) {
            return 0.0;
        }
        double penetration = this.calculatePenetration(cycleDirection, box, maxDist);
        if (penetration != maxDist && this.intersects(cycleDirection, box)) {
            return penetration;
        }
        return maxDist;
    }

    private double calculatePenetration(class_2335 dir, class_238 box, double maxDist) {
        switch (dir) {
            case field_10962: {
                return VoxelShapeAlignedCuboid.calculatePenetration(this.minX, this.maxX, this.xSegments, box.field_1323, box.field_1320, maxDist);
            }
            case field_10963: {
                return VoxelShapeAlignedCuboid.calculatePenetration(this.minZ, this.maxZ, this.zSegments, box.field_1321, box.field_1324, maxDist);
            }
            case field_10965: {
                return VoxelShapeAlignedCuboid.calculatePenetration(this.minY, this.maxY, this.ySegments, box.field_1322, box.field_1325, maxDist);
            }
        }
        throw new IllegalArgumentException();
    }

    private static double calculatePenetration(double aMin, double aMax, int segmentsPerUnit, double bMin, double bMax, double maxDist) {
        if (maxDist > 0.0) {
            double gap = aMin - bMax;
            if (gap >= -1.0E-7) {
                return Math.min(gap, maxDist);
            }
            if (segmentsPerUnit == 1) {
                return maxDist;
            }
            double wallPos = (double)class_3532.method_15384((double)((bMax - 1.0E-7) * (double)segmentsPerUnit)) / (double)segmentsPerUnit;
            if (wallPos < aMax - 1.0E-6) {
                return Math.min(maxDist, wallPos - bMax);
            }
            return maxDist;
        }
        double gap = aMax - bMin;
        if (gap <= 1.0E-7) {
            return Math.max(gap, maxDist);
        }
        if (segmentsPerUnit == 1) {
            return maxDist;
        }
        double wallPos = (double)class_3532.method_15357((double)((bMin + 1.0E-7) * (double)segmentsPerUnit)) / (double)segmentsPerUnit;
        if (wallPos > aMin + 1.0E-6) {
            return Math.max(maxDist, wallPos - bMin);
        }
        return maxDist;
    }
}

