/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.shapes;

import me.jellysquid.mods.lithium.common.shapes.VoxelShapeAlignedCuboid;
import net.minecraft.class_2335;
import net.minecraft.class_238;
import net.minecraft.class_251;
import net.minecraft.class_265;
import net.minecraft.class_3532;

public class VoxelShapeAlignedCuboid_Offset
extends VoxelShapeAlignedCuboid {
    private final double xOffset;
    private final double yOffset;
    private final double zOffset;

    public VoxelShapeAlignedCuboid_Offset(VoxelShapeAlignedCuboid originalShape, class_251 voxels, double xOffset, double yOffset, double zOffset) {
        super(voxels, originalShape.xSegments, originalShape.ySegments, originalShape.zSegments, originalShape.minX + xOffset, originalShape.minY + yOffset, originalShape.minZ + zOffset, originalShape.maxX + xOffset, originalShape.maxY + yOffset, originalShape.maxZ + zOffset);
        if (originalShape instanceof VoxelShapeAlignedCuboid_Offset) {
            this.xOffset = ((VoxelShapeAlignedCuboid_Offset)originalShape).xOffset + xOffset;
            this.yOffset = ((VoxelShapeAlignedCuboid_Offset)originalShape).yOffset + yOffset;
            this.zOffset = ((VoxelShapeAlignedCuboid_Offset)originalShape).zOffset + zOffset;
        } else {
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.zOffset = zOffset;
        }
    }

    @Override
    public class_265 method_1096(double x, double y, double z) {
        return new VoxelShapeAlignedCuboid_Offset(this, this.field_1401, x, y, z);
    }

    @Override
    public double method_1103(class_2335 cycleDirection, class_238 box, double maxDist) {
        if (Math.abs(maxDist) < 1.0E-7) {
            return 0.0;
        }
        double penetration = this.calculatePenetration(cycleDirection, box, maxDist);
        if (penetration != maxDist && this.intersects(cycleDirection, box)) {
            return penetration;
        }
        return maxDist;
    }

    private double calculatePenetration(class_2335 dir, class_238 box, double maxDist) {
        switch (dir) {
            case field_10962: {
                return VoxelShapeAlignedCuboid_Offset.calculatePenetration(this.minX, this.maxX, this.xSegments, this.xOffset, box.field_1323, box.field_1320, maxDist);
            }
            case field_10963: {
                return VoxelShapeAlignedCuboid_Offset.calculatePenetration(this.minZ, this.maxZ, this.zSegments, this.zOffset, box.field_1321, box.field_1324, maxDist);
            }
            case field_10965: {
                return VoxelShapeAlignedCuboid_Offset.calculatePenetration(this.minY, this.maxY, this.ySegments, this.yOffset, box.field_1322, box.field_1325, maxDist);
            }
        }
        throw new IllegalArgumentException();
    }

    private static double calculatePenetration(double aMin, double aMax, int segmentsPerUnit, double shapeOffset, double bMin, double bMax, double maxDist) {
        if (maxDist > 0.0) {
            double gap = aMin - bMax;
            if (gap >= -1.0E-7) {
                return Math.min(gap, maxDist);
            }
            if (segmentsPerUnit == 1) {
                return maxDist;
            }
            int segment = class_3532.method_15384((double)((bMax - 1.0E-6 - shapeOffset) * (double)segmentsPerUnit));
            double wallPos = (double)segment / (double)segmentsPerUnit + shapeOffset;
            if (wallPos < bMax - 1.0E-7) {
                wallPos = (double)(++segment) / (double)segmentsPerUnit + shapeOffset;
            }
            if (wallPos < aMax - 1.0E-6) {
                return Math.min(maxDist, wallPos - bMax);
            }
            return maxDist;
        }
        double gap = aMax - bMin;
        if (gap <= 1.0E-7) {
            return Math.max(gap, maxDist);
        }
        if (segmentsPerUnit == 1) {
            return maxDist;
        }
        int segment = class_3532.method_15357((double)((bMin + 1.0E-6 - shapeOffset) * (double)segmentsPerUnit));
        double wallPos = (double)segment / (double)segmentsPerUnit + shapeOffset;
        if (wallPos > bMin + 1.0E-7) {
            wallPos = (double)(--segment) / (double)segmentsPerUnit + shapeOffset;
        }
        if (wallPos > aMin + 1.0E-6) {
            return Math.max(maxDist, wallPos - bMin);
        }
        return maxDist;
    }
}

