/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.world.scheduler;

import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import me.jellysquid.mods.lithium.common.world.scheduler.TickEntry;
import me.jellysquid.mods.lithium.common.world.scheduler.TickEntryQueue;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1923;
import net.minecraft.class_1949;
import net.minecraft.class_1953;
import net.minecraft.class_1954;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3341;

public class LithiumServerTickScheduler<T>
extends class_1949<T> {
    private static final Predicate<TickEntry<?>> PREDICATE_ANY_TICK = entry -> true;
    private static final Predicate<TickEntry<?>> PREDICATE_ACTIVE_TICKS = entry -> !entry.consumed;
    private final Long2ObjectSortedMap<TickEntryQueue<T>> scheduledTicksOrdered = new Long2ObjectAVLTreeMap();
    private final Long2ObjectOpenHashMap<Set<TickEntry<T>>> scheduledTicksByChunk = new Long2ObjectOpenHashMap();
    private final Map<class_1954<T>, TickEntry<T>> scheduledTicks = new HashMap<class_1954<T>, TickEntry<T>>();
    private final ArrayList<TickEntry<T>> executingTicks = new ArrayList();
    private final Predicate<T> invalidObjPredicate;
    private final class_3218 world;
    private final Consumer<class_1954<T>> tickConsumer;

    public LithiumServerTickScheduler(class_3218 world, Predicate<T> invalidPredicate, Function<T, class_2960> idToName, Consumer<class_1954<T>> tickConsumer) {
        super(world, invalidPredicate, idToName, tickConsumer);
        this.invalidObjPredicate = invalidPredicate;
        this.world = world;
        this.tickConsumer = tickConsumer;
    }

    public void method_8670() {
        this.world.method_16107().method_15396("cleaning");
        this.selectTicks(this.world.method_14178(), this.world.method_8510());
        this.world.method_16107().method_15405("executing");
        this.executeTicks(this.tickConsumer);
        this.world.method_16107().method_15407();
    }

    public boolean method_8677(class_2338 pos, T obj) {
        TickEntry<T> entry = this.scheduledTicks.get(new class_1954(pos, obj));
        if (entry == null) {
            return false;
        }
        return entry.executing;
    }

    public boolean method_8674(class_2338 pos, T obj) {
        TickEntry<T> entry = this.scheduledTicks.get(new class_1954(pos, obj));
        if (entry == null) {
            return false;
        }
        return entry.scheduled;
    }

    public List<class_1954<T>> method_8671(class_1923 chunkPos, boolean mutates, boolean getStaleTicks) {
        class_3341 box = new class_3341(chunkPos.method_8326() - 2, chunkPos.method_8328() - 2, chunkPos.method_8327() + 2, chunkPos.method_8329() + 2);
        return this.method_8672(box, mutates, getStaleTicks);
    }

    public List<class_1954<T>> method_8672(class_3341 box, boolean remove, boolean getStaleTicks) {
        return this.collectTicks(box, remove, getStaleTicks ? PREDICATE_ANY_TICK : PREDICATE_ACTIVE_TICKS);
    }

    public void method_8666(class_3341 box, class_2338 pos) {
        List<class_1954<T>> list = this.method_8672(box, false, false);
        for (class_1954<T> tick : list) {
            this.addScheduledTick(new class_1954(tick.field_9322.method_10081((class_2382)pos), tick.method_8683(), tick.field_9321, tick.field_9320));
        }
    }

    public void method_8675(class_2338 pos, T obj, int delay, class_1953 priority) {
        if (!this.invalidObjPredicate.test(obj)) {
            this.addScheduledTick(new class_1954(pos, obj, (long)delay + this.world.method_8510(), priority));
        }
    }

    public int method_20825() {
        int count = 0;
        for (TickEntry<T> entry : this.scheduledTicks.values()) {
            if (!entry.scheduled) continue;
            ++count;
        }
        return count;
    }

    public void selectTicks(class_3215 chunkManager, long time) {
        long headKey = LithiumServerTickScheduler.getBucketKey(time + 1L, class_1953.field_9315) - 1L;
        int limit = 65565;
        boolean canTick = true;
        long prevChunk = Long.MIN_VALUE;
        ObjectIterator it = this.scheduledTicksOrdered.headMap(headKey).values().iterator();
        while (limit > 0 && it.hasNext()) {
            TickEntryQueue list = (TickEntryQueue)it.next();
            int w = 0;
            for (int i = 0; i < list.size(); ++i) {
                TickEntry tick = list.getTickAtIndex(i);
                if (!tick.scheduled) continue;
                if (limit > 0) {
                    long chunk = class_1923.method_8331((int)(tick.field_9322.method_10263() >> 4), (int)(tick.field_9322.method_10260() >> 4));
                    if (prevChunk != chunk) {
                        prevChunk = chunk;
                        canTick = chunkManager.method_20529(tick.field_9322);
                    }
                    if (canTick) {
                        tick.scheduled = false;
                        tick.executing = true;
                        this.executingTicks.add(tick);
                        --limit;
                        continue;
                    }
                }
                list.setTickAtIndex(w++, tick);
            }
            list.resize(w);
            if (!list.isEmpty()) continue;
            it.remove();
        }
    }

    public void executeTicks(Consumer<class_1954<T>> consumer) {
        for (TickEntry<T> tick : this.executingTicks) {
            try {
                tick.executing = false;
                consumer.accept(tick);
                if (tick.scheduled) continue;
                this.removeTickEntry(tick);
            }
            catch (Throwable e) {
                class_128 crash = class_128.method_560((Throwable)e, (String)"Exception while ticking");
                class_129 section = crash.method_562("Block being ticked");
                class_129.method_586((class_129)section, (class_2338)tick.field_9322, null);
                throw new class_148(crash);
            }
        }
        this.executingTicks.clear();
    }

    private List<class_1954<T>> collectTicks(class_3341 box, boolean remove, Predicate<TickEntry<?>> predicate) {
        ArrayList<class_1954<T>> ret = new ArrayList<class_1954<T>>();
        int minChunkX = box.field_14381 >> 4;
        int maxChunkX = box.field_14378 >> 4;
        int minChunkZ = box.field_14379 >> 4;
        int maxChunkZ = box.field_14376 >> 4;
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int i = minChunkZ; i <= maxChunkZ; ++i) {
                long chunk = class_1923.method_8331((int)chunkX, (int)i);
                Set set = (Set)this.scheduledTicksByChunk.get(chunk);
                if (set == null) continue;
                for (TickEntry tick : set) {
                    if (!box.method_14662((class_2382)tick.field_9322) || !predicate.test(tick)) continue;
                    ret.add(tick);
                }
            }
        }
        if (remove) {
            for (class_1954 class_19542 : ret) {
                this.removeTickEntry((TickEntry)class_19542);
            }
        }
        return ret;
    }

    private void addScheduledTick(class_1954<T> tick) {
        TickEntry entry = this.scheduledTicks.computeIfAbsent(tick, this::createTickEntry);
        if (!entry.scheduled) {
            TickEntryQueue timeIdx = (TickEntryQueue)this.scheduledTicksOrdered.computeIfAbsent(LithiumServerTickScheduler.getBucketKey(tick.field_9321, tick.field_9320), key -> new TickEntryQueue());
            timeIdx.push(entry);
            entry.scheduled = true;
        }
    }

    private TickEntry<T> createTickEntry(class_1954<T> tick) {
        Set chunkIdx = (Set)this.scheduledTicksByChunk.computeIfAbsent(LithiumServerTickScheduler.getChunkKey(tick.field_9322), LithiumServerTickScheduler::createChunkIndex);
        return new TickEntry<T>(tick, chunkIdx);
    }

    private void removeTickEntry(TickEntry<T> tick) {
        tick.scheduled = false;
        tick.consumed = true;
        tick.chunkIdx.remove(tick);
        if (tick.chunkIdx.isEmpty()) {
            this.scheduledTicksByChunk.remove(LithiumServerTickScheduler.getChunkKey(tick.field_9322));
        }
        this.scheduledTicks.remove(tick);
    }

    private static <T> Set<TickEntry<T>> createChunkIndex(long pos) {
        return new ObjectOpenHashSet(8);
    }

    private static long getChunkKey(class_2338 pos) {
        return class_1923.method_8331((int)(pos.method_10263() >> 4), (int)(pos.method_10260() >> 4));
    }

    private static long getBucketKey(long time, class_1953 priority) {
        return time << 4 | (long)(priority.ordinal() & 0xF);
    }
}

