/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.asm;

import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;

public class MethodRef {
    public final String name;
    public final String desc;

    public MethodRef(String name, String desc) {
        this.name = name;
        this.desc = desc;
    }

    public static MethodRef intermediary(String owner, String name, String desc) {
        MappingResolver remapper = FabricLoader.getInstance().getMappingResolver();
        String methodName = remapper.mapMethodName("intermediary", owner, name, desc);
        return new MethodRef(methodName, desc);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            MethodRef ref = (MethodRef)other;
            return Objects.equals(this.name, ref.name) && Objects.equals(this.desc, ref.desc);
        }
        return false;
    }

    public int hashCode() {
        int h = this.name.hashCode();
        h = 31 * h + this.desc.hashCode();
        return h;
    }

    public String toString() {
        return String.format("MethodRef{name='%s', desc='%s'}", this.name, this.desc);
    }
}

