/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.asm.patches;

import com.chocohead.mm.api.ClassTinkerers;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Consumer;
import me.jellysquid.mods.lithium.asm.FieldRef;
import me.jellysquid.mods.lithium.asm.MethodRef;
import me.jellysquid.mods.lithium.asm.consumers.FieldAccessTransformer;
import me.jellysquid.mods.lithium.asm.consumers.FieldCleaner;
import me.jellysquid.mods.lithium.asm.consumers.FieldRemapper;
import me.jellysquid.mods.lithium.asm.consumers.MethodCleaner;
import me.jellysquid.mods.lithium.asm.consumers.PatchSetTransformer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;

public class DevirtualizeBlockPosTransformer {
    private static final String BLOCK_POS_MUTABLE_CLASS_NAME = "net.minecraft.class_2338$class_2339";
    private static final String VEC3I_CLASS_NAME = "net.minecraft.class_2382";

    public static void install() {
        MappingResolver remapper = FabricLoader.getInstance().getMappingResolver();
        String blockPosTarget = remapper.mapClassName("intermediary", BLOCK_POS_MUTABLE_CLASS_NAME);
        String vec3iTarget = remapper.mapClassName("intermediary", VEC3I_CLASS_NAME);
        FieldRef blockPosX = FieldRef.intermediary(BLOCK_POS_MUTABLE_CLASS_NAME, "field_10986", "I");
        FieldRef blockPosY = FieldRef.intermediary(BLOCK_POS_MUTABLE_CLASS_NAME, "field_10985", "I");
        FieldRef blockPosZ = FieldRef.intermediary(BLOCK_POS_MUTABLE_CLASS_NAME, "field_10984", "I");
        FieldRef vecX = FieldRef.intermediary(VEC3I_CLASS_NAME, "field_11175", "I");
        FieldRef vecY = FieldRef.intermediary(VEC3I_CLASS_NAME, "field_11174", "I");
        FieldRef vecZ = FieldRef.intermediary(VEC3I_CLASS_NAME, "field_11173", "I");
        ClassTinkerers.addTransformation((String)blockPosTarget, (Consumer)new PatchSetTransformer("Use mutable fields in Vec3i", Arrays.asList(new FieldCleaner(blockPosX, blockPosY, blockPosZ), new MethodCleaner(MethodRef.intermediary(VEC3I_CLASS_NAME, "method_10263", "()I"), MethodRef.intermediary(VEC3I_CLASS_NAME, "method_10264", "()I"), MethodRef.intermediary(VEC3I_CLASS_NAME, "method_10260", "()I")), new FieldRemapper(new FieldRemapper.FieldMapping(blockPosX, vecX), new FieldRemapper.FieldMapping(blockPosY, vecY), new FieldRemapper.FieldMapping(blockPosZ, vecZ)))));
        ClassTinkerers.addTransformation((String)vec3iTarget, (Consumer)new PatchSetTransformer("Modify mutability flags in Vec3i", Collections.singletonList(new FieldAccessTransformer(4, vecX, vecY, vecZ))));
    }
}

