/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.block.redstone.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.jellysquid.mods.lithium.common.block.redstone.RedstoneLogic;
import me.jellysquid.mods.lithium.common.block.redstone.graph.UpdateFlag;
import me.jellysquid.mods.lithium.common.block.redstone.graph.UpdateGraph;
import me.jellysquid.mods.lithium.common.block.redstone.graph.UpdateNodeBlockType;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2457;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class UpdateNode {
    private final UpdateGraph graph;
    private final class_2338 pos;
    private final UpdateNode[] adjacentNodes = new UpdateNode[6];
    private final List<UpdateNode> connections = new ArrayList<UpdateNode>(0);
    private class_2680 state;
    private UpdateNodeBlockType type;
    private byte currentWirePower = 0;
    private byte darkeningThreshold = (byte)-1;
    private byte flags;

    UpdateNode(UpdateGraph graph, class_2338 pos) {
        this.graph = graph;
        this.pos = pos.method_10062();
        this.invalidateWorldState();
    }

    public UpdateNode getAdjacent(class_2350 dir) {
        UpdateNode adj = this.adjacentNodes[dir.ordinal()];
        if (adj == null) {
            adj = this.graph.getOrCreateNode(this.pos.method_10093(dir));
            adj.adjacentNodes[dir.method_10153().ordinal()] = this;
            this.adjacentNodes[dir.ordinal()] = adj;
        }
        return adj;
    }

    public boolean isWireBlock() {
        return this.type == UpdateNodeBlockType.WIRE;
    }

    public boolean isFullBlock() {
        return this.type == UpdateNodeBlockType.FULL_BLOCK;
    }

    public class_2680 getBlockState() {
        return this.state;
    }

    public int getCurrentWirePower() {
        return this.currentWirePower;
    }

    public void setCurrentWirePower(int currentWirePower) {
        if (!this.isWireBlock()) {
            throw new IllegalStateException("Not a wire block!");
        }
        this.currentWirePower = (byte)currentWirePower;
    }

    public class_2338 getPosition() {
        return this.pos;
    }

    private class_1937 getWorld() {
        return this.graph.getWorld();
    }

    public int getOutgoingStrongPower(class_2350 dir) {
        if (this.isWireBlock()) {
            return 0;
        }
        return this.getBlockState().method_11577((class_1922)this.getWorld(), this.getPosition(), dir);
    }

    public int getOutgoingWeakPower(class_2350 dir) {
        if (this.isWireBlock()) {
            return this.getOutgoingWirePower();
        }
        return this.getBlockState().method_11597((class_1922)this.getWorld(), this.getPosition(), dir);
    }

    private int getOutgoingWirePower() {
        return Math.max(0, this.getCurrentWirePower() - 1);
    }

    public int calculateIncomingEffectivePower() {
        UpdateNode adj;
        int power = 0;
        boolean canAscend = !this.getAdjacent(class_2350.field_11036).isFullBlock();
        for (class_2350 dir : RedstoneLogic.INCOMING_POWER_DIRECTIONS) {
            adj = this.getAdjacent(dir);
            if (adj.isFullBlock()) {
                power = Math.max(power, adj.calculateIncomingStrongPower());
            }
            power = Math.max(power, adj.getOutgoingWeakPower(dir));
        }
        for (class_2350 dir : RedstoneLogic.WIRE_NEIGHBORS_HORIZONTAL) {
            adj = this.getAdjacent(dir);
            if (canAscend && adj.isFullBlock()) {
                power = Math.max(power, adj.getAdjacent(class_2350.field_11036).getOutgoingWirePower());
            }
            if (adj.isFullBlock()) continue;
            power = Math.max(power, adj.getAdjacent(class_2350.field_11033).getOutgoingWirePower());
        }
        return Math.min(power, 15);
    }

    private int calculateIncomingStrongPower() {
        int power = 0;
        for (class_2350 dir : RedstoneLogic.INCOMING_POWER_DIRECTIONS) {
            power = Math.max(power, this.getAdjacent(dir).getOutgoingStrongPower(dir));
        }
        return power;
    }

    public void invalidateWorldState() {
        this.state = this.graph.getBlockAccess().getBlockState(this.pos);
        if (this.state.method_11614() == class_2246.field_10091) {
            this.type = UpdateNodeBlockType.WIRE;
            this.currentWirePower = ((Integer)this.state.method_11654((class_2769)class_2457.field_11432)).byteValue();
        } else if (this.state.method_11621((class_1922)this.getWorld(), this.getPosition())) {
            this.type = UpdateNodeBlockType.FULL_BLOCK;
            this.currentWirePower = 0;
        } else {
            this.type = UpdateNodeBlockType.NON_FULL_BLOCK;
            this.currentWirePower = 0;
        }
    }

    public void updateWireState() {
        this.state = this.createUpdatedWireState();
        this.graph.getBlockAccess().setBlockState(this.getPosition(), this.state);
    }

    public class_2680 createUpdatedWireState() {
        if (!this.isWireBlock()) {
            throw new IllegalStateException("Not a wire block");
        }
        return (class_2680)this.getBlockState().method_11657((class_2769)class_2457.field_11432, (Comparable)Integer.valueOf(this.getCurrentWirePower()));
    }

    public int getDarkeningThreshold() {
        return this.darkeningThreshold;
    }

    public void setDarkeningThreshold(int power) {
        this.darkeningThreshold = (byte)power;
    }

    public String toString() {
        return String.format("UpdateNode{pos=%s, currentWirePower=%s, darkeningThreshold=%s}", this.pos, this.currentWirePower, this.darkeningThreshold);
    }

    public boolean isWireAtValidLocation() {
        return this.getAdjacent(class_2350.field_11033).canSupportWireBlock();
    }

    public boolean canSupportWireBlock() {
        this.invalidateWorldState();
        class_1937 world = this.getWorld();
        class_2680 state = this.getBlockState();
        class_2338 pos = this.getPosition();
        return state.method_20827((class_1922)world, pos, class_2350.field_11036) || state.method_11614() == class_2246.field_10312;
    }

    public void destroyWire() {
        class_2248.method_9497((class_2680)this.getBlockState(), (class_1937)this.getWorld(), (class_2338)this.getPosition());
        this.getWorld().method_8650(this.getPosition(), false);
    }

    public void invalidateConnections() {
        this.connections.clear();
    }

    public void addConnection(UpdateNode node) {
        this.connections.add(node);
    }

    public Collection<UpdateNode> getConnections() {
        return Collections.unmodifiableCollection(this.connections);
    }

    public boolean checkAndMarkFlag(UpdateFlag flag) {
        int bit;
        int flags = Byte.toUnsignedInt(this.flags);
        if ((flags & (bit = 1 << flag.ordinal())) != 0) {
            return false;
        }
        this.flags = (byte)(flags | bit);
        return true;
    }

    public void clearFlags() {
        this.flags = 0;
    }

    public void update(UpdateNode origin, class_2350 dir, boolean updateObservers) {
        class_2680 state;
        this.invalidateWorldState();
        class_2680 class_26802 = state = updateObservers ? this.getUpdatedBlockState(origin, dir) : this.getBlockState();
        if (state.method_11614() != class_2246.field_10091) {
            state.method_11622(this.getWorld(), this.getPosition(), class_2246.field_10091, origin.getPosition(), false);
        }
    }

    private class_2680 getUpdatedBlockState(UpdateNode origin, class_2350 dir) {
        class_2680 state = this.getBlockState();
        if (state.method_11614() != class_2246.field_10091) {
            class_2680 newState = state.method_11578(dir.method_10153(), state, (class_1936)this.getWorld(), this.getPosition(), origin.getPosition());
            this.replaceBlock(state, newState, (class_1936)this.getWorld(), this.getPosition());
            state = newState;
        }
        return state;
    }

    private void replaceBlock(class_2680 state, class_2680 updatedState, class_1936 world, class_2338 pos) {
        if (updatedState == state) {
            return;
        }
        if (updatedState.method_11588()) {
            if (world.method_8608()) {
                return;
            }
            world.method_22352(pos, true);
        } else {
            this.graph.getBlockAccess().setBlockState(pos, updatedState);
        }
    }
}

