/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity.tracker.nearby;

import java.util.HashSet;
import java.util.Set;
import me.jellysquid.mods.lithium.common.entity.tracker.nearby.NearbyEntityListener;
import net.minecraft.class_1309;
import net.minecraft.class_3532;

public class NearbyEntityTracker<T extends class_1309>
implements NearbyEntityListener {
    private final Class<T> clazz;
    private final class_1309 self;
    private final int rangeC;
    private final float rangeSq;
    private final Set<T> nearby = new HashSet<T>();

    public NearbyEntityTracker(Class<T> clazz, class_1309 self, float range) {
        this.clazz = clazz;
        this.self = self;
        this.rangeSq = range * range;
        this.rangeC = class_3532.method_15359((int)class_3532.method_15386((float)range), (int)16) >> 4;
    }

    @Override
    public int getChunkRange() {
        return this.rangeC;
    }

    @Override
    public void onEntityEnteredRange(class_1309 entity) {
        if (!this.clazz.isInstance(entity)) {
            return;
        }
        this.nearby.add(entity);
    }

    @Override
    public void onEntityLeftRange(class_1309 entity) {
        if (this.nearby.isEmpty() || !this.clazz.isInstance(entity)) {
            return;
        }
        this.nearby.remove(entity);
    }

    public T getClosestEntity() {
        double x = this.self.method_23317();
        double y = this.self.method_23318();
        double z = this.self.method_23321();
        class_1309 nearest = null;
        double nearestDistance = Double.POSITIVE_INFINITY;
        for (class_1309 entity : this.nearby) {
            double distance = entity.method_5649(x, y, z);
            if (!(distance < nearestDistance)) continue;
            nearest = entity;
            nearestDistance = distance;
        }
        if (nearestDistance <= (double)this.rangeSq) {
            return (T)nearest;
        }
        return null;
    }
}

