/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.shapes;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1924;
import net.minecraft.class_1941;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3980;

public class LithiumEntityCollisions {
    public static Stream<class_265> getBlockCollisions(final class_1941 world, final class_1297 entity, final class_238 entityBox) {
        int minX = class_3532.method_15357((double)(entityBox.field_1323 - 1.0E-7)) - 1;
        int maxX = class_3532.method_15357((double)(entityBox.field_1320 + 1.0E-7)) + 1;
        int minY = class_3532.method_15357((double)(entityBox.field_1322 - 1.0E-7)) - 1;
        int maxY = class_3532.method_15357((double)(entityBox.field_1325 + 1.0E-7)) + 1;
        int minZ = class_3532.method_15357((double)(entityBox.field_1321 - 1.0E-7)) - 1;
        int maxZ = class_3532.method_15357((double)(entityBox.field_1324 + 1.0E-7)) + 1;
        final class_3726 context = entity == null ? class_3726.method_16194() : class_3726.method_16195((class_1297)entity);
        final class_3980 cuboidIt = new class_3980(minX, minY, minZ, maxX, maxY, maxZ);
        final class_2338.class_2339 pos = new class_2338.class_2339();
        final class_265 entityShape = class_259.method_1078((class_238)entityBox);
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<class_265>(Long.MAX_VALUE, 1280){
            boolean skipWorldBorderCheck;
            {
                super(x0, x1);
                this.skipWorldBorderCheck = entity == null;
            }

            @Override
            public boolean tryAdvance(Consumer<? super class_265> consumer) {
                if (!this.skipWorldBorderCheck) {
                    this.skipWorldBorderCheck = true;
                    class_2784 border = world.method_8621();
                    boolean isInsideBorder = LithiumEntityCollisions.isBoxFullyWithinWorldBorder(border, entity.method_5829().method_1011(1.0E-7));
                    boolean isCrossingBorder = LithiumEntityCollisions.isBoxFullyWithinWorldBorder(border, entity.method_5829().method_1014(1.0E-7));
                    if (!isInsideBorder && isCrossingBorder) {
                        consumer.accept((class_265)border.method_17903());
                        return true;
                    }
                }
                while (cuboidIt.method_17963()) {
                    class_265 blockShape;
                    class_1922 chunk;
                    int x = cuboidIt.method_18671();
                    int y = cuboidIt.method_18672();
                    int z = cuboidIt.method_18673();
                    int edgesHit = cuboidIt.method_20789();
                    if (edgesHit == 3 || (chunk = world.method_22338(x >> 4, z >> 4)) == null) continue;
                    pos.method_10103(x, y, z);
                    class_2680 state = chunk.method_8320((class_2338)pos);
                    if (edgesHit == 1 && !state.method_17900() || edgesHit == 2 && state.method_11614() != class_2246.field_10008 || (blockShape = state.method_16337((class_1922)world, (class_2338)pos, context)) == class_259.method_1073()) continue;
                    if (blockShape == class_259.method_1077()) {
                        if (!entityBox.method_1003((double)x, (double)y, (double)z, (double)x + 1.0, (double)y + 1.0, (double)z + 1.0)) continue;
                        consumer.accept((class_265)blockShape.method_1096((double)x, (double)y, (double)z));
                        return true;
                    }
                    class_265 shape = blockShape.method_1096((double)x, (double)y, (double)z);
                    if (!class_259.method_1074((class_265)shape, (class_265)entityShape, (class_247)class_247.field_16896)) continue;
                    consumer.accept((class_265)shape);
                    return true;
                }
                return false;
            }
        }, false);
    }

    public static boolean isBoxFullyWithinWorldBorder(class_2784 border, class_238 box) {
        double wboxMinX = Math.floor(border.method_11976());
        double wboxMinZ = Math.floor(border.method_11958());
        double wboxMaxX = Math.ceil(border.method_11963());
        double wboxMaxZ = Math.ceil(border.method_11977());
        return box.field_1323 >= wboxMinX && box.field_1323 < wboxMaxX && box.field_1321 >= wboxMinZ && box.field_1321 < wboxMaxZ && box.field_1320 >= wboxMinX && box.field_1320 < wboxMaxX && box.field_1324 >= wboxMinZ && box.field_1324 < wboxMaxZ;
    }

    public static Stream<class_265> getEntityCollisions(class_1924 view, class_1297 entity, class_238 box, Set<class_1297> excluded) {
        if (box.method_995() < 1.0E-7) {
            return Stream.empty();
        }
        class_238 selection = box.method_1014(1.0E-7);
        List entities = view.method_8335(entity, selection);
        ArrayList<class_265> shapes = new ArrayList<class_265>();
        for (class_1297 otherEntity : entities) {
            class_238 otherEntityHardBox;
            if (!excluded.isEmpty() && excluded.contains(otherEntity) || entity != null && entity.method_5794(otherEntity)) continue;
            class_238 otherEntityBox = otherEntity.method_5827();
            if (otherEntityBox != null && selection.method_994(otherEntityBox)) {
                shapes.add(class_259.method_1078((class_238)otherEntityBox));
            }
            if (entity == null || (otherEntityHardBox = entity.method_5708(otherEntity)) == null || !selection.method_994(otherEntityHardBox)) continue;
            shapes.add(class_259.method_1078((class_238)otherEntityHardBox));
        }
        return shapes.stream();
    }
}

