/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.shapes;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.List;
import net.minecraft.class_2335;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_251;
import net.minecraft.class_265;

public class VoxelShapeSimpleCube
extends class_265 {
    private static final double EPSILON = 1.0E-7;
    private final double x1;
    private final double y1;
    private final double z1;
    private final double x2;
    private final double y2;
    private final double z2;

    public VoxelShapeSimpleCube(class_251 voxels, double x1, double y1, double z1, double x2, double y2, double z2) {
        super(voxels);
        this.x1 = x1;
        this.y1 = y1;
        this.z1 = z1;
        this.x2 = x2;
        this.y2 = y2;
        this.z2 = z2;
    }

    public class_265 method_1096(double x, double y, double z) {
        return new VoxelShapeSimpleCube(this.field_1401, this.x1 + x, this.y1 + y, this.z1 + z, this.x2 + x, this.y2 + y, this.z2 + z);
    }

    public double method_1103(class_2335 cycleDirection, class_238 box, double maxDist) {
        if (Math.abs(maxDist) < 1.0E-7) {
            return 0.0;
        }
        double penetration = this.calculatePenetration(cycleDirection, box, maxDist);
        if (penetration != maxDist && this.intersects(cycleDirection, box)) {
            return penetration;
        }
        return maxDist;
    }

    private double calculatePenetration(class_2335 dir, class_238 box, double maxDist) {
        switch (dir) {
            case field_10962: {
                return this.calculatePenetration(this.x1, this.x2, box.field_1323, box.field_1320, maxDist);
            }
            case field_10963: {
                return this.calculatePenetration(this.z1, this.z2, box.field_1321, box.field_1324, maxDist);
            }
            case field_10965: {
                return this.calculatePenetration(this.y1, this.y2, box.field_1322, box.field_1325, maxDist);
            }
        }
        throw new IllegalArgumentException();
    }

    private boolean intersects(class_2335 dir, class_238 box) {
        switch (dir) {
            case field_10962: {
                return VoxelShapeSimpleCube.lessThan(this.y1, box.field_1325) && VoxelShapeSimpleCube.lessThan(box.field_1322, this.y2) && VoxelShapeSimpleCube.lessThan(this.z1, box.field_1324) && VoxelShapeSimpleCube.lessThan(box.field_1321, this.z2);
            }
            case field_10963: {
                return VoxelShapeSimpleCube.lessThan(this.x1, box.field_1320) && VoxelShapeSimpleCube.lessThan(box.field_1323, this.x2) && VoxelShapeSimpleCube.lessThan(this.y1, box.field_1325) && VoxelShapeSimpleCube.lessThan(box.field_1322, this.y2);
            }
            case field_10965: {
                return VoxelShapeSimpleCube.lessThan(this.z1, box.field_1324) && VoxelShapeSimpleCube.lessThan(box.field_1321, this.z2) && VoxelShapeSimpleCube.lessThan(this.x1, box.field_1320) && VoxelShapeSimpleCube.lessThan(box.field_1323, this.x2);
            }
        }
        throw new IllegalArgumentException();
    }

    private double calculatePenetration(double a1, double a2, double b1, double b2, double maxDist) {
        double penetration;
        if (maxDist > 0.0) {
            penetration = a1 - b2;
            if (penetration < -1.0E-7 || maxDist < penetration) {
                return maxDist;
            }
            if (penetration < 1.0E-7) {
                return 0.0;
            }
        } else {
            penetration = a2 - b1;
            if (penetration > 1.0E-7 || maxDist > penetration) {
                return maxDist;
            }
            if (penetration > -1.0E-7) {
                return 0.0;
            }
        }
        return penetration;
    }

    public List<class_238> method_1090() {
        return Lists.newArrayList((Object[])new class_238[]{this.method_1107()});
    }

    public class_238 method_1107() {
        return new class_238(this.x1, this.y1, this.z1, this.x2, this.y2, this.z2);
    }

    public double method_1091(class_2350.class_2351 axis) {
        return axis.method_10172(this.x1, this.y1, this.z1);
    }

    public double method_1105(class_2350.class_2351 axis) {
        return axis.method_10172(this.x2, this.y2, this.z2);
    }

    protected double method_1099(class_2350.class_2351 axis, int index) {
        if (index < 0 || index > 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        switch (axis) {
            case field_11048: {
                return index == 0 ? this.x1 : this.x2;
            }
            case field_11052: {
                return index == 0 ? this.y1 : this.y2;
            }
            case field_11051: {
                return index == 0 ? this.z1 : this.z2;
            }
        }
        throw new IllegalArgumentException();
    }

    protected DoubleList method_1109(class_2350.class_2351 axis) {
        switch (axis) {
            case field_11048: {
                return DoubleArrayList.wrap((double[])new double[]{this.x1, this.x2});
            }
            case field_11052: {
                return DoubleArrayList.wrap((double[])new double[]{this.y1, this.y2});
            }
            case field_11051: {
                return DoubleArrayList.wrap((double[])new double[]{this.z1, this.z2});
            }
        }
        throw new IllegalArgumentException();
    }

    protected boolean method_1095(double x, double y, double z) {
        return x >= this.x1 && x < this.x2 && y >= this.y1 && y < this.y2 && z >= this.z1 && z < this.z2;
    }

    public boolean method_1110() {
        return this.x1 + 1.0E-7 > this.x2 || this.y1 + 1.0E-7 > this.y2 || this.z1 + 1.0E-7 > this.z2;
    }

    protected int method_1100(class_2350.class_2351 axis, double coord) {
        if (coord < this.method_1091(axis)) {
            return -1;
        }
        if (coord >= this.method_1105(axis)) {
            return 1;
        }
        return 0;
    }

    private static boolean lessThan(double a, double b) {
        return a + 1.0E-7 < b;
    }
}

